/******************************************************************************
*                                                                             *
*    DataCutter.c                           Copyright(c) 2005-2010 itow,y.    *
*                                                                             *
******************************************************************************/

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <windows.h>
#include <commctrl.h>
#include <shlobj.h>
#include <tchar.h>
#include <htmlhelp.h>
#include "DataCutter.h"
#include "Extract.h"
#include "SplitBar.h"
#include "Preview.h"
#include "Formats.h"
#include "FileUtil.h"
#include "Util.h"
#include "resource.h"
#include "Version.h"
#include "Help/Help.h"
#include "Help/TextPopups.h"

#pragma comment(lib, "comctl32.lib")
#pragma comment(lib, "shell32.lib")


#define MAX_MESSAGE_LENGTH 256
#define MAX_ADDRESS_DIGITS (sizeof(DataSizeType)*2)

#define MAIN_WINDOW_CLASS			TEXT("DataCutter Main Form")
#define DATALIST_FORM_WINDOW_CLASS	TEXT("DataCutter Data List Form")
#define TITLE_TEXT TEXT("DataCutter")

/* f[^̎ */
typedef enum {
	DATATYPE_IMAGE,	/* 摜 */
	DATATYPE_SOUND,	/*  */
	DATATYPE_VIDEO	/* f */
} DataType;
#define DATATYPE_FLAG(type) (1<<(type))
#define DATATYPE_FLAG_IMAGE	DATATYPE_FLAG(DATATYPE_IMAGE)
#define DATATYPE_FLAG_SOUND	DATATYPE_FLAG(DATATYPE_SOUND)
#define DATATYPE_FLAG_VIDEO	DATATYPE_FLAG(DATATYPE_VIDEO)

#define NUM_DATA_TYPES 3


/*
	O[oϐ
*/

HINSTANCE hInst;	/* CX^Xnh */


/*
	[Jϐ
*/

static HWND hwndMain;				/* CEBhẼnh */
static HACCEL haccel;				/* ANZ[^̃nh */
static HWND hwndToolbar;			/* c[o[̃nh */
static HIMAGELIST himlToolbar=NULL;	/* c[o[̃ACR */
static HWND hwndStatusBar;			/* Xe[^Xo[̃nh */
static HWND hwndSplitBar;			/* Xvbgo[̃nh */
static HWND hwndDataListForm;		/* f[^Xg̃tH[̃nh */
static HWND hwndDataListTab;		/* f[^Xg̃^ũnh */
static HWND hwndDataList[NUM_DATA_TYPES];
									/* f[^XgEBhẼnh */
static HWND hwndPreview;			/* vr[EBhẼnh */

static TCHAR szIniFileName[MAX_PATH];		/* INIt@C */
static TCHAR szHelpFileName[MAX_PATH];		/* wvt@C */
static TCHAR szFileOpenDirectory[MAX_PATH];	/* t@CJfBNg */
static int nFileOpenFilterIndex=1;			/* Jt@C̃CfbNX */
static TCHAR szFileSaveDirectory[MAX_PATH];	/* t@CۑfBNg */
static int nListSaveFilterIndex=1;			/* ۑt@C̃CfbNX */

static DataType CurDataListType=DATATYPE_IMAGE;	/* ANeBuȃf[^̎ */

static BOOL fAskOverWrite=TRUE;				/* ㏑ۑ̊mF */
static BOOL fShowFullPathName=FALSE;		/* ^Cgo[ɃtpX\ */
static BOOL fShowTipHelp=TRUE;				/* `bvwv\ */
static UINT uMaxFileLoadSize=256*(1024*1024);	/* ǂݍލőTCY */
static BOOL fNoticeSizeLimit=TRUE;			/* őTCY𒴂ꍇm点 */

/* CEBhËʒu */
#define WINDOWPOS_DEFAULT 32767
static struct {
	int Left;
	int Top;
	int Width;
	int Height;
	BOOL fMaximized;
} MainWindowPos = {
	WINDOWPOS_DEFAULT,WINDOWPOS_DEFAULT,640,480,FALSE
};
static BOOL fShowToolbar=TRUE;		/* c[o[̕\ */
static BOOL fShowStatusBar=TRUE;	/* Xe[^Xo[̕\ */
static int SplitterPos=400;			/* Xvb^[̈ʒu */

/* 摜̃J */
enum {
	IMAGECOLUMN_CHECK,
	IMAGECOLUMN_ADDRESS,
	IMAGECOLUMN_IMAGESIZE,
	IMAGECOLUMN_BITSPERPIXEL,
	IMAGECOLUMN_DATASIZE,
	NUM_IMAGE_COLUMNS
};
static const LPCTSTR pszImageListColumnName[NUM_IMAGE_COLUMNS] = {
	TEXT("Save"),
	TEXT("Address"),
	TEXT("ImageSize"),
	TEXT("BitsPerPixel"),
	TEXT("DataSize"),
};
static int ImageListColumnWidth[NUM_IMAGE_COLUMNS] = {40,72,80,40,72};

/* ̃J */
enum {
	SOUNDCOLUMN_CHECK,
	SOUNDCOLUMN_ADDRESS,
	SOUNDCOLUMN_LENGTH,
	SOUNDCOLUMN_CHANNELS,
	SOUNDCOLUMN_DATASIZE,
	NUM_SOUND_COLUMNS
};
static const LPCTSTR pszSoundListColumnName[NUM_IMAGE_COLUMNS] = {
	TEXT("Save"),
	TEXT("Address"),
	TEXT("Length"),
	TEXT("Channels"),
	TEXT("DataSize"),
};
static int SoundListColumnWidth[NUM_SOUND_COLUMNS] = {40,72,72,40,72};

/* f̃J */
enum {
	VIDEOCOLUMNS_CHECK,
	VIDEOCOLUMNS_ADDRESS,
	VIDEOCOLUMNS_VIDEOSIZE,
	VIDEOCOLUMNS_LENGTH,
	VIDEOCOLUMNS_DATASIZE,
	NUM_VIDEO_COLUMNS
};
static const LPCTSTR pszVideoListColumnName[NUM_IMAGE_COLUMNS] = {
	TEXT("Save"),
	TEXT("Address"),
	TEXT("VideoSize"),
	TEXT("Length"),
	TEXT("DataSize"),
};
static int VideoListColumnWidth[NUM_VIDEO_COLUMNS] = {40,72,72,72,72};

/* etH[}bg̊gq */
static const LPCTSTR pszFormatExtensionList[] = {
	TEXT("bmp"),
	TEXT("jpg"),
	TEXT("png"),
	TEXT("mag"),
	TEXT("ico"),
	TEXT("cur"),
	TEXT("ani"),
	TEXT("wav"),
	TEXT("mid"),
	TEXT("mp3"),
	TEXT("avi"),
};

typedef struct {
	FormatType Format;
	DataSizeType Address;
	DataSizeType Size;
} DataInfo;

typedef struct tagDataItemInfo {
	DataInfo Data;
	struct tagDataItemInfo *pNext;
} DataListItemInfo;

typedef struct {
	int nNumItems;
	DataListItemInfo *pFirst;
	DataListItemInfo *pLast;
} DataListInfo;

typedef struct {
	TCHAR szFileName[MAX_PATH];
	ULONGLONG ullFileSize;
	void *pData;
	DataSizeType DataSize;
	DataType CurDataType;
	struct {
		DataListInfo List;
		int nCurSortColumn;
		BOOL fSortAscending;
		int nSelItem;
	} DataList[NUM_DATA_TYPES];
	int nDataCount;
	UINT uSearchTime;
} SourceFileInfo;

static SourceFileInfo *pCurrentSourceFile=NULL;

typedef enum {
	OVERWRITE_OVERWRITE,
	OVERWRITE_ASK,
	OVERWRITE_SKIP,
	OVERWRITE_SHIFT
} OverWriteMode;
#define OVERWRITE_LAST OVERWRITE_SHIFT

static TCHAR szSaveAllFileName[MAX_PATH]=TEXT("Data_");
static int nSaveAllMinDigits=0;
static int nSaveAllFirstNumber=1;
static OverWriteMode SaveAllOverWriteMode=OVERWRITE_ASK;

typedef struct {
	TCHAR szFileName[MAX_PATH];
	UINT uDataCount[NUM_DATA_TYPES];
} BatchFileInfo;

static BatchFileInfo *pBatchFileList=NULL;
static int nBatchNumFiles;
static BOOL fBatchOutSpecDirectory=TRUE;
static TCHAR szBatchOutDirectory[MAX_PATH];
static UINT uBatchExtractDataType=
			DATATYPE_FLAG_IMAGE | DATATYPE_FLAG_SOUND | DATATYPE_FLAG_VIDEO;
static int nBatchMinDigits=0;
static int nBatchFirstNumber=1;
static OverWriteMode BatchOverWriteMode=OVERWRITE_ASK;
static BOOL fBatchAskOverWrite=TRUE;
static BOOL fBatchShowReport=TRUE;

static HMODULE hHtmlHelpLib=NULL;
typedef HWND (WINAPI *HtmlHelpFunc)(HWND hwndCaller,LPCTSTR pszFile,
												UINT uCommand,DWORD dwData);
static HtmlHelpFunc pfnHtmlHelp=NULL;
static DWORD dwHtmlHelpCookie=0;




/******************************************************************************

	[eBeB֐

******************************************************************************/


/*
	\[X̕ŃbZ[W{bNX\
*/
static int ResMessageBox(HWND hwndOwner,UINT TextID,UINT CaptionID,UINT Type)
{
	TCHAR szText[MAX_MESSAGE_LENGTH],szCaption[MAX_MESSAGE_LENGTH];

	if (LoadString(hInst,TextID,szText,numberof(szText))<=0)
		return 0;
	if (CaptionID!=0) {
		if (LoadString(hInst,CaptionID,szCaption,numberof(szCaption))<=0)
			return 0;
	}
	return MessageBox(hwndOwner,szText,CaptionID!=0?szCaption:NULL,Type);
}


/*
	G[̃bZ[W{bNX\
*/
static int ErrMessageBox(HWND hwndOwner,ErrorType Err,UINT Type)
{
	return ResMessageBox(hwndOwner,IDS_ERRORBASE+(int)Err,0,Type);
}


/*
	_CAÖʒuw肵EBhEɒ
*/
static void AdjustDialogPos(HWND hwndOwner,HWND hwndDlg)
{
	HMONITOR hMonitor;
	MONITORINFO mi;
	RECT rcWnd,rcDlg;
	int x,y;

	hMonitor=MonitorFromWindow(hwndOwner,MONITOR_DEFAULTTONEAREST);
	mi.cbSize=sizeof(mi);
	GetMonitorInfo(hMonitor,&mi);
	GetWindowRect(hwndOwner,&rcWnd);
	GetWindowRect(hwndDlg,&rcDlg);
	x=((rcWnd.right-rcWnd.left)-(rcDlg.right-rcDlg.left))/2+rcWnd.left;
	if (x<mi.rcWork.left)
		x=mi.rcWork.left;
	else if (x+(rcDlg.right-rcDlg.left)>mi.rcWork.right)
		x=mi.rcWork.right-(rcDlg.right-rcDlg.left);
	y=((rcWnd.bottom-rcWnd.top)-(rcDlg.bottom-rcDlg.top))/2+rcWnd.top;
	if (y<mi.rcWork.top)
		y=mi.rcWork.top;
	else if (y+(rcDlg.bottom-rcDlg.top)>mi.rcWork.bottom)
		y=mi.rcWork.bottom-(rcDlg.bottom-rcDlg.top);
	SetWindowPos(hwndDlg,NULL,x,y,0,0,SWP_NOSIZE | SWP_NOZORDER);
}


/*
	𕄍tɕϊ
*/
static int StringToInt(LPCTSTR pszValue)
{
	int Value=0;
	LPCTSTR p=pszValue;

	if (*p=='-' || *p=='+')
		p++;
	while (*p!='\0') {
		if (*p>='0' && *p<='9')
			Value=Value*10+(*p-'0');
		else
			break;
		p++;
	}
	return pszValue[0]=='-'?-Value:Value;
}


/*
	l𕶎ɕϊ
*/
static LPTSTR IntToString(LPTSTR pszString,int Value,int MinDigits)
{
	int Tmp;
	int i;
	LPTSTR p;

	Tmp=Value/10;
	for (i=1;Tmp!=0;i++)
		Tmp/=10;
	p=pszString+max(i,MinDigits);
	*p='\0';
	do {
		*--p='0'+Value%10;
		Value/=10;
	} while (Value!=0);
	while (p>pszString)
		*--p='0';
	return pszString;
}


/*
	ltH[}bg
*/
static LPTSTR FormatUInt(UINT Value,LPTSTR pszNumber,int NumberSize)
{
	TCHAR szValue[16];
	TCHAR szDecimal[4];
	LPTSTR p;

	wsprintf(szValue,TEXT("%u"),Value);
	GetNumberFormat(LOCALE_USER_DEFAULT,0,szValue,NULL,pszNumber,NumberSize);
	GetLocaleInfo(LOCALE_USER_DEFAULT,LOCALE_SDECIMAL,szDecimal,
														numberof(szDecimal));
	p=pszNumber;
	while (*p!='\0') {
		if (*p==szDecimal[0]) {
			*p='\0';
			break;
		}
		p++;
	}
	return pszNumber;
}

#ifndef UNICODE
#define FormatUIntA FormatUInt
#else
static LPSTR FormatUIntA(UINT Value,LPSTR pszNumber,int NumberSize)
{
	char szValue[16];
	char szDecimal[4];
	LPSTR p;

	wsprintfA(szValue,"%u",Value);
	GetNumberFormatA(LOCALE_USER_DEFAULT,0,szValue,NULL,pszNumber,NumberSize);
	GetLocaleInfoA(LOCALE_USER_DEFAULT,LOCALE_SDECIMAL,szDecimal,
														numberof(szDecimal));
	p=pszNumber;
	while (*p!='\0') {
		if (*p==szDecimal[0]) {
			*p='\0';
			break;
		}
		p++;
	}
	return pszNumber;
}
#endif


/*
	64rbg̕ltH[}bg
*/
LPTSTR FormatUInt64(ULONGLONG ullValue,LPTSTR pszNumber,int NumberSize)
{
	ULONGLONG ullTmp;
	TCHAR szValue[20];
	TCHAR szDecimal[4];
	LPTSTR p;

	p=szValue+1;
	ullTmp=ullValue/10;
	while (ullTmp>0) {
		p++;
		ullTmp/=10;
	}
	*p='\0';
	ullTmp=ullValue;
	do {
		*--p='0'+(TCHAR)(ullTmp%10);
		ullTmp/=10;
	} while (ullTmp>0);
	GetNumberFormat(LOCALE_USER_DEFAULT,0,szValue,NULL,pszNumber,NumberSize);
	GetLocaleInfo(LOCALE_USER_DEFAULT,LOCALE_SDECIMAL,szDecimal,
														numberof(szDecimal));
	p=pszNumber;
	while (*p!='\0') {
		if (*p==szDecimal[0]) {
			*p='\0';
			break;
		}
		p++;
	}
	return pszNumber;
}


#ifndef UNICODE
#define FormatUInt64A FormatUInt64
#else
LPSTR FormatUInt64A(ULONGLONG ullValue,LPSTR pszNumber,int NumberSize)
{
	ULONGLONG ullTmp;
	char szValue[20];
	char szDecimal[4];
	LPSTR p;

	p=szValue+1;
	ullTmp=ullValue/10;
	while (ullTmp>0) {
		p++;
		ullTmp/=10;
	}
	*p='\0';
	ullTmp=ullValue;
	do {
		*--p='0'+(char)(ullTmp%10);
		ullTmp/=10;
	} while (ullTmp>0);
	GetNumberFormatA(LOCALE_USER_DEFAULT,0,szValue,NULL,pszNumber,NumberSize);
	GetLocaleInfoA(LOCALE_USER_DEFAULT,LOCALE_SDECIMAL,szDecimal,
														numberof(szDecimal));
	p=pszNumber;
	while (*p!='\0') {
		if (*p==szDecimal[0]) {
			*p='\0';
			break;
		}
		p++;
	}
	return pszNumber;
}
#endif


/*
	ԂtH[}bg
*/
static LPTSTR FormatTime(UINT uTime,LPTSTR pszText)
{
	TCHAR szTmp[16],szDecimal[4];

	if (uTime/3600000>0) {
		wsprintf(szTmp,TEXT("%d:"),uTime/3600000);
		lstrcpy(pszText,szTmp);
	} else
		pszText[0]='\0';
	if (uTime/60000>0) {
		wsprintf(szTmp,(uTime/3600000>0)?TEXT("%02d:"):TEXT("%d:"),
															uTime/60000%60);
		lstrcat(pszText,szTmp);
	}
	GetLocaleInfo(LOCALE_USER_DEFAULT,LOCALE_SDECIMAL,szDecimal,
														numberof(szDecimal));
	wsprintf(szTmp,(uTime/60000>0)?TEXT("%02d%s%03d"):TEXT("%d%s%03d"),
										uTime/1000%60,szDecimal,uTime%1000);
	lstrcat(pszText,szTmp);
	return pszText;
}

#ifndef UNICODE
#define FormatTimeA FormatTime
#else
static LPSTR FormatTimeA(UINT uTime,LPSTR pszText)
{
	char szTmp[16],szDecimal[4];

	if (uTime/3600000>0) {
		wsprintfA(szTmp,"%d:",uTime/3600000);
		lstrcpyA(pszText,szTmp);
	} else
		pszText[0]='\0';
	if (uTime/60000>0) {
		wsprintfA(szTmp,(uTime/3600000>0)?"%02d:":"%d:",uTime/60000%60);
		lstrcatA(pszText,szTmp);
	}
	GetLocaleInfoA(LOCALE_USER_DEFAULT,LOCALE_SDECIMAL,szDecimal,
														numberof(szDecimal));
	wsprintfA(szTmp,(uTime/60000>0)?"%02d%s%03d":"%d%s%03d",
										uTime/1000%60,szDecimal,uTime%1000);
	lstrcatA(pszText,szTmp);
	return pszText;
}
#endif


#ifndef WIN64
#define FormatSize	FormatUInt
#define FormatSizeA	FormatUIntA
#else
#define FormatSize	FormatUInt64
#define FormatSizeA	FormatUInt64A
#endif


/*
	AhXtH[}bg
*/
static LPTSTR FormatAddress(DataSizeType Address,LPTSTR pszString)
{
	static const TCHAR cHex[]=TEXT("0123456789ABCDEF");
	DataSizeType Tmp;
	int i;
	LPTSTR p;

	Tmp=Address/16;
	for (i=1;Tmp!=0;i++)
		Tmp/=16;
	p=pszString+max(i,MAX_ADDRESS_DIGITS);
	*p='\0';
	do {
		*--p=cHex[Address%16];
		Address/=16;
	} while (Address!=0);
	while (p>pszString)
		*--p='0';
	return pszString;
}

#ifndef UNICODE
#define FormatAddressA FormatAddress
#else
static LPSTR FormatAddressA(DataSizeType Address,LPSTR pszString)
{
	static const char cHex[]="0123456789ABCDEF";
	DataSizeType Tmp;
	int i;
	LPSTR p;

	Tmp=Address/16;
	for (i=1;Tmp!=0;i++)
		Tmp/=16;
	p=pszString+max(i,MAX_ADDRESS_DIGITS);
	*p='\0';
	do {
		*--p=cHex[Address%16];
		Address/=16;
	} while (Address!=0);
	while (p>pszString)
		*--p='0';
	return pszString;
}
#endif


/*
	߂
*/
static int CountDigits(int nValue)
{
	int i;

	nValue/=10;
	for (i=1;nValue!=0;i++)
		nValue/=10;
	return i;
}


/*
	OPENFILENAME\̂
*/
static void InitOpenFileNameStruct(OPENFILENAME *pofn)
{
#if _WIN32_WINNT>=0x0500
	pofn->lStructSize=OPENFILENAME_SIZE_VERSION_400;
#else
	pofn->lStructSize=sizeof(OPENFILENAME);
#endif
	pofn->hwndOwner=NULL;
	pofn->lpstrCustomFilter=NULL;
	pofn->nFilterIndex=1;
	pofn->lpstrFileTitle=NULL;
	pofn->lpstrInitialDir=NULL;
	pofn->lpstrTitle=NULL;
	pofn->Flags=0;
	pofn->lpstrDefExt=NULL;
}


/*
	tH_̎Q
*/
#ifdef __BORLANDC__
#pragma argsused
#endif
static int CALLBACK BrowseFolderCallback(HWND hWnd,UINT uMsg,LPARAM lpData,
																LPARAM lParam)
{
	switch (uMsg) {
	case BFFM_INITIALIZED:
		if (((LPTSTR)lParam)[0]!='\0') {
			TCHAR szDirectory[MAX_PATH];

			lstrcpy(szDirectory,(LPTSTR)lParam);
			RemoveDirectoryBackslash(szDirectory);
			SendMessage(hWnd,BFFM_SETSELECTION,TRUE,(LPARAM)szDirectory);
		}
		break;
	}
	return 0;
}

static BOOL BrowseFolderDialog(HWND hwndOwner,LPTSTR pszDirectory,
															LPCTSTR pszTitle)
{
	BROWSEINFO bi;
	PIDLIST_ABSOLUTE pidl;
	BOOL fRet;

	bi.hwndOwner=hwndOwner;
	bi.pidlRoot=NULL;
	bi.pszDisplayName=pszDirectory;
	bi.lpszTitle=pszTitle;
	bi.ulFlags=BIF_RETURNONLYFSDIRS;
	bi.lpfn=BrowseFolderCallback;
	bi.lParam=(LPARAM)pszDirectory;
	pidl=SHBrowseForFolder(&bi);
	if (pidl==NULL)
		return FALSE;
	fRet=SHGetPathFromIDList(pidl,pszDirectory);
	CoTaskMemFree(pidl);
	return fRet;
}


/*
	㏑ۑ̊mF_CAO\
*/
static int OverWriteDialog(HWND hwndOwner,LPCTSTR pszFileName,UINT uType)
{
	TCHAR szFormat[256];
	TCHAR szText[MAX_PATH+256],szCaption[64];

	if (LoadString(hInst,IDS_OVERWRITE,szFormat,numberof(szFormat))<=0
			|| LoadString(hInst,IDS_OVERWRITECAPTION,szCaption,
													numberof(szCaption))<=0)
		return 0;
	wsprintf(szText,szFormat,pszFileName);
	return MessageBox(hwndOwner,szText,szCaption,uType);
}


/*
	HTMLwṽCu[h
*/
static BOOL LoadHtmlHelpLibrary(void)
{
	if (pfnHtmlHelp!=NULL)
		return TRUE;
	hHtmlHelpLib=LoadLibrary(TEXT("hhctrl.ocx"));
	if (hHtmlHelpLib==NULL)
		return FALSE;
	pfnHtmlHelp=(HtmlHelpFunc)GetProcAddress(hHtmlHelpLib,
#ifndef UNICODE
											"HtmlHelpA"
#else
											"HtmlHelpW"
#endif
											);
	if (pfnHtmlHelp==NULL) {
		FreeLibrary(hHtmlHelpLib);
		hHtmlHelpLib=NULL;
		return FALSE;
	}
	(*pfnHtmlHelp)(NULL,NULL,HH_INITIALIZE,(DWORD)&dwHtmlHelpCookie);
	return TRUE;
}


/*
	wv\
*/
static void ShowHelp(int ID)
{
	if (LoadHtmlHelpLibrary())
		(*pfnHtmlHelp)(NULL,szHelpFileName,HH_HELP_CONTEXT,ID);
}


/*
	t@C_CAÕtB^[h
*/
static BOOL LoadFileFilter(int ID,LPTSTR pszFilter,int MaxLength)
{
	LPTSTR p;

	if (LoadString(hInst,ID,pszFilter,MaxLength)<=0) {
		wsprintf(pszFilter,TEXT("All(*.*)%c*.*%c"),'\0','\0');
		return FALSE;
	}
	p=pszFilter;
	while (*p!='\0') {
		if (*p=='|')
			*p='\0';
#ifndef UNICODE
		else if (IsDBCSLeadByteEx(CP_ACP,*p) && *(p+1)!='\0')
			p++;
#endif
		p++;
	}
	return TRUE;
}


/*
	R{{bNX̃Xgݒ肷
*/
static void SetComboBoxList(HWND hDlg,int ID,LPTSTR pszList)
{
	LPTSTR p,q;

	p=pszList;
	while (*p!='\0') {
		q=p;
		while (*q!='\n' && *q!='\0')
			q++;
		if (*q!='\0')
			*q++='\0';
		SendDlgItemMessage(hDlg,ID,CB_ADDSTRING,0,(LPARAM)p);
		p=q;
	}
}




/******************************************************************************

	ݒ֐

******************************************************************************/


/*
	INIt@Cintl
*/
static BOOL WritePrivateProfileInt(LPCTSTR pszSection,LPCTSTR pszKey,
												int nValue,LPCTSTR pszFile)
{
	TCHAR szValue[16];

	wsprintf(szValue,TEXT("%d"),nValue);
	return WritePrivateProfileString(pszSection,pszKey,szValue,pszFile);
}


/*
	ݒۑ
*/
static void SaveSettings(LPCTSTR pszFileName)
{
	int i;

	WritePrivateProfileInt(TEXT("Settings"),TEXT("WindowLeft"),
											MainWindowPos.Left,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("WindowTop"),
											MainWindowPos.Top,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("WindowWidth"),
											MainWindowPos.Width,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("WindowHeight"),
											MainWindowPos.Height,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("WindowMaximize"),
										MainWindowPos.fMaximized,pszFileName);
	WritePrivateProfileString(TEXT("Settings"),TEXT("FileOpenDir"),
											szFileOpenDirectory,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("FileOpenFilter"),
											nFileOpenFilterIndex,pszFileName);
	WritePrivateProfileString(TEXT("Settings"),TEXT("FileSaveDir"),
											szFileSaveDirectory,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("ListSaveFilter"),
											nListSaveFilterIndex,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("AskOverWrite"),fAskOverWrite,
																pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("ShowFullPath"),
												fShowFullPathName,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("ShowToolTips"),fShowTipHelp,
																pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("MaxLoadSize"),
												uMaxFileLoadSize,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("NoticeSizeLimit"),
												fNoticeSizeLimit,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("ShowToolbar"),fShowToolbar,
																pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("ShowStatusBar"),
												fShowStatusBar,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("SplitterPos"),
													SplitterPos,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("ActiveDataType"),
											(int)CurDataListType,pszFileName);
	WritePrivateProfileString(TEXT("Settings"),TEXT("SaveAllFileName"),
												szSaveAllFileName,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("SaveAllMinDigits"),
												nSaveAllMinDigits,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("SaveAllFirstNumber"),
											nSaveAllFirstNumber,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("SaveAllOverWrite"),
										(int)SaveAllOverWriteMode,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("BatchOutDirType"),
										fBatchOutSpecDirectory,pszFileName);
	WritePrivateProfileString(TEXT("Settings"),TEXT("BatchOutDir"),
											szBatchOutDirectory,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("BatchDataType"),
											uBatchExtractDataType,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("BatchMinDigits"),
												nBatchMinDigits,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("BatchFirstNumber"),
												nBatchFirstNumber,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("BatchOverWrite"),
										(int)BatchOverWriteMode,pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("BatchShowReport"),
												fBatchShowReport,pszFileName);
	for (i=0;i<numberof(ImageListColumnWidth);i++) {
		WritePrivateProfileInt(TEXT("ImageListColumnWidth"),
				pszImageListColumnName[i],ImageListColumnWidth[i],pszFileName);
	}
	for (i=0;i<numberof(SoundListColumnWidth);i++) {
		WritePrivateProfileInt(TEXT("SoundListColumnWidth"),
				pszSoundListColumnName[i],SoundListColumnWidth[i],pszFileName);
	}
	for (i=0;i<numberof(VideoListColumnWidth);i++) {
		WritePrivateProfileInt(TEXT("VideoListColumnWidth"),
				pszVideoListColumnName[i],VideoListColumnWidth[i],pszFileName);
	}
}


/*
	ݒǂݍ
*/
static void LoadSettings(LPCTSTR pszFileName)
{
	TCHAR szText[MAX_PATH];
	int Value;
	int i;

	MainWindowPos.Left=GetPrivateProfileInt(TEXT("Settings"),
						TEXT("WindowLeft"),MainWindowPos.Left,pszFileName);
	MainWindowPos.Top=GetPrivateProfileInt(TEXT("Settings"),
						TEXT("WindowTop"),MainWindowPos.Top,pszFileName);
	MainWindowPos.Width=GetPrivateProfileInt(TEXT("Settings"),
						TEXT("WindowWidth"),MainWindowPos.Width,pszFileName);
	MainWindowPos.Height=GetPrivateProfileInt(TEXT("Settings"),
					TEXT("WindowHeight"),MainWindowPos.Height,pszFileName);
	MainWindowPos.fMaximized=GetPrivateProfileInt(TEXT("Settings"),
			TEXT("WindowMaximize"),MainWindowPos.fMaximized,pszFileName)!=0;
	if (GetPrivateProfileString(TEXT("Settings"),TEXT("FileOpenDir"),NULL,
						szText,numberof(szFileOpenDirectory),pszFileName)>0)
		lstrcpy(szFileOpenDirectory,szText);
	nFileOpenFilterIndex=GetPrivateProfileInt(TEXT("Settings"),
					TEXT("FileOpenFilter"),nFileOpenFilterIndex,pszFileName);
	if (GetPrivateProfileString(TEXT("Settings"),TEXT("FileSaveDir"),NULL,
						szText,numberof(szFileSaveDirectory),pszFileName)>0)
		lstrcpy(szFileSaveDirectory,szText);
	nListSaveFilterIndex=GetPrivateProfileInt(TEXT("Settings"),
					TEXT("ListSaveFilter"),nListSaveFilterIndex,pszFileName);
	fAskOverWrite=GetPrivateProfileInt(TEXT("Settings"),TEXT("AskOverWrite"),
												fAskOverWrite,pszFileName)!=0;
	fShowFullPathName=GetPrivateProfileInt(TEXT("Settings"),
						TEXT("ShowFullPath"),fShowFullPathName,pszFileName)!=0;
	fShowTipHelp=GetPrivateProfileInt(TEXT("Settings"),TEXT("ShowToolTips"),
												fShowTipHelp,pszFileName)!=0;
	uMaxFileLoadSize=GetPrivateProfileInt(TEXT("Settings"),TEXT("MaxLoadSize"),
												uMaxFileLoadSize,pszFileName);
	fNoticeSizeLimit=GetPrivateProfileInt(TEXT("Settings"),
					TEXT("NoticeSizeLimit"),fNoticeSizeLimit,pszFileName)!=0;
	fShowToolbar=GetPrivateProfileInt(TEXT("Settings"),TEXT("ShowToolbar"),
												fShowToolbar,pszFileName)!=0;
	fShowStatusBar=GetPrivateProfileInt(TEXT("Settings"),TEXT("ShowStatusBar"),
												fShowStatusBar,pszFileName)!=0;
	SplitterPos=GetPrivateProfileInt(TEXT("Settings"),TEXT("SplitterPos"),
													SplitterPos,pszFileName);
	CurDataListType=(DataType)GetPrivateProfileInt(TEXT("Settings"),
						TEXT("ActiveDataType"),CurDataListType,pszFileName);
	if (CurDataListType<0 || CurDataListType>=NUM_DATA_TYPES)
		CurDataListType=DATATYPE_IMAGE;
	if (GetPrivateProfileString(TEXT("Settings"),TEXT("SaveAllFileName"),NULL,
							szText,numberof(szSaveAllFileName),pszFileName)>0)
		lstrcpy(szSaveAllFileName,szText);
	nSaveAllMinDigits=GetPrivateProfileInt(TEXT("Settings"),
					TEXT("SaveAllMinDigits"),nSaveAllMinDigits,pszFileName);
	nSaveAllFirstNumber=GetPrivateProfileInt(TEXT("Settings"),
				TEXT("SaveAllFirstNumber"),nSaveAllFirstNumber,pszFileName);
	if (GetPrivateProfileString(TEXT("Settings"),TEXT("SaveAllOverWrite"),NULL,
									szText,numberof(szText),pszFileName)>0) {
		Value=StringToInt(szText);
		if (Value>=0 && Value<=OVERWRITE_LAST)
			SaveAllOverWriteMode=(OverWriteMode)Value;
	} else if (GetPrivateProfileString(TEXT("Settings"),
					TEXT("SaveAllAskOverWrite"),NULL,szText,numberof(szText),
															pszFileName)>0) {
		/* 0.3.0 ȑOƂ̌݊ */
		SaveAllOverWriteMode=StringToInt(szText)==0?
											OVERWRITE_OVERWRITE:OVERWRITE_ASK;
	}
	fBatchOutSpecDirectory=GetPrivateProfileInt(TEXT("Settings"),
				TEXT("BatchOutDirType"),fBatchOutSpecDirectory,pszFileName)!=0;
	if (GetPrivateProfileString(TEXT("Settings"),TEXT("BatchOutDir"),NULL,
						szText,numberof(szBatchOutDirectory),pszFileName)>0)
		lstrcpy(szBatchOutDirectory,szText);
	uBatchExtractDataType=GetPrivateProfileInt(TEXT("Settings"),
					TEXT("BatchDataType"),uBatchExtractDataType,pszFileName);
	nBatchMinDigits=GetPrivateProfileInt(TEXT("Settings"),
						TEXT("BatchMinDigits"),nBatchMinDigits,pszFileName);
	nBatchFirstNumber=GetPrivateProfileInt(TEXT("Settings"),
					TEXT("BatchFirstNumber"),nBatchFirstNumber,pszFileName);
	if (GetPrivateProfileString(TEXT("Settings"),TEXT("BatchOverWrite"),NULL,
									szText,numberof(szText),pszFileName)>0) {
		Value=StringToInt(szText);
		if (Value>=0 && Value<=OVERWRITE_LAST)
			BatchOverWriteMode=(OverWriteMode)Value;
	} else if (GetPrivateProfileString(TEXT("Settings"),
					TEXT("BatchAskOverWrite"),NULL,szText,numberof(szText),
															pszFileName)>0) {
		/* 0.3.0 ȑOƂ̌݊ */
		BatchOverWriteMode=StringToInt(szText)==0?
											OVERWRITE_OVERWRITE:OVERWRITE_ASK;
	}
	fBatchShowReport=GetPrivateProfileInt(TEXT("Settings"),
					TEXT("BatchShowReport"),fBatchShowReport,pszFileName)!=0;
	for (i=0;i<numberof(ImageListColumnWidth);i++) {
		ImageListColumnWidth[i]=GetPrivateProfileInt(
						TEXT("ImageListColumnWidth"),pszImageListColumnName[i],
										ImageListColumnWidth[i],pszFileName);
		if (ImageListColumnWidth[i]<0)
			ImageListColumnWidth[i]=0;
	}
	for (i=0;i<numberof(SoundListColumnWidth);i++) {
		SoundListColumnWidth[i]=GetPrivateProfileInt(
						TEXT("SoundListColumnWidth"),pszSoundListColumnName[i],
										SoundListColumnWidth[i],pszFileName);
		if (SoundListColumnWidth[i]<0)
			SoundListColumnWidth[i]=0;
	}
	for (i=0;i<numberof(VideoListColumnWidth);i++) {
		VideoListColumnWidth[i]=GetPrivateProfileInt(
						TEXT("VideoListColumnWidth"),pszVideoListColumnName[i],
										VideoListColumnWidth[i],pszFileName);
		if (VideoListColumnWidth[i]<0)
			VideoListColumnWidth[i]=0;
	}
}




/******************************************************************************

	f[^Xg֐

******************************************************************************/


static void DataList_Init(DataListInfo *pList)
{
	pList->nNumItems=0;
	pList->pFirst=NULL;
	pList->pLast=NULL;
}


static void DataList_Free(DataListInfo *pList)
{
	DataListItemInfo *pCurrent,*pNext;

	pCurrent=pList->pFirst;
	while (pCurrent!=NULL) {
		pNext=pCurrent->pNext;
		MemFree(pCurrent);
		pCurrent=pNext;
	}
	pList->nNumItems=0;
	pList->pFirst=NULL;
	pList->pLast=NULL;
}


static BOOL DataList_AddItem(DataListInfo *pList,DataListItemInfo *pItem)
{
	pItem->pNext=NULL;
	if (pList->pLast!=NULL)
		pList->pLast->pNext=pItem;
	else
		pList->pFirst=pItem;
	pList->pLast=pItem;
	pList->nNumItems++;
	return TRUE;
}


static DataListItemInfo *DataList_GetItem(const DataListInfo *pList,int nNo)
{
	DataListItemInfo *pItem;
	int i;

	pItem=pList->pFirst;
	for (i=0;pItem!=NULL && i<nNo;i++)
		pItem=pItem->pNext;
	return pItem;
}




/******************************************************************************

	EBhE֐

******************************************************************************/


/*
	CEBhẼ^Cgݒ肷
*/
static void SetWindowTitle(const SourceFileInfo *pInfo)
{
	if (pInfo!=NULL) {
		TCHAR szTitle[numberof(TITLE_TEXT)+3+MAX_PATH];

		wsprintf(szTitle,TITLE_TEXT TEXT(" - %s"),fShowFullPathName?
						pInfo->szFileName:GetFileNamePtr(pInfo->szFileName));
		SetWindowText(hwndMain,szTitle);
	} else
		SetWindowText(hwndMain,TITLE_TEXT);
}


#define EnableMenuItemByCommand(hmenu,command,enable) \
	EnableMenuItem(hmenu,command,MF_BYCOMMAND | ((enable)?MFS_ENABLED:MFS_GRAYED))


/*
	j[̏Ԃݒ肷
*/
static void SetMenuStatus(const SourceFileInfo *pInfo)
{
	HMENU hmenu=GetMenu(hwndMain);
	BOOL fListItem,fSelItem;
	const DataListItemInfo *pItem;
	BOOL fCanCopy;

	fListItem=
		pInfo!=NULL && pInfo->DataList[pInfo->CurDataType].List.nNumItems>0;
	fSelItem=pInfo!=NULL && pInfo->DataList[pInfo->CurDataType].nSelItem>=0;
	if (fSelItem)
		pItem=DataList_GetItem(&pInfo->DataList[pInfo->CurDataType].List,
								pInfo->DataList[pInfo->CurDataType].nSelItem);
	fCanCopy=fSelItem && (pInfo->CurDataType==DATATYPE_IMAGE
										|| pItem->Data.Format==FORMAT_WAVE);
	EnableMenuItemByCommand(hmenu,CM_CLOSE,pInfo!=NULL);
	EnableMenuItemByCommand(hmenu,CM_SAVE,fSelItem);
	EnableMenuItemByCommand(hmenu,CM_SAVEALL,fListItem);
	EnableMenuItemByCommand(hmenu,CM_SAVELIST,fListItem);
	EnableMenuItem(hmenu,1,
			MF_BYPOSITION | (fListItem || fSelItem?MFS_ENABLED:MFS_GRAYED));
	EnableMenuItemByCommand(hmenu,CM_COPY,fCanCopy);
	EnableMenuItemByCommand(hmenu,CM_DATAINFO,fSelItem);
	EnableMenuItemByCommand(hmenu,CM_CHECKALL,fListItem);
	EnableMenuItemByCommand(hmenu,CM_UNCHECKALL,fListItem);
	EnableMenuItemByCommand(hmenu,CM_INVERTCHECK,fListItem);
	DrawMenuBar(hwndMain);
	SendMessage(hwndToolbar,TB_ENABLEBUTTON,CM_SAVE,fSelItem);
	SendMessage(hwndToolbar,TB_ENABLEBUTTON,CM_SAVEALL,fListItem);
	SendMessage(hwndToolbar,TB_ENABLEBUTTON,CM_SAVELIST,fListItem);
	SendMessage(hwndToolbar,TB_ENABLEBUTTON,CM_COPY,fCanCopy);
	SendMessage(hwndToolbar,TB_ENABLEBUTTON,CM_DATAINFO,fSelItem);
}


/*
	ACȇIύXꂽɃj[̏Ԃݒ肷
*/
static void SetItemChangedMenuStatus(const SourceFileInfo *pInfo)
{
	HMENU hmenu=GetMenu(hwndMain);
	BOOL fSelItem=
				pInfo!=NULL && pInfo->DataList[pInfo->CurDataType].nSelItem>=0;
	const DataListItemInfo *pItem;
	BOOL fCanCopy;

	if (fSelItem)
		pItem=DataList_GetItem(&pInfo->DataList[pInfo->CurDataType].List,
								pInfo->DataList[pInfo->CurDataType].nSelItem);
	EnableMenuItemByCommand(hmenu,CM_SAVE,fSelItem);
	fCanCopy=fSelItem && (pInfo->CurDataType==DATATYPE_IMAGE
										|| pItem->Data.Format==FORMAT_WAVE);
	EnableMenuItemByCommand(hmenu,CM_COPY,fCanCopy);
	EnableMenuItemByCommand(hmenu,CM_DATAINFO,fSelItem);
	EnableMenuItem(hmenu,1,MF_BYPOSITION |
		(fSelItem ||
		(pInfo!=NULL && pInfo->DataList[pInfo->CurDataType].List.nNumItems>0)?
													MFS_ENABLED:MFS_GRAYED));
	DrawMenuBar(hwndMain);
	SendMessage(hwndToolbar,TB_ENABLEBUTTON,CM_SAVE,fSelItem);
	SendMessage(hwndToolbar,TB_ENABLEBUTTON,CM_COPY,fCanCopy);
	SendMessage(hwndToolbar,TB_ENABLEBUTTON,CM_DATAINFO,fSelItem);
}


/*
	f[^̎ނύXꂽɃj[̏Ԃݒ肷
*/
static void SetDataTypeChangedMenuStatus(const SourceFileInfo *pInfo)
{
	HMENU hmenu=GetMenu(hwndMain);
	BOOL fListItem=
		pInfo!=NULL && pInfo->DataList[pInfo->CurDataType].List.nNumItems>0;

	EnableMenuItemByCommand(hmenu,CM_SAVEALL,fListItem);
	EnableMenuItemByCommand(hmenu,CM_SAVELIST,fListItem);
	EnableMenuItemByCommand(hmenu,CM_CHECKALL,fListItem);
	EnableMenuItemByCommand(hmenu,CM_UNCHECKALL,fListItem);
	EnableMenuItemByCommand(hmenu,CM_INVERTCHECK,fListItem);
	SendMessage(hwndToolbar,TB_ENABLEBUTTON,CM_SAVEALL,fListItem);
	SendMessage(hwndToolbar,TB_ENABLEBUTTON,CM_SAVELIST,fListItem);
	SetItemChangedMenuStatus(pInfo);
}


/*
	Xe[^Xo[ɕݒ肷
*/
static void SetStatusBarText(const SourceFileInfo *pInfo)
{
	TCHAR szText[256];

	if (pInfo!=NULL) {
		static const int nParts[]={112,360,-1};
		TCHAR szTmp[256],szValue[32];

		SendMessage(hwndStatusBar,SB_SETPARTS,numberof(nParts),(LPARAM)nParts);
		if (LoadString(hInst,IDS_DATALISTINFOBASE+pInfo->CurDataType,szTmp,
														numberof(szTmp))>0) {
			FormatUInt(pInfo->DataList[pInfo->CurDataType].List.nNumItems,
													szValue,numberof(szValue));
			wsprintf(szText,szTmp,szValue);
			SendMessage(hwndStatusBar,SB_SETTEXT,0,(LPARAM)szText);
		}
		if (LoadString(hInst,IDS_FILESIZE,szTmp,numberof(szTmp))>0) {
			FormatUInt64(pInfo->ullFileSize,szValue,numberof(szValue));
			wsprintf(szText,szTmp,szValue);
			SendMessage(hwndStatusBar,SB_SETTEXT,1,(LPARAM)szText);
		}
		if (LoadString(hInst,IDS_SEARCHTIME,szTmp,numberof(szTmp))>0) {
			FormatUInt(pInfo->uSearchTime,szValue,numberof(szValue));
			wsprintf(szText,szTmp,szValue);
			SendMessage(hwndStatusBar,SB_SETTEXT,2,(LPARAM)szText);
		}
	} else {
		static const int nParts[]={-1};

		SendMessage(hwndStatusBar,SB_SETPARTS,numberof(nParts),(LPARAM)nParts);
		if (LoadString(hInst,IDS_READY,szText,numberof(szText))>0)
			SendMessage(hwndStatusBar,SB_SETTEXT,SBT_NOBORDERS,(LPARAM)szText);
	}
	if (SendMessage(hwndStatusBar,SB_ISSIMPLE,0,0)!=0)
		SendMessage(hwndStatusBar,SB_SIMPLE,FALSE,0);
}


/*
	Xe[^Xo[ɈꎞIȕݒ肷
*/
static void SetStatusBarTemporaryText(LPCTSTR pszText)
{
	if (pszText!=NULL) {
		if (IS_INTRESOURCE(pszText)) {
			TCHAR szText[MAX_MESSAGE_LENGTH];

			if (LoadString(hInst,(UINT)(ULONG_PTR)pszText,
												szText,numberof(szText))<=0)
				return;
			SendMessage(hwndStatusBar,SB_SETTEXT,SB_SIMPLEID,(LPARAM)szText);
		} else {
			SendMessage(hwndStatusBar,SB_SETTEXT,SB_SIMPLEID,(LPARAM)pszText);
		}
	}
	SendMessage(hwndStatusBar,SB_SIMPLE,pszText!=NULL,0);
}


/*
	^u̕ݒ肷
*/
static void SetTabText(const SourceFileInfo *pInfo)
{
	TCITEM tci;
	TCHAR szText[80];
	int i;

	tci.mask=TCIF_TEXT;
	tci.pszText=szText;
	for (i=0;i<NUM_DATA_TYPES;i++) {
		int Length=LoadString(hInst,IDS_DATATYPEBASE+i,
												szText,numberof(szText)-16);

		if (pInfo!=NULL)
			wsprintf(szText+Length,TEXT(" (%d)"),
											pInfo->DataList[i].List.nNumItems);
		TabCtrl_SetItem(hwndDataListTab,i,&tci);
	}
}


/*
	|bvAbvj[\
*/
static BOOL PopupMenu(const SourceFileInfo *pInfo,int nLeft,int nTop)
{
	HMENU hmenu;

	if (pInfo==NULL || pInfo->DataList[pInfo->CurDataType].List.nNumItems==0) {
		hmenu=LoadMenu(hInst,MAKEINTRESOURCE(IDM_POPUP));
		if (hmenu==NULL)
			return FALSE;
	} else {
		BOOL fItem=pInfo->DataList[pInfo->CurDataType].List.nNumItems>0;
		BOOL fSelItem=fItem && pInfo->DataList[pInfo->CurDataType].nSelItem>=0;
		const DataListItemInfo *pItem;

		hmenu=LoadMenu(hInst,MAKEINTRESOURCE(IDM_DATA));
		if (hmenu==NULL)
			return FALSE;
		if (fSelItem)
			pItem=DataList_GetItem(&pInfo->DataList[pInfo->CurDataType].List,
								pInfo->DataList[pInfo->CurDataType].nSelItem);
		EnableMenuItemByCommand(hmenu,CM_SAVE,fSelItem);
		EnableMenuItemByCommand(hmenu,CM_COPY,
			fSelItem && (pInfo->CurDataType==DATATYPE_IMAGE
										|| pItem->Data.Format==FORMAT_WAVE));
		EnableMenuItemByCommand(hmenu,CM_DATAINFO,fSelItem);
	}
	TrackPopupMenu(GetSubMenu(hmenu,0),TPM_RIGHTBUTTON,nLeft,nTop,0,hwndMain,
																		NULL);
	DestroyMenu(hmenu);
	return TRUE;
}




/******************************************************************************

	f[^֐

******************************************************************************/


static DataType GetFormatDataType(FormatType Format)
{
	switch (Format) {
	case FORMAT_DIB:
	case FORMAT_JPEG:
	case FORMAT_PNG:
	case FORMAT_MAG:
	case FORMAT_ICON:
	case FORMAT_CURSOR:
	case FORMAT_ANI:
		return DATATYPE_IMAGE;
	case FORMAT_WAVE:
	case FORMAT_MIDI:
	case FORMAT_MP3:
		return DATATYPE_SOUND;
	case FORMAT_AVI:
		return DATATYPE_VIDEO;
	}
	MESSAGE(TEXT("GetFormatDataType() : Unknown format %d"),(int)Format);
	return 0;	/* Dummy */
}


static ErrorType SaveDataFile(LPCTSTR pszFileName,FormatType Format,
									const void *pData,DataSizeType DataSize)
{
	switch (Format) {
	case FORMAT_DIB:
		return DIBSaveToFile(pszFileName,pData,DataSize);
	case FORMAT_JPEG:
		return JPEGSaveToFile(pszFileName,pData,DataSize);
	case FORMAT_PNG:
		return PNGSaveToFile(pszFileName,pData,DataSize);
	case FORMAT_MAG:
		return MAGSaveToFile(pszFileName,pData,DataSize);
	case FORMAT_ICON:
	case FORMAT_CURSOR:
		return IconSaveToFile(pszFileName,pData,DataSize);
	case FORMAT_ANI:
		return ANISaveToFile(pszFileName,pData,DataSize);
	case FORMAT_WAVE:
		return WAVESaveToFile(pszFileName,pData,DataSize);
	case FORMAT_MIDI:
		return MIDISaveToFile(pszFileName,pData,DataSize);
	case FORMAT_MP3:
		return MP3SaveToFile(pszFileName,pData,DataSize);
	case FORMAT_AVI:
		return AVISaveToFile(pszFileName,pData,DataSize);
	}
	MESSAGE(TEXT("SaveDataFile() : Unknown format %d"),(int)Format);
	return ERR_INTERNAL;
}


static BOOL GetImageDataInfo(FormatType Format,const void *pData,
											size_t DataSize,ImageInfo *pInfo)
{
	switch (Format) {
	case FORMAT_DIB:
		DIBGetImageInfo(pData,DataSize,pInfo);
		break;
	case FORMAT_JPEG:
		JPEGGetImageInfo(pData,DataSize,pInfo);
		break;
	case FORMAT_PNG:
		PNGGetImageInfo(pData,DataSize,pInfo);
		break;
	case FORMAT_MAG:
		MAGGetImageInfo(pData,DataSize,pInfo);
		break;
	case FORMAT_ICON:
	case FORMAT_CURSOR:
		IconGetImageInfo(pData,DataSize,pInfo);
		break;
	case FORMAT_ANI:
		ANIGetImageInfo(pData,DataSize,pInfo);
		break;
	default:
		return FALSE;
	}
	return TRUE;
}


static BOOL GetSoundDataInfo(FormatType Format,const void *pData,
											size_t DataSize,SoundInfo *pInfo)
{
	switch (Format) {
	case FORMAT_WAVE:
		WAVEGetSoundInfo(pData,DataSize,pInfo);
		break;
	case FORMAT_MP3:
		MP3GetSoundInfo(pData,DataSize,pInfo);
		break;
	default:
		return FALSE;
	}
	return TRUE;
}


static BOOL GetVideoDataInfo(FormatType Format,const void *pData,
											size_t DataSize,VideoInfo *pInfo)
{
	switch (Format) {
	case FORMAT_AVI:
		AVIGetVideoInfo(pData,DataSize,pInfo);
		break;
	default:
		return FALSE;
	}
	return TRUE;
}


#ifdef __BORLANDC__
#pragma argsused
#endif
static INT_PTR CALLBACK OpenDlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,
																LPARAM lParam)
{
	static BOOL *pfAbort;

	switch (uMsg) {
	case WM_INITDIALOG:
		pfAbort=(BOOL*)lParam;
		AdjustDialogPos(hwndMain,hDlg);
		return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam)==IDCANCEL)
			*pfAbort=TRUE;
		return TRUE;
	}
	return FALSE;
}


#ifdef __BORLANDC__
#pragma argsused
#endif
static INT_PTR CALLBACK SizeLimitDlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,
																LPARAM lParam)
{
	switch (uMsg) {
	case WM_INITDIALOG:
		AdjustDialogPos(hwndMain,hDlg);
		return TRUE;

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDOK:
		case IDCANCEL:
			if (IsDlgButtonChecked(hDlg,IDC_SIZELIMIT_DONTSHOW)==BST_CHECKED)
				fNoticeSizeLimit=FALSE;
			EndDialog(hDlg,LOWORD(wParam));
		}
		return TRUE;
	}
	return FALSE;
}


typedef struct {
	SourceFileInfo *pSrcInfo;
	HWND hwndOpenDlg;
	BOOL *pfAbort;
} ExtractCallbackInfo;


static BOOL CALLBACK DataCallback(FormatType Format,const void *pData,
												DataSizeType Size,void *pParam)
{
	ExtractCallbackInfo *pInfo=(ExtractCallbackInfo*)pParam;
	DataListItemInfo *pItem;

	pItem=(DataListItemInfo*)MemAlloc(sizeof(DataListItemInfo));
	if (pItem==NULL)
		return FALSE;
	pItem->Data.Format=Format;
	pItem->Data.Address=(BYTE*)pData-(BYTE*)pInfo->pSrcInfo->pData;
	pItem->Data.Size=Size;
	switch (Format) {
	case FORMAT_DIB:
	case FORMAT_JPEG:
	case FORMAT_PNG:
	case FORMAT_MAG:
	case FORMAT_ICON:
	case FORMAT_CURSOR:
	case FORMAT_ANI:
		{
			ImageInfo imginfo;
			LV_ITEM lvi;
			TCHAR szText[64];

			DataList_AddItem(&pInfo->pSrcInfo->DataList[DATATYPE_IMAGE].List,
																		pItem);
			GetImageDataInfo(Format,pData,Size,&imginfo);
			lvi.mask=LVIF_TEXT | LVIF_PARAM;
			lvi.iItem=
					pInfo->pSrcInfo->DataList[DATATYPE_IMAGE].List.nNumItems-1;
			lvi.iSubItem=0;
			lvi.pszText=TEXT("");
			lvi.mask|=LVIF_IMAGE;
			lvi.iImage=(int)Format;
			lvi.lParam=(LPARAM)&pItem->Data;
			ListView_InsertItem(hwndDataList[DATATYPE_IMAGE],&lvi);
			lvi.mask=LVIF_TEXT;
			lvi.iSubItem=1;
			FormatAddress(pItem->Data.Address,szText);
			lvi.pszText=szText;
			ListView_SetItem(hwndDataList[DATATYPE_IMAGE],&lvi);
			lvi.iSubItem=2;
			{
				TCHAR szWidth[16],szHeight[16];

				FormatUInt(imginfo.nWidth,szWidth,numberof(szWidth));
				FormatUInt(imginfo.nHeight,szHeight,numberof(szHeight));
				wsprintf(szText,TEXT("%s x %s"),szWidth,szHeight);
			}
			ListView_SetItem(hwndDataList[DATATYPE_IMAGE],&lvi);
			lvi.iSubItem=3;
			FormatUInt(imginfo.nBitsPerPixel,szText,numberof(szText));
			ListView_SetItem(hwndDataList[DATATYPE_IMAGE],&lvi);
			lvi.iSubItem=4;
			FormatSize(Size,szText,numberof(szText));
			ListView_SetItem(hwndDataList[DATATYPE_IMAGE],&lvi);
			ListView_SetCheckState(hwndDataList[DATATYPE_IMAGE],lvi.iItem,
																		TRUE);
		}
		break;

	case FORMAT_WAVE:
	case FORMAT_MIDI:
	case FORMAT_MP3:
		{
			LV_ITEM lvi;
			TCHAR szText[64];
			SoundInfo sndinfo;

			DataList_AddItem(&pInfo->pSrcInfo->DataList[DATATYPE_SOUND].List,
																		pItem);
			lvi.mask=LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
			lvi.iItem=
					pInfo->pSrcInfo->DataList[DATATYPE_SOUND].List.nNumItems-1;
			lvi.iSubItem=0;
			lvi.pszText=TEXT("");
			lvi.iImage=(int)(Format-FORMAT_WAVE);
			lvi.lParam=(LPARAM)&pItem->Data;
			ListView_InsertItem(hwndDataList[DATATYPE_SOUND],&lvi);
			lvi.mask=LVIF_TEXT;
			lvi.iSubItem=1;
			FormatAddress(pItem->Data.Address,szText);
			lvi.pszText=szText;
			ListView_SetItem(hwndDataList[DATATYPE_SOUND],&lvi);
			if (GetSoundDataInfo(Format,pData,Size,&sndinfo)) {
				lvi.iSubItem=2;
				FormatTime(sndinfo.uLength,szText);
				ListView_SetItem(hwndDataList[DATATYPE_SOUND],&lvi);
				lvi.iSubItem=3;
				FormatUInt(sndinfo.nChannels,szText,numberof(szText));
				ListView_SetItem(hwndDataList[DATATYPE_SOUND],&lvi);
			}
			lvi.iSubItem=4;
			FormatSize(Size,szText,numberof(szText));
			ListView_SetItem(hwndDataList[DATATYPE_SOUND],&lvi);
			ListView_SetCheckState(hwndDataList[DATATYPE_SOUND],lvi.iItem,
																		TRUE);
		}
		break;

	case FORMAT_AVI:
		{
			LV_ITEM lvi;
			TCHAR szText[64];
			VideoInfo vinfo;

			DataList_AddItem(&pInfo->pSrcInfo->DataList[DATATYPE_VIDEO].List,
																		pItem);
			lvi.mask=LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
			lvi.iItem=
					pInfo->pSrcInfo->DataList[DATATYPE_VIDEO].List.nNumItems-1;
			lvi.iSubItem=0;
			lvi.pszText=TEXT("");
			lvi.iImage=0;
			lvi.lParam=(LPARAM)&pItem->Data;
			ListView_InsertItem(hwndDataList[DATATYPE_VIDEO],&lvi);
			lvi.mask=LVIF_TEXT;
			lvi.iSubItem=1;
			FormatAddress(pItem->Data.Address,szText);
			lvi.pszText=szText;
			ListView_SetItem(hwndDataList[DATATYPE_VIDEO],&lvi);
			GetVideoDataInfo(Format,pData,Size,&vinfo);
			lvi.iSubItem=2;
			{
				TCHAR szWidth[16],szHeight[16];

				FormatUInt(vinfo.nWidth,szWidth,numberof(szWidth));
				FormatUInt(vinfo.nHeight,szHeight,numberof(szHeight));
				wsprintf(szText,TEXT("%s x %s"),szWidth,szHeight);
			}
			ListView_SetItem(hwndDataList[DATATYPE_VIDEO],&lvi);
			lvi.iSubItem=3;
			FormatTime(vinfo.uLength,szText);
			ListView_SetItem(hwndDataList[DATATYPE_VIDEO],&lvi);
			lvi.iSubItem=4;
			FormatSize(Size,szText,numberof(szText));
			ListView_SetItem(hwndDataList[DATATYPE_VIDEO],&lvi);
			ListView_SetCheckState(hwndDataList[DATATYPE_VIDEO],lvi.iItem,
																		TRUE);
		}
		break;
	}
	return TRUE;
}


static BOOL CALLBACK ProgressCallback(int nPos,int nMax,void *pParam)
{
	ExtractCallbackInfo *pInfo=(ExtractCallbackInfo*)pParam;
	MSG msg;

	if (nPos==0)
		SendDlgItemMessage(pInfo->hwndOpenDlg,IDC_OPEN_PROGRESS,PBM_SETRANGE32,
																	0,nMax);
	SendDlgItemMessage(pInfo->hwndOpenDlg,IDC_OPEN_PROGRESS,PBM_SETPOS,nPos,0);
	while (PeekMessage(&msg,NULL,0,0,PM_REMOVE)) {
		if (!IsDialogMessage(pInfo->hwndOpenDlg,&msg)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	return !*pInfo->pfAbort;
}


static BOOL ExtractFileData(SourceFileInfo *pInfo)
{
	BOOL fAbort;
	HWND hwndOpenDlg;
	ExtractCallbackInfo Info;
	int i;

	fAbort=FALSE;
	hwndOpenDlg=CreateDialogParam(hInst,MAKEINTRESOURCE(IDD_OPEN),hwndMain,
												OpenDlgProc,(LPARAM)&fAbort);
	if (hwndOpenDlg==NULL) {
		ResMessageBox(hwndMain,IDS_FAIL_CREATEWINDOW,0,
												MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	EnableWindow(hwndMain,FALSE);
	Info.pSrcInfo=pInfo;
	Info.hwndOpenDlg=hwndOpenDlg;
	Info.pfAbort=&fAbort;
	ExtractData(pInfo->pData,pInfo->DataSize,DataCallback,ProgressCallback,
																		&Info);
	pInfo->nDataCount=0;
	for (i=0;i<NUM_DATA_TYPES;i++)
		pInfo->nDataCount+=pInfo->DataList[i].List.nNumItems;
	EnableWindow(hwndMain,TRUE);
	DestroyWindow(hwndOpenDlg);
	SetForegroundWindow(hwndMain);
	return TRUE;
}


static void CloseSourceFile(SourceFileInfo **ppInfo)
{
	int i;

	if (*ppInfo!=NULL) {
		if ((*ppInfo)->pData!=NULL)
			MemFree((*ppInfo)->pData);
		for (i=0;i<NUM_DATA_TYPES;i++)
			DataList_Free(&(*ppInfo)->DataList[i].List);
		MemFree(*ppInfo);
		*ppInfo=NULL;
	}
	for (i=0;i<NUM_DATA_TYPES;i++)
		ListView_DeleteAllItems(hwndDataList[i]);
	Preview_Reset(hwndPreview);
	SetMenuStatus(NULL);
	SetWindowTitle(NULL);
	SetStatusBarText(NULL);
	SetTabText(NULL);
}


static BOOL OpenSourceFile(SourceFileInfo **ppInfo,LPCTSTR pszFileName)
{
	SourceFileInfo *pInfo;
	HANDLE hFile;
	DWORD dwFileSizeLow,dwFileSizeHigh;
	unsigned int uDataSize;
	void *pData;
	DWORD dwRead;
	HCURSOR hcurOld;
	DWORD dwStartTime,dwEndTime;
	int i;

	if (*ppInfo!=NULL)
		CloseSourceFile(ppInfo);
	pInfo=(SourceFileInfo*)MemAlloc(sizeof(SourceFileInfo));
	if (pInfo==NULL) {
		ErrMessageBox(hwndMain,ERR_MEMORYALLOC,MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	dwStartTime=GetTickCount();
	hFile=CreateFile(pszFileName,GENERIC_READ,FILE_SHARE_READ,NULL,
									OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (hFile==INVALID_HANDLE_VALUE) {
		MemFree(pInfo);
		ErrMessageBox(hwndMain,ERR_FILEOPEN,MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	dwFileSizeLow=GetFileSize(hFile,&dwFileSizeHigh);
	if ((dwFileSizeLow==0 && dwFileSizeHigh==0)
			|| (dwFileSizeLow==INVALID_FILE_SIZE && GetLastError()!=NO_ERROR)) {
		CloseHandle(hFile);
		MemFree(pInfo);
		ResMessageBox(hwndMain,IDS_MSG_DATANOTFOUND,IDS_MSG_DATANOTFOUND_C,
												MB_OK | MB_ICONINFORMATION);
		return FALSE;
	}
	if (dwFileSizeHigh==0 && dwFileSizeLow<=uMaxFileLoadSize) {
		uDataSize=dwFileSizeLow;
	} else {
		if (fNoticeSizeLimit) {
			if (DialogBox(hInst,MAKEINTRESOURCE(IDD_SIZELIMIT),hwndMain,
													SizeLimitDlgProc)!=IDOK) {
				CloseHandle(hFile);
				MemFree(pInfo);
				return FALSE;
			}
		}
		uDataSize=uMaxFileLoadSize;
	}
	pData=MemAlloc(uDataSize);
	if (pData==NULL) {
		CloseHandle(hFile);
		MemFree(pInfo);
		ErrMessageBox(hwndMain,ERR_MEMORYALLOC,MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	SetStatusBarTemporaryText(MAKEINTRESOURCE(IDS_FILELOADING));
	hcurOld=SetCursor(LoadCursor(NULL,IDC_WAIT));
	if (!ReadFile(hFile,pData,uDataSize,&dwRead,NULL) || dwRead!=uDataSize) {
		MemFree(pData);
		CloseHandle(hFile);
		MemFree(pInfo);
		SetCursor(hcurOld);
		ErrMessageBox(hwndMain,ERR_FILEREAD,MB_OK | MB_ICONEXCLAMATION);
		SetStatusBarText(NULL);
		return FALSE;
	}
	CloseHandle(hFile);
	SetCursor(hcurOld);
	SetStatusBarTemporaryText(MAKEINTRESOURCE(IDS_EXTRACTING));
	*ppInfo=pInfo;
	lstrcpy(pInfo->szFileName,pszFileName);
	pInfo->ullFileSize=((ULONGLONG)dwFileSizeHigh<<32)|dwFileSizeLow;
	pInfo->pData=pData;
	pInfo->DataSize=uDataSize;
	pInfo->CurDataType=CurDataListType;
	for (i=0;i<NUM_DATA_TYPES;i++) {
		DataList_Init(&pInfo->DataList[i].List);
		pInfo->DataList[i].nCurSortColumn=1;
		pInfo->DataList[i].fSortAscending=TRUE;
		pInfo->DataList[i].nSelItem=-1;
	}
	ExtractFileData(pInfo);
	if (pInfo->nDataCount==0) {
		MemFree(pData);
		MemFree(pInfo);
		*ppInfo=NULL;
		ResMessageBox(hwndMain,IDS_MSG_DATANOTFOUND,IDS_MSG_DATANOTFOUND_C,
												MB_OK | MB_ICONINFORMATION);
		SetStatusBarText(NULL);
		return FALSE;
	}
	dwEndTime=GetTickCount();
	pInfo->uSearchTime=dwStartTime<=dwEndTime?dwEndTime-dwStartTime:
										0xFFFFFFFFUL-dwStartTime+dwEndTime+1;
	SetMenuStatus(pInfo);
	SetWindowTitle(pInfo);
	SetStatusBarText(pInfo);
	SetTabText(pInfo);
	/* f[^̂^uANeBuɂ */
	if (pInfo->DataList[CurDataListType].List.nNumItems==0) {
		NMHDR nmhdr;

		for (i=0;i<NUM_DATA_TYPES;i++)
			if (pInfo->DataList[i].List.nNumItems>0)
				break;
		TabCtrl_SetCurSel(hwndDataListTab,i);
		nmhdr.hwndFrom=hwndDataListTab;
		nmhdr.idFrom=GetWindowLong(hwndDataListTab,GWL_ID);
		nmhdr.code=TCN_SELCHANGE;
		SendMessage(hwndDataListForm,WM_NOTIFY,0,(LPARAM)&nmhdr);
	}
	return TRUE;
}


static DataInfo *GetDataListItemInfo(HWND hwnd,int nItem)
{
	LV_ITEM lvi;

	lvi.mask=LVIF_PARAM;
	lvi.iItem=nItem;
	lvi.iSubItem=0;
	ListView_GetItem(hwnd,&lvi);
	return (DataInfo*)lvi.lParam;
}




/******************************************************************************

	SẴf[^ۑ

******************************************************************************/


#ifdef __BORLANDC__
#pragma argsused
#endif
static INT_PTR CALLBACK SaveAllDlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,
																LPARAM lParam)
{
	switch (uMsg) {
	case WM_INITDIALOG:
		{
			HICON hico;
			TCHAR szText[256];

			SendDlgItemMessage(hDlg,IDC_SAVEALL_DIRECTORY,EM_LIMITTEXT,
																MAX_PATH-1,0);
			SetDlgItemText(hDlg,IDC_SAVEALL_DIRECTORY,szFileSaveDirectory);
			hico=(HICON)LoadImage(hInst,MAKEINTRESOURCE(IDI_FOLDER),
								IMAGE_ICON,16,16,LR_DEFAULTCOLOR | LR_SHARED);
			if (hico!=NULL)
				SendDlgItemMessage(hDlg,IDC_SAVEALL_BROWSEDIR,BM_SETIMAGE,
													IMAGE_ICON,(LPARAM)hico);
			SendDlgItemMessage(hDlg,IDC_SAVEALL_FILENAME,EM_LIMITTEXT,
																MAX_PATH-1,0);
			SetDlgItemText(hDlg,IDC_SAVEALL_FILENAME,szSaveAllFileName);
			LoadString(hInst,IDS_MINDIGITSLIST,szText,numberof(szText));
			SetComboBoxList(hDlg,IDC_SAVEALL_MINDIGITS,szText);
			SendDlgItemMessage(hDlg,IDC_SAVEALL_MINDIGITS,CB_SETCURSEL,
														nSaveAllMinDigits,0);
			SetDlgItemInt(hDlg,IDC_SAVEALL_FIRSTNUMBER,nSaveAllFirstNumber,
																		TRUE);
			SendDlgItemMessage(hDlg,IDC_SAVEALL_FIRSTNUMBER_UD,UDM_SETRANGE,0,
													MAKELPARAM(UD_MAXVAL,0));
			LoadString(hInst,IDS_OVERWRITELIST,szText,numberof(szText));
			SetComboBoxList(hDlg,IDC_SAVEALL_OVERWRITE,szText);
			SendDlgItemMessage(hDlg,IDC_SAVEALL_OVERWRITE,CB_SETCURSEL,
												(int)SaveAllOverWriteMode,0);
			AdjustDialogPos(hwndMain,hDlg);
		}
		return TRUE;

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDC_SAVEALL_BROWSEDIR:
			{
				TCHAR szDirectory[MAX_PATH],szMessage[MAX_MESSAGE_LENGTH];

				GetDlgItemText(hDlg,IDC_SAVEALL_DIRECTORY,szDirectory,
														numberof(szDirectory));
				LoadString(hInst,IDS_MSG_SPECSAVEFOLDER,szMessage,
														numberof(szMessage));
				if (BrowseFolderDialog(hDlg,szDirectory,szMessage))
					SetDlgItemText(hDlg,IDC_SAVEALL_DIRECTORY,szDirectory);
			}
			return TRUE;
		case IDC_SAVEALL_HELP:
			ShowHelp(IDH_SAVEALL);
			return TRUE;
		case IDOK:
			{
				TCHAR szDirectory[MAX_PATH],szFileName[MAX_PATH];

				GetDlgItemText(hDlg,IDC_SAVEALL_DIRECTORY,szDirectory,
														numberof(szDirectory));
				if (szDirectory[0]=='\0') {
					ResMessageBox(hDlg,IDS_MSG_SPECSAVEFOLDER,0,
												MB_OK | MB_ICONEXCLAMATION);
					return TRUE;
				}
				lstrcpy(szFileSaveDirectory,szDirectory);
				GetDlgItemText(hDlg,IDC_SAVEALL_FILENAME,szFileName,
														numberof(szFileName));
				if (szFileName[0]=='\0') {
					ResMessageBox(hDlg,IDS_MSG_SPECFILENAME,0,
												MB_OK | MB_ICONEXCLAMATION);
					return TRUE;
				}
				lstrcpy(szSaveAllFileName,szFileName);
				nSaveAllMinDigits=SendDlgItemMessage(hDlg,
									IDC_SAVEALL_MINDIGITS,CB_GETCURSEL,0,0);
				nSaveAllFirstNumber=GetDlgItemInt(hDlg,IDC_SAVEALL_FIRSTNUMBER,
																	NULL,TRUE);
				SaveAllOverWriteMode=(OverWriteMode)SendDlgItemMessage(hDlg,
									IDC_SAVEALL_OVERWRITE,CB_GETCURSEL,0,0);
			}
		case IDCANCEL:
			EndDialog(hDlg,LOWORD(wParam));
			return TRUE;
		}
		return TRUE;
	}
	return FALSE;
}


static INT_PTR CALLBACK SaveAllProgressDlgProc(HWND hDlg,UINT uMsg,
												WPARAM wParam,LPARAM lParam)
{
	static BOOL *pfAbort;

	switch (uMsg) {
	case WM_INITDIALOG:
		pfAbort=(BOOL*)lParam;
		AdjustDialogPos(hwndMain,hDlg);
		return TRUE;
	case WM_COMMAND:
		if (LOWORD(wParam)==IDCANCEL)
			*pfAbort=TRUE;
		return TRUE;
	}
	return FALSE;
}


static BOOL SaveAllData(HWND hwndOwner,const SourceFileInfo *pInfo)
{
	int nNumSaveFiles,i,j,No;
	BOOL fAbort;
	HWND hwndProgressDlg;
	TCHAR szText[64],szFileName[MAX_PATH],szFilePath[MAX_PATH];
	int nMinDigits;

	if (pInfo->DataList[pInfo->CurDataType].List.nNumItems==0)
		return FALSE;
	nNumSaveFiles=0;
	for (i=0;i<pInfo->DataList[pInfo->CurDataType].List.nNumItems;i++) {
		if (ListView_GetCheckState(hwndDataList[pInfo->CurDataType],i))
			nNumSaveFiles++;
	}
	if (nNumSaveFiles==0) {
		ResMessageBox(hwndOwner,IDS_MSG_CHECK,IDS_SHORTCMBASE+CM_SAVEALL,
												MB_OK | MB_ICONINFORMATION);
		return FALSE;
	}
	if (DialogBox(hInst,MAKEINTRESOURCE(IDD_SAVEALL),hwndOwner,SaveAllDlgProc)
																		!=IDOK)
		return FALSE;
	fAbort=FALSE;
	hwndProgressDlg=CreateDialogParam(hInst,
							MAKEINTRESOURCE(IDD_SAVEALLPROGRESS),hwndOwner,
									SaveAllProgressDlgProc,(LPARAM)&fAbort);
	if (hwndProgressDlg==NULL) {
		ResMessageBox(hwndOwner,IDS_FAIL_CREATEWINDOW,0,
												MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	EnableWindow(hwndOwner,FALSE);
	SendDlgItemMessage(hwndProgressDlg,IDC_SAVEALLPROGRESS_PROGRESS,
								PBM_SETRANGE,0,MAKELPARAM(0,nNumSaveFiles));
	if (nSaveAllMinDigits>0)
		nMinDigits=nSaveAllMinDigits;
	else
		nMinDigits=CountDigits(nSaveAllFirstNumber+nNumSaveFiles-1);
	j=0;
	No=0;
	for (i=0;i<pInfo->DataList[pInfo->CurDataType].List.nNumItems;i++) {
		if (ListView_GetCheckState(hwndDataList[pInfo->CurDataType],i)) {
			const DataInfo *pDataInfo;
			ErrorType Err;

			pDataInfo=GetDataListItemInfo(hwndDataList[pInfo->CurDataType],i);
			wsprintf(szText,TEXT("%d / %d"),j+1,nNumSaveFiles);
			SetDlgItemText(hwndProgressDlg,IDC_SAVEALLPROGRESS_COUNT,szText);
			SendDlgItemMessage(hwndProgressDlg,IDC_SAVEALLPROGRESS_PROGRESS,
															PBM_SETPOS,j,0);
			wsprintf(szFileName,TEXT("%s%s.%s"),szSaveAllFileName,
						IntToString(szText,nSaveAllFirstNumber+No,nMinDigits),
									pszFormatExtensionList[pDataInfo->Format]);
			MergeFileName(szFilePath,szFileSaveDirectory,szFileName);
			SetDlgItemText(hwndProgressDlg,IDC_SAVEALLPROGRESS_FILENAME,
																szFilePath);
			j++;
			No++;
			if (SaveAllOverWriteMode!=OVERWRITE_OVERWRITE
												&& FileExists(szFilePath)) {
				if (SaveAllOverWriteMode==OVERWRITE_ASK) {
					int nResult;

					nResult=OverWriteDialog(hwndProgressDlg,szFilePath,
											MB_YESNOCANCEL | MB_ICONQUESTION);
					if (nResult==IDNO)
						continue;
					else if (nResult!=IDYES)
						break;
				} else if (SaveAllOverWriteMode==OVERWRITE_SKIP) {
					continue;
				} else {
					do {
						wsprintf(szFileName,TEXT("%s%s.%s"),szSaveAllFileName,
							IntToString(szText,nSaveAllFirstNumber+No,
																nMinDigits),
									pszFormatExtensionList[pDataInfo->Format]);
						MergeFileName(szFilePath,szFileSaveDirectory,
																szFileName);
						No++;
					} while (FileExists(szFilePath));
				}
			}
			Err=SaveDataFile(szFilePath,pDataInfo->Format,
					(BYTE*)pInfo->pData+pDataInfo->Address,pDataInfo->Size);
			if (Err!=ERR_SUCCESS) {
				if (ErrMessageBox(hwndProgressDlg,Err,
									MB_OKCANCEL | MB_ICONEXCLAMATION)!=IDOK)
					break;
			}
		}
	}
	EnableWindow(hwndOwner,TRUE);
	DestroyWindow(hwndProgressDlg);
	return TRUE;
}




/******************************************************************************

	f[^̃Xgۑ

******************************************************************************/


static BOOL WriteString(HANDLE hFile,LPCSTR pszText)
{
	UINT uLength;
	DWORD dwWrite;

	uLength=lstrlenA(pszText);
	return WriteFile(hFile,pszText,uLength,&dwWrite,NULL) && dwWrite==uLength;
}


static ErrorType SaveHTMLDataList(const SourceFileInfo *pInfo,
														LPCTSTR pszFileName)
{
	HANDLE hFile;
	char szText[1024],szAddress[MAX_ADDRESS_DIGITS+1],szSize[32];
	int i;
	const DataInfo *pItem;

	hFile=CreateFile(pszFileName,GENERIC_WRITE,FILE_SHARE_READ,NULL,
									CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (hFile==INVALID_HANDLE_VALUE)
		return ERR_FILEOPEN;
	if (!LoadStringA(hInst,IDS_HTMLHEADER,szText,numberof(szText))) {
		CloseHandle(hFile);
		return ERR_LOADSTRING;
	}
	if (!WriteString(hFile,szText)) {
		CloseHandle(hFile);
		return ERR_FILEWRITE;
	}
#ifndef UNICODE
	wsprintfA(szText,"<caption>%s</caption>\r\n",
											GetFileNamePtr(pInfo->szFileName));
#else
	{
		char szFile[MAX_PATH];

		WideCharToMultiByte(CP_ACP,0,GetFileNamePtr(pInfo->szFileName),-1,
											szFile,numberof(szFile),NULL,NULL);
		wsprintfA(szText,"<caption>%s</caption>\r\n",szFile);
	}
#endif
	if (!WriteString(hFile,szText)) {
		CloseHandle(hFile);
		return ERR_FILEWRITE;
	}
	if (!LoadStringA(hInst,IDS_HTMLCOLUMNBASE+pInfo->CurDataType,szText,
														numberof(szText))) {
		CloseHandle(hFile);
		return ERR_LOADSTRING;
	}
	if (!WriteString(hFile,szText)) {
		CloseHandle(hFile);
		return ERR_FILEWRITE;
	}
	for (i=0;i<pInfo->DataList[pInfo->CurDataType].List.nNumItems;i++) {
		pItem=GetDataListItemInfo(hwndDataList[pInfo->CurDataType],i);
		switch (pInfo->CurDataType) {
		case DATATYPE_IMAGE:
			{
				ImageInfo imginfo;
				char szWidth[16],szHeight[16],szBits[16];

				GetImageDataInfo(pItem->Format,
					(BYTE*)pInfo->pData+pItem->Address,pItem->Size,&imginfo);
				wsprintfA(szText,
			"<tr><td>%s</td><td>%s x %s</td><td class=\"right\">%s</td><td class=\"right\">%s</td></tr>\r\n",
					FormatAddressA(pItem->Address,szAddress),
					FormatUIntA(imginfo.nWidth,szWidth,numberof(szWidth)),
					FormatUIntA(imginfo.nHeight,szHeight,numberof(szHeight)),
					FormatUIntA(imginfo.nBitsPerPixel,szBits,numberof(szBits)),
					FormatSizeA(pItem->Size,szSize,numberof(szSize)));
			}
			break;
		case DATATYPE_SOUND:
			if (pItem->Format==FORMAT_WAVE || pItem->Format==FORMAT_MP3) {
				SoundInfo sndinfo;
				char szTime[32],szChannels[16],szBits[16],szSamples[16];

				GetSoundDataInfo(pItem->Format,
					(BYTE*)pInfo->pData+pItem->Address,pItem->Size,&sndinfo);
				wsprintfA(szText,
	"<tr><td>%s</td><td class=\"right\">%s</td><td class=\"right\">%s</td>"
	"<td class=\"right\">%s</td><td class=\"right\">%s</td>"
	"<td class=\"right\">%s</td></tr>\r\n",
					FormatAddressA(pItem->Address,szAddress),
					FormatTimeA(sndinfo.uLength,szTime),
					FormatUIntA(sndinfo.nChannels,szChannels,
														numberof(szChannels)),
					FormatUIntA(sndinfo.nBitsPerSample,szBits,
															numberof(szBits)),
					FormatUIntA(sndinfo.nSamplesPerSec,szSamples,
														numberof(szSamples)),
					FormatSizeA(pItem->Size,szSize,numberof(szSize)));
			} else {
				wsprintfA(szText,
	"<tr><td>%s</td><td class=\"right\"></td><td class=\"right\"></td>"
	"<td class=\"right\"></td><td class=\"right\"></td>"
	"<td class=\"right\">%s</td></tr>\r\n",
					FormatAddressA(pItem->Address,szAddress),
					FormatSizeA(pItem->Size,szSize,numberof(szSize)));
			}
			break;
		case DATATYPE_VIDEO:
			{
				VideoInfo vinfo;
				char szWidth[32],szHeight[32],szTime[32];

				GetVideoDataInfo(pItem->Format,
						(BYTE*)pInfo->pData+pItem->Address,pItem->Size,&vinfo);
				wsprintfA(szText,"<tr><td>%s</td><td>%s x %s</td>"
			"<td class=\"right\">%s</td><td class=\"right\">%s</td></tr>\r\n",
						FormatAddressA(pItem->Address,szAddress),
						FormatUIntA(vinfo.nWidth,szWidth,numberof(szWidth)),
						FormatUIntA(vinfo.nHeight,szHeight,numberof(szHeight)),
						FormatTimeA(vinfo.uLength,szTime),
						FormatSizeA(pItem->Size,szSize,numberof(szSize)));
			}
			break;
		}
		if (!WriteString(hFile,szText)) {
			CloseHandle(hFile);
			return ERR_FILEWRITE;
		}
	}
	if (!WriteString(hFile,"</table>\r\n</body>\r\n</html>\r\n")) {
		CloseHandle(hFile);
		return ERR_FILEWRITE;
	}
	if (!CloseHandle(hFile))
		return ERR_FILECLOSE;
	return ERR_SUCCESS;
}


static ErrorType SaveCSVDataList(const SourceFileInfo *pInfo,
														LPCTSTR pszFileName)
{
	HANDLE hFile;
	char szText[256],szAddress[MAX_ADDRESS_DIGITS+1],szSize[64];
	int i;
	const DataInfo *pItem;

	hFile=CreateFile(pszFileName,GENERIC_WRITE,FILE_SHARE_READ,NULL,
									CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (hFile==INVALID_HANDLE_VALUE)
		return ERR_FILEOPEN;
	if (!LoadStringA(hInst,IDS_CSVCOLUMNBASE+pInfo->CurDataType,szText,
														numberof(szText))) {
		CloseHandle(hFile);
		return ERR_LOADSTRING;
	}
	if (!WriteString(hFile,szText)) {
		CloseHandle(hFile);
		return ERR_FILEWRITE;
	}
	for (i=0;i<pInfo->DataList[pInfo->CurDataType].List.nNumItems;i++) {
		pItem=GetDataListItemInfo(hwndDataList[pInfo->CurDataType],i);
		switch (pInfo->CurDataType) {
		case DATATYPE_IMAGE:
			{
				ImageInfo imginfo;

				GetImageDataInfo(pItem->Format,
					(BYTE*)pInfo->pData+pItem->Address,pItem->Size,&imginfo);
				wsprintfA(szText,"%s,%d,%d,%d,%s\r\n",
					FormatAddressA(pItem->Address,szAddress),imginfo.nWidth,
					imginfo.nHeight,imginfo.nBitsPerPixel,
					FormatSizeA(pItem->Size,szSize,numberof(szSize)));
			}
			break;
		case DATATYPE_SOUND:
			{
				SoundInfo sndinfo;

				if (GetSoundDataInfo(pItem->Format,
								(BYTE*)pInfo->pData+pItem->Address,pItem->Size,
																&sndinfo)) {
					wsprintfA(szText,"%s,%u,%d,%d,%d,%s\r\n",
							FormatAddressA(pItem->Address,szAddress),
							sndinfo.uLength,
							sndinfo.nChannels,sndinfo.nBitsPerSample,
							sndinfo.nSamplesPerSec,
							FormatSizeA(pItem->Size,szSize,numberof(szSize)));
				} else {
					wsprintfA(szText,"%s,,,,,%s\r\n",
							FormatAddressA(pItem->Address,szAddress),
							FormatSizeA(pItem->Size,szSize,numberof(szSize)));
				}
			}
			break;
		case DATATYPE_VIDEO:
			{
				VideoInfo vinfo;

				GetVideoDataInfo(pItem->Format,
						(BYTE*)pInfo->pData+pItem->Address,pItem->Size,&vinfo);
				wsprintfA(szText,"%s,%d,%d,%u,%s\r\n",
							FormatAddressA(pItem->Address,szAddress),
							vinfo.nWidth,vinfo.nHeight,vinfo.uLength,
							FormatSizeA(pItem->Size,szSize,numberof(szSize)));
			}
			break;
		}
		if (!WriteString(hFile,szText)) {
			CloseHandle(hFile);
			return ERR_FILEWRITE;
		}
	}
	if (!CloseHandle(hFile))
		return ERR_FILECLOSE;
	return ERR_SUCCESS;
}




/******************************************************************************

	ꊇo

******************************************************************************/


/*
	Xg{bNX̃ACe̕ݒ肷

	:
		(i)hDlg	Xg{bNX̂_CAÕnhB
		(i)nID	Xg{bNXIDB
	߂l:
		ɕݒ肵ꍇTRUEAG[ꍇFALSEԂB
*/
static BOOL SetListBoxHExtent(HWND hDlg,int nID)
{
	int nCount,nMaxWidth;

	nMaxWidth=0;
	nCount=(int)SendDlgItemMessage(hDlg,nID,LB_GETCOUNT,0,0);
	if (nCount>=1) {
		HWND hwnd;
		HFONT hfont,hfontOld;
		HDC hdc;
		int i;
		TCHAR szText[MAX_PATH];
		SIZE sz;

		hwnd=GetDlgItem(hDlg,nID);
		hfont=(HFONT)(UINT_PTR)SendMessage(hwnd,WM_GETFONT,0,0);
		if (hfont==NULL || (hdc=GetDC(hwnd))==NULL)
			return FALSE;
		hfontOld=(HFONT)SelectObject(hdc,hfont);
		for (i=0;i<nCount;i++) {
			SendMessage(hwnd,LB_GETTEXT,i,(LPARAM)szText);
			GetTextExtentPoint32(hdc,szText,lstrlen(szText),&sz);
			if (sz.cx>nMaxWidth)
				nMaxWidth=sz.cx;
		}
		SelectObject(hdc,hfontOld);
		ReleaseDC(hwnd,hdc);
		nMaxWidth+=2;	/* ] */
	}
	SendDlgItemMessage(hDlg,nID,LB_SETHORIZONTALEXTENT,nMaxWidth,0);
	return TRUE;
}


#ifdef __BORLANDC__
#pragma argsused
#endif
static INT_PTR CALLBACK BatchDlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,
																LPARAM lParam)
{
	switch (uMsg) {
	case WM_INITDIALOG:
		{
			TCHAR szText[256];
			HICON hico;

			if (pBatchFileList!=NULL) {
				int i;

				for (i=0;i<nBatchNumFiles;i++)
					SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,LB_ADDSTRING,0,
										(LPARAM)pBatchFileList->szFileName);
				SetListBoxHExtent(hDlg,IDC_BATCH_FILELIST);
			}
			CheckRadioButton(hDlg,IDC_BATCH_SRCDIRECTORY,
													IDC_BATCH_SPECDIRECTORY,
				!fBatchOutSpecDirectory?
							IDC_BATCH_SRCDIRECTORY:IDC_BATCH_SPECDIRECTORY);
			SendDlgItemMessage(hDlg,IDC_BATCH_OUTDIRECTORY,EM_LIMITTEXT,
																MAX_PATH-1,0);
			SetDlgItemText(hDlg,IDC_BATCH_OUTDIRECTORY,szBatchOutDirectory);
			EnableWindow(GetDlgItem(hDlg,IDC_BATCH_OUTDIRECTORY),
													fBatchOutSpecDirectory);
			hico=(HICON)LoadImage(hInst,MAKEINTRESOURCE(IDI_FOLDER),
								IMAGE_ICON,16,16,LR_DEFAULTCOLOR | LR_SHARED);
			if (hico!=NULL)
				SendDlgItemMessage(hDlg,IDC_BATCH_BROWSEOUTDIR,BM_SETIMAGE,
													IMAGE_ICON,(LPARAM)hico);
			EnableWindow(GetDlgItem(hDlg,IDC_BATCH_BROWSEOUTDIR),
													fBatchOutSpecDirectory);
			CheckDlgButton(hDlg,IDC_BATCH_IMAGES,
								(uBatchExtractDataType&DATATYPE_FLAG_IMAGE)!=0?
													BST_CHECKED:BST_UNCHECKED);
			CheckDlgButton(hDlg,IDC_BATCH_SOUNDS,
								(uBatchExtractDataType&DATATYPE_FLAG_SOUND)!=0?
													BST_CHECKED:BST_UNCHECKED);
			CheckDlgButton(hDlg,IDC_BATCH_VIDEOS,
								(uBatchExtractDataType&DATATYPE_FLAG_VIDEO)!=0?
													BST_CHECKED:BST_UNCHECKED);
			LoadString(hInst,IDS_MINDIGITSLIST,szText,numberof(szText));
			SetComboBoxList(hDlg,IDC_BATCH_MINDIGITS,szText);
			SendDlgItemMessage(hDlg,IDC_BATCH_MINDIGITS,CB_SETCURSEL,
															nBatchMinDigits,0);
			SetDlgItemInt(hDlg,IDC_BATCH_FIRSTNUMBER,nBatchFirstNumber,TRUE);
			SendDlgItemMessage(hDlg,IDC_BATCH_FIRSTNUMBER_UD,UDM_SETRANGE,0,
													MAKELPARAM(UD_MAXVAL,0));
			LoadString(hInst,IDS_OVERWRITELIST,szText,numberof(szText));
			SetComboBoxList(hDlg,IDC_BATCH_OVERWRITE,szText);
			SendDlgItemMessage(hDlg,IDC_BATCH_OVERWRITE,CB_SETCURSEL,
													(int)BatchOverWriteMode,0);
			CheckDlgButton(hDlg,IDC_BATCH_SHOWREPORT,
								fBatchShowReport?BST_CHECKED:BST_UNCHECKED);
			AdjustDialogPos(hwndMain,hDlg);
		}
		return TRUE;

	case WM_DROPFILES:
		/* hbvꂽt@CJ */
		{
			HDROP hdrop=(HDROP)wParam;
			int nNumFiles,i,nCount;
			TCHAR szFileName[MAX_PATH];
			DWORD dwAttributes;

			SetForegroundWindow(hDlg);
			nNumFiles=DragQueryFile(hdrop,0xFFFFFFFF,NULL,0);
			nCount=0;
			for (i=0;i<nNumFiles;i++) {
				DragQueryFile(hdrop,i,szFileName,numberof(szFileName));
				dwAttributes=GetFileAttributes(szFileName);
				if (dwAttributes!=0xFFFFFFFF
							&& (dwAttributes&FILE_ATTRIBUTE_DIRECTORY)!=0) {
					TCHAR szFilePath[MAX_PATH];
					HANDLE hFind;
					WIN32_FIND_DATA wfd;

					MergeFileName(szFilePath,szFileName,TEXT("*.*"));
					hFind=FindFirstFile(szFilePath,&wfd);
					if (hFind!=NULL) {
						do {
							if ((wfd.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)
																		==0) {
								MergeFileName(szFilePath,szFileName,
																wfd.cFileName);
								SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,
											LB_ADDSTRING,0,(LPARAM)szFilePath);
								nCount++;
							}
						} while (FindNextFile(hFind,&wfd));
						FindClose(hFind);
					}
				} else {
					SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,LB_ADDSTRING,0,
														(LPARAM)szFileName);
					nCount++;
				}
			}
			DragFinish(hdrop);
			if (nCount>0) {
				SetListBoxHExtent(hDlg,IDC_BATCH_FILELIST);
				EnableWindow(GetDlgItem(hDlg,IDC_BATCH_CLEAR),TRUE);
				EnableWindow(GetDlgItem(hDlg,IDOK),TRUE);
			}
		}
		return TRUE;

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDC_BATCH_FILELIST:
			if (HIWORD(wParam)==LBN_SELCHANGE) {
				int nSel=(int)SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,
															LB_GETCURSEL,0,0);

				EnableWindow(GetDlgItem(hDlg,IDC_BATCH_DELETE),nSel>=0);
			}
			return TRUE;
		case IDC_BATCH_ADD:
			{
				OPENFILENAME ofn;
				int FilesBufferLength=MAX_PATH*1000;
				LPTSTR pszFiles;
				TCHAR szFilter[256];

				pszFiles=(LPTSTR)MemAlloc(FilesBufferLength*sizeof(TCHAR));
				if (pszFiles==NULL) {
					ErrMessageBox(hDlg,ERR_MEMORYALLOC,
												MB_OK | MB_ICONEXCLAMATION);
					return TRUE;
				}
				pszFiles[0]='\0';
				LoadFileFilter(IDS_FILEOPENFILTER,szFilter,numberof(szFilter));
				InitOpenFileNameStruct(&ofn);
				ofn.hwndOwner=hDlg;
				ofn.lpstrFilter=szFilter;
				ofn.nFilterIndex=nFileOpenFilterIndex;
				ofn.lpstrFile=pszFiles;
				ofn.nMaxFile=FilesBufferLength;
				ofn.lpstrInitialDir=szFileOpenDirectory;
				ofn.Flags=OFN_FILEMUSTEXIST | OFN_HIDEREADONLY |
										OFN_EXPLORER | OFN_ALLOWMULTISELECT;
				if (GetOpenFileName(&ofn)) {
					LPTSTR p;

					nFileOpenFilterIndex=ofn.nFilterIndex;
					p=pszFiles+lstrlen(pszFiles)+1;
					if (*p=='\0') {
						GetFileDirectory(szFileOpenDirectory,pszFiles);
						SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,
											LB_ADDSTRING,0,(LPARAM)pszFiles);
					} else {
						int DirLength=p-pszFiles;

						lstrcpy(szFileOpenDirectory,pszFiles);
						SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,
														WM_SETREDRAW,FALSE,0);
						do {
							TCHAR szPath[MAX_PATH];

							if (DirLength+lstrlen(p)<MAX_PATH) {
								MergeFileName(szPath,pszFiles,p);
								SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,
												LB_ADDSTRING,0,(LPARAM)szPath);
							}
							p+=lstrlen(p)+1;
						} while (*p!='\0');
						SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,
														WM_SETREDRAW,TRUE,0);
						InvalidateRect(GetDlgItem(hDlg,IDC_BATCH_FILELIST),
																	NULL,TRUE);
					}
					SetListBoxHExtent(hDlg,IDC_BATCH_FILELIST);
					if (SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,LB_GETCOUNT,
																	0,0)>0) {
						EnableWindow(GetDlgItem(hDlg,IDC_BATCH_CLEAR),TRUE);
						EnableWindow(GetDlgItem(hDlg,IDOK),TRUE);
					}
				}
				MemFree(pszFiles);
			}
			return TRUE;
		case IDC_BATCH_DELETE:
			{
				int nSel=(int)SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,
															LB_GETCURSEL,0,0);

				if (nSel>=0) {
					SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,LB_DELETESTRING,
																	nSel,0);
					SetListBoxHExtent(hDlg,IDC_BATCH_FILELIST);
					EnableWindow(GetDlgItem(hDlg,IDC_BATCH_DELETE),FALSE);
					if (SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,
														LB_GETCOUNT,0,0)==0) {
						EnableWindow(GetDlgItem(hDlg,IDC_BATCH_CLEAR),FALSE);
						EnableWindow(GetDlgItem(hDlg,IDOK),FALSE);
					}
				}
			}
			return TRUE;
		case IDC_BATCH_CLEAR:
			if (SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,LB_GETCOUNT,0,0)
																		>0) {
				SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,LB_RESETCONTENT,0,
																			0);
				SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,
												LB_SETHORIZONTALEXTENT,0,0);
				EnableWindow(GetDlgItem(hDlg,IDC_BATCH_DELETE),FALSE);
				EnableWindow(GetDlgItem(hDlg,IDC_BATCH_CLEAR),FALSE);
				EnableWindow(GetDlgItem(hDlg,IDOK),FALSE);
			}
			return TRUE;
		case IDC_BATCH_SRCDIRECTORY:
		case IDC_BATCH_SPECDIRECTORY:
			{
				BOOL f=IsDlgButtonChecked(hDlg,IDC_BATCH_SPECDIRECTORY)==
																BST_CHECKED;

				EnableWindow(GetDlgItem(hDlg,IDC_BATCH_OUTDIRECTORY),f);
				EnableWindow(GetDlgItem(hDlg,IDC_BATCH_BROWSEOUTDIR),f);
			}
			return TRUE;
		case IDC_BATCH_BROWSEOUTDIR:
			{
				TCHAR szDirectory[MAX_PATH],szMessage[MAX_MESSAGE_LENGTH];

				GetDlgItemText(hDlg,IDC_BATCH_OUTDIRECTORY,szDirectory,
														numberof(szDirectory));
				LoadString(hInst,IDS_MSG_SPECSAVEFOLDER,szMessage,
														numberof(szMessage));
				if (BrowseFolderDialog(hDlg,szDirectory,szMessage))
					SetDlgItemText(hDlg,IDC_BATCH_OUTDIRECTORY,szDirectory);
			}
			return TRUE;
		case IDC_BATCH_HELP:
			ShowHelp(IDH_BATCH);
			return TRUE;
		case IDOK:
			{
				TCHAR szOutDirectory[MAX_PATH];
				UINT uDataType;
				int nNumFiles,i,j;
				BatchFileInfo *pFileList;

				fBatchOutSpecDirectory=IsDlgButtonChecked(hDlg,
										IDC_BATCH_SPECDIRECTORY)==BST_CHECKED;
				GetDlgItemText(hDlg,IDC_BATCH_OUTDIRECTORY,szOutDirectory,
													numberof(szOutDirectory));
				if (fBatchOutSpecDirectory && szOutDirectory[0]=='\0') {
					ResMessageBox(hDlg,IDS_MSG_SPECSAVEFOLDER,0,
												MB_OK | MB_ICONEXCLAMATION);
					return TRUE;
				}
				lstrcpy(szBatchOutDirectory,szOutDirectory);
				uDataType=0;
				if (IsDlgButtonChecked(hDlg,IDC_BATCH_IMAGES)==BST_CHECKED)
					uDataType|=DATATYPE_FLAG_IMAGE;
				if (IsDlgButtonChecked(hDlg,IDC_BATCH_SOUNDS)==BST_CHECKED)
					uDataType|=DATATYPE_FLAG_SOUND;
				if (IsDlgButtonChecked(hDlg,IDC_BATCH_VIDEOS)==BST_CHECKED)
					uDataType|=DATATYPE_FLAG_VIDEO;
				if (uDataType==0) {
					ResMessageBox(hDlg,IDS_MSG_SPECEXTRACTDATA,0,
												MB_OK | MB_ICONEXCLAMATION);
					return TRUE;
				}
				uBatchExtractDataType=uDataType;
				nNumFiles=SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,
															LB_GETCOUNT,0,0);
				pFileList=(BatchFileInfo*)
									MemAlloc(nNumFiles*sizeof(BatchFileInfo));
				if (pFileList==NULL) {
					ErrMessageBox(hDlg,ERR_MEMORYALLOC,
												MB_OK | MB_ICONEXCLAMATION);
					EndDialog(hDlg,IDCANCEL);
					return TRUE;
				}
				for (i=0;i<nNumFiles;i++) {
					SendDlgItemMessage(hDlg,IDC_BATCH_FILELIST,LB_GETTEXT,i,
											(LPARAM)pFileList[i].szFileName);
					for (j=0;j<NUM_DATA_TYPES;j++)
						pFileList[i].uDataCount[j]=0;
				}
				if (pBatchFileList!=NULL)
					MemFree(pBatchFileList);
				pBatchFileList=pFileList;
				nBatchNumFiles=nNumFiles;
				nBatchMinDigits=SendDlgItemMessage(hDlg,IDC_BATCH_MINDIGITS,
															CB_GETCURSEL,0,0);
				nBatchFirstNumber=
						GetDlgItemInt(hDlg,IDC_BATCH_FIRSTNUMBER,NULL,TRUE);
				BatchOverWriteMode=(OverWriteMode)SendDlgItemMessage(hDlg,
										IDC_BATCH_OVERWRITE,CB_GETCURSEL,0,0);
				fBatchShowReport=IsDlgButtonChecked(hDlg,
											IDC_BATCH_SHOWREPORT)==BST_CHECKED;
			}
		case IDCANCEL:
			EndDialog(hDlg,LOWORD(wParam));
			return TRUE;
		}
		return TRUE;
	}
	return FALSE;
}


#ifdef __BORLANDC__
#pragma argsused
#endif
static INT_PTR CALLBACK BatchProgressDlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,
																LPARAM lParam)
{
	static BOOL *pfAbort;

	switch (uMsg) {
	case WM_INITDIALOG:
		pfAbort=(BOOL*)lParam;
		AdjustDialogPos(hwndMain,hDlg);
		return TRUE;
	case WM_COMMAND:
		if (LOWORD(wParam)==IDCANCEL)
			*pfAbort=TRUE;
		return TRUE;
	}
	return FALSE;
}


#ifdef __BORLANDC__
#pragma argsused
#endif
static INT_PTR CALLBACK BatchReportDlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,
																LPARAM lParam)
{
	switch (uMsg) {
	case WM_INITDIALOG:
		{
			HWND hwndList=GetDlgItem(hDlg,IDC_BATCHREPORT_LIST);
			RECT rc;
			LV_COLUMN lvc;
			int nSubItem,i;
			TCHAR szText[MAX_PATH];
			LV_ITEM lvi;
			int j;

			(void)ListView_SetExtendedListViewStyle(hwndList,
									LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT);
			GetClientRect(hwndList,&rc);
			rc.right-=GetSystemMetrics(SM_CXHSCROLL);
			for (i=0;i<NUM_DATA_TYPES;i++)
				if ((uBatchExtractDataType&(1<<i))!=0)
					rc.right-=40;
			lvc.mask=LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
			lvc.fmt=LVCFMT_LEFT;
			lvc.cx=rc.right;
			lvc.pszText=_T("t@C");
			lvc.iSubItem=0;
			ListView_InsertColumn(hwndList,0,&lvc);
			nSubItem=1;
			for (i=0;i<NUM_DATA_TYPES;i++) {
				if ((uBatchExtractDataType&(1<<i))!=0) {
					LoadString(hInst,IDS_DATATYPEBASE+i,szText,
															numberof(szText));
					lvc.fmt=LVCFMT_RIGHT;
					lvc.cx=40;
					lvc.pszText=szText;
					lvc.iSubItem=nSubItem;
					ListView_InsertColumn(hwndList,nSubItem,&lvc);
					nSubItem++;
				}
			}
			for (i=0;i<nBatchNumFiles;i++) {
				lvi.mask=LVIF_TEXT | LVIF_PARAM;
				lvi.iItem=i;
				lvi.iSubItem=0;
				lvi.pszText=pBatchFileList[i].szFileName;
				lvi.lParam=(LPARAM)&pBatchFileList[i];
				ListView_InsertItem(hwndList,&lvi);
				nSubItem=1;
				lvi.mask=LVIF_TEXT;
				lvi.pszText=szText;
				for (j=0;j<NUM_DATA_TYPES;j++) {
					if ((uBatchExtractDataType&(1<<j))!=0) {
						wsprintf(szText,_T("%u"),
											pBatchFileList[i].uDataCount[j]);
						lvi.iSubItem=nSubItem;
						ListView_SetItem(hwndList,&lvi);
						nSubItem++;
					}
				}
			}
			AdjustDialogPos(hwndMain,hDlg);
		}
		return TRUE;

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDOK:
		case IDCANCEL:
			EndDialog(hDlg,LOWORD(wParam));
		}
		return TRUE;
	}
	return FALSE;
}


static ErrorType LoadSourceFile(LPCTSTR pszFileName,void **ppData,
															UINT *puDataSize)
{
	HANDLE hFile;
	DWORD dwFileSizeLow,dwFileSizeHigh;
	DWORD dwRead;

	*ppData=NULL;
	hFile=CreateFile(pszFileName,GENERIC_READ,FILE_SHARE_READ,NULL,
									OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (hFile==INVALID_HANDLE_VALUE)
		return ERR_FILEOPEN;
	dwFileSizeLow=GetFileSize(hFile,&dwFileSizeHigh);
	if (dwFileSizeLow==0 && dwFileSizeHigh==0) {
		CloseHandle(hFile);
		*puDataSize=0;
		return ERR_SUCCESS;
	}
	if (dwFileSizeHigh==0 && dwFileSizeLow<=uMaxFileLoadSize)
		*puDataSize=dwFileSizeLow;
	else
		*puDataSize=uMaxFileLoadSize;
	*ppData=MemAlloc(*puDataSize);
	if (*ppData==NULL) {
		CloseHandle(hFile);
		return ERR_MEMORYALLOC;
	}
	if (!ReadFile(hFile,*ppData,*puDataSize,&dwRead,NULL)
													|| dwRead!=*puDataSize) {
		MemFree(*ppData);
		*ppData=NULL;
		CloseHandle(hFile);
		return ERR_FILEREAD;
	}
	CloseHandle(hFile);
	return ERR_SUCCESS;
}


typedef struct {
	void *pData;
	DataListInfo *pDataList;
	HWND hwndProgressDlg;
	BOOL *pfAbort;
} BatchExtractCallbackInfo;


static BOOL CALLBACK BatchDataCallback(FormatType Format,const void *pData,
												DataSizeType Size,void *pParam)
{
	const BatchExtractCallbackInfo *pInfo=(BatchExtractCallbackInfo*)pParam;
	DataType Type;
	DataListItemInfo *pItem;

	Type=GetFormatDataType(Format);
	if ((uBatchExtractDataType&(1<<(int)Type))==0)
		return TRUE;
	pItem=(DataListItemInfo*)MemAlloc(sizeof(DataListItemInfo));
	if (pItem==NULL) {
		ErrMessageBox(pInfo->hwndProgressDlg,ERR_MEMORYALLOC,
												MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	pItem->Data.Format=Format;
	pItem->Data.Address=(BYTE*)pData-(BYTE*)pInfo->pData;
	pItem->Data.Size=Size;
	DataList_AddItem(&pInfo->pDataList[Type],pItem);
	switch (Type) {
	case DATATYPE_IMAGE:
		SetDlgItemInt(pInfo->hwndProgressDlg,IDC_BATCHPROGRESS_IMAGECOUNT,
							pInfo->pDataList[DATATYPE_IMAGE].nNumItems,TRUE);
		break;
	case DATATYPE_SOUND:
		SetDlgItemInt(pInfo->hwndProgressDlg,IDC_BATCHPROGRESS_SOUNDCOUNT,
							pInfo->pDataList[DATATYPE_SOUND].nNumItems,TRUE);
		break;
	case DATATYPE_VIDEO:
		SetDlgItemInt(pInfo->hwndProgressDlg,IDC_BATCHPROGRESS_VIDEOCOUNT,
							pInfo->pDataList[DATATYPE_VIDEO].nNumItems,TRUE);
		break;
	}
	return TRUE;
}


static BOOL CALLBACK BatchProgressCallback(int nPos,int nMax,void *pParam)
{
	const BatchExtractCallbackInfo *pInfo=(BatchExtractCallbackInfo*)pParam;
	MSG msg;

	if (nPos==0)
		SendDlgItemMessage(pInfo->hwndProgressDlg,
						IDC_BATCHPROGRESS_FILEPROGRESS,PBM_SETRANGE32,0,nMax);
	SendDlgItemMessage(pInfo->hwndProgressDlg,IDC_BATCHPROGRESS_FILEPROGRESS,
															PBM_SETPOS,nPos,0);
	while (PeekMessage(&msg,NULL,0,0,PM_REMOVE)) {
		if (!IsDialogMessage(pInfo->hwndProgressDlg,&msg)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	return !*pInfo->pfAbort;
}


static BOOL BatchExtract(HWND hwndOwner)
{
	BOOL fAbort;
	HWND hwndProgressDlg;
	int i;
	TCHAR szText[64];

	if (DialogBox(hInst,MAKEINTRESOURCE(IDD_BATCH),hwndOwner,BatchDlgProc)!=
																		IDOK)
		return FALSE;
	fAbort=FALSE;
	hwndProgressDlg=CreateDialogParam(hInst,MAKEINTRESOURCE(IDD_BATCHPROGRESS),
							hwndOwner,BatchProgressDlgProc,(LPARAM)&fAbort);
	if (hwndProgressDlg==NULL) {
		ResMessageBox(hwndOwner,IDS_FAIL_CREATEWINDOW,0,
												MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	EnableWindow(hwndOwner,FALSE);
	SendDlgItemMessage(hwndProgressDlg,IDC_BATCHPROGRESS_PROGRESS,PBM_SETRANGE,
											0,MAKELPARAM(0,nBatchNumFiles));
	if ((uBatchExtractDataType&DATATYPE_FLAG_IMAGE)==0)
		EnableWindow(GetDlgItem(hwndProgressDlg,
									IDC_BATCHPROGRESS_IMAGECOUNT_TEXT),FALSE);
	if ((uBatchExtractDataType&DATATYPE_FLAG_SOUND)==0)
		EnableWindow(GetDlgItem(hwndProgressDlg,
									IDC_BATCHPROGRESS_SOUNDCOUNT_TEXT),FALSE);
	if ((uBatchExtractDataType&DATATYPE_FLAG_VIDEO)==0)
		EnableWindow(GetDlgItem(hwndProgressDlg,
									IDC_BATCHPROGRESS_VIDEOCOUNT_TEXT),FALSE);
	for (i=0;i<nBatchNumFiles;i++) {
		wsprintf(szText,_T("%d / %d"),i+1,nBatchNumFiles);
		SetDlgItemText(hwndProgressDlg,IDC_BATCHPROGRESS_FILECOUNT,szText);
		SendDlgItemMessage(hwndProgressDlg,IDC_BATCHPROGRESS_PROGRESS,
															PBM_SETPOS,i,0);
		SetDlgItemText(hwndProgressDlg,IDC_BATCHPROGRESS_FILENAME,
												pBatchFileList[i].szFileName);
		if ((uBatchExtractDataType&DATATYPE_FLAG_IMAGE)!=0)
			SetDlgItemInt(hwndProgressDlg,IDC_BATCHPROGRESS_IMAGECOUNT,0,TRUE);
		if ((uBatchExtractDataType&DATATYPE_FLAG_SOUND)!=0)
			SetDlgItemInt(hwndProgressDlg,IDC_BATCHPROGRESS_SOUNDCOUNT,0,TRUE);
		if ((uBatchExtractDataType&DATATYPE_FLAG_VIDEO)!=0)
			SetDlgItemInt(hwndProgressDlg,IDC_BATCHPROGRESS_VIDEOCOUNT,0,TRUE);
		/* t@C͂ */
		{
			ErrorType Err;
			void *pData;
			UINT uDataSize;
			DataListInfo DataList[NUM_DATA_TYPES];
			int nNumData;
			int j,k;
			BatchExtractCallbackInfo Info;

			Err=LoadSourceFile(pBatchFileList[i].szFileName,&pData,&uDataSize);
			if (Err!=ERR_SUCCESS) {
				if (ErrMessageBox(hwndProgressDlg,Err,
									MB_OKCANCEL | MB_ICONEXCLAMATION)!=IDOK)
					break;
				continue;
			}
			if (uDataSize==0)
				continue;
			for (j=0;j<NUM_DATA_TYPES;j++)
				DataList_Init(&DataList[j]);
			Info.pData=pData;
			Info.pDataList=DataList;
			Info.hwndProgressDlg=hwndProgressDlg;
			Info.pfAbort=&fAbort;
			if (!ExtractData(pData,uDataSize,BatchDataCallback,
												BatchProgressCallback,&Info)) {
				MemFree(pData);
				break;
			}
			nNumData=0;
			for (j=0;j<NUM_DATA_TYPES;j++)
				nNumData+=DataList[j].nNumItems;
			if (nNumData>0) {
				/* f[^ۑ */
				TCHAR szFilePath[MAX_PATH];
				LPTSTR pszFilePost;
				int nDataCount;
				const DataListItemInfo *pItem;
				int nMinDigits;
				int No;

				if (fBatchOutSpecDirectory) {
					TCHAR szFileName[MAX_PATH];

					GetFileName(szFileName,pBatchFileList[i].szFileName);
					MergeFileName(szFilePath,szBatchOutDirectory,szFileName);
				} else {
					lstrcpy(szFilePath,pBatchFileList[i].szFileName);
				}
				pszFilePost=GetFileExtensionPtr(szFilePath);
				*pszFilePost++='_';
				SendDlgItemMessage(hwndProgressDlg,
					IDC_BATCHPROGRESS_FILEPROGRESS,PBM_SETRANGE32,0,nNumData);
				nDataCount=0;
				for (j=0;j<NUM_DATA_TYPES;j++) {
					nMinDigits=nBatchMinDigits>0?nBatchMinDigits:
						CountDigits(nBatchFirstNumber+DataList[j].nNumItems-1);
					No=0;
					for (k=0;k<DataList[j].nNumItems;k++) {
						SendDlgItemMessage(hwndProgressDlg,
									IDC_BATCHPROGRESS_FILEPROGRESS,PBM_SETPOS,
																nDataCount,0);
						nDataCount++;
						pItem=DataList_GetItem(&DataList[j],k);
						wsprintf(pszFilePost,TEXT("%s.%s"),
							IntToString(szText,nBatchFirstNumber+No,nMinDigits),
								pszFormatExtensionList[pItem->Data.Format]);
						No++;
						if (BatchOverWriteMode!=OVERWRITE_OVERWRITE
												&& FileExists(szFilePath)) {
							if (BatchOverWriteMode==OVERWRITE_ASK) {
								int nResult;

								nResult=OverWriteDialog(hwndProgressDlg,
											szFilePath,
											MB_YESNOCANCEL | MB_ICONQUESTION);
								if (nResult==IDNO) {
									continue;
								} else if (nResult!=IDYES) {
									MemFree(pData);
									for (j=0;j<NUM_DATA_TYPES;j++)
										DataList_Free(&DataList[j]);
									goto End;
								}
							} else if (BatchOverWriteMode==OVERWRITE_SKIP) {
								continue;
							} else {
								do {
									wsprintf(pszFilePost,TEXT("%s.%s"),
										IntToString(szText,nBatchFirstNumber+No,
																nMinDigits),
										pszFormatExtensionList[pItem->Data.Format]);
									No++;
								} while (FileExists(szFilePath));
							}
						}
						Err=SaveDataFile(szFilePath,pItem->Data.Format,
											(BYTE*)pData+pItem->Data.Address,
															pItem->Data.Size);
						if (Err!=ERR_SUCCESS) {
							if (ErrMessageBox(hwndProgressDlg,Err,
									MB_OKCANCEL | MB_ICONEXCLAMATION)!=IDOK) {
								MemFree(pData);
								for (j=0;j<NUM_DATA_TYPES;j++)
									DataList_Free(&DataList[j]);
								goto End;
							}
						}
						pBatchFileList[i].uDataCount[j]++;
					}
				}
				for (j=0;j<NUM_DATA_TYPES;j++)
					DataList_Free(&DataList[j]);
			}
			MemFree(pData);
		}
	}
End:
	EnableWindow(hwndOwner,TRUE);
	DestroyWindow(hwndProgressDlg);
	if (fBatchShowReport)
		DialogBox(hInst,MAKEINTRESOURCE(IDD_BATCHREPORT),hwndOwner,
														BatchReportDlgProc);
	MemFree(pBatchFileList);
	pBatchFileList=NULL;
	nBatchNumFiles=0;
	return TRUE;
}




/******************************************************************************

	UI֌W

******************************************************************************/


static HWND CreateMainToolbar(HWND hwndParent)
{
	static const TBBUTTON tbb[]={
		{0,	CM_OPEN,		TBSTATE_ENABLED,	BTNS_BUTTON,	{0,0},	0,0},
		{1,	CM_SAVE,		0,					BTNS_BUTTON,	{0,0},	0,0},
		{2,	CM_SAVEALL,		0,					BTNS_BUTTON,	{0,0},	0,0},
		{3,	CM_SAVELIST,	0,					BTNS_BUTTON,	{0,0},	0,0},
		{0,	0,				TBSTATE_ENABLED,	BTNS_SEP,		{0,0},	0,0},
		{4,	CM_BATCH,		TBSTATE_ENABLED,	BTNS_BUTTON,	{0,0},	0,0},
		{0,	0,				TBSTATE_ENABLED,	BTNS_SEP,		{0,0},	0,0},
		{5,	CM_COPY,		0,					BTNS_BUTTON,	{0,0},	0,0},
		{6,	CM_DATAINFO,	0,					BTNS_BUTTON,	{0,0},	0,0},
		{0,	0,				TBSTATE_ENABLED,	BTNS_SEP,		{0,0},	0,0},
		{7,	CM_OPTIONS,		TBSTATE_ENABLED,	BTNS_BUTTON,	{0,0},	0,0},
		{8,	CM_HELP,		TBSTATE_ENABLED,	BTNS_BUTTON,	{0,0},	0,0},
	};
	HWND hwnd;

	hwnd=CreateWindowEx(0,TOOLBARCLASSNAME,NULL,
		WS_CHILD | (fShowToolbar?WS_VISIBLE:0) |
			TBSTYLE_TOOLTIPS | TBSTYLE_FLAT | CCS_NODIVIDER,
		0,0,0,0,hwndParent,(HMENU)IDC_TOOLBAR,hInst,NULL);
	if (hwnd==NULL)
		return NULL;
	if (himlToolbar==NULL)
		himlToolbar=ImageList_LoadBitmap(hInst,MAKEINTRESOURCE(IDB_TOOLBAR),16,
															1,RGB(0,255,0));
	SendMessage(hwnd,TB_SETIMAGELIST,0,(LPARAM)himlToolbar);
	SendMessage(hwnd,TB_BUTTONSTRUCTSIZE,sizeof(TBBUTTON),0);
	SendMessage(hwnd,TB_ADDBUTTONS,numberof(tbb),(LPARAM)tbb);
	if (!fShowTipHelp)
		ShowToolbarTipHelp(hwnd,FALSE);
	return hwnd;
}


static HWND CreateMainStatusBar(HWND hwndParent)
{
	HWND hwnd;

	hwnd=CreateWindowEx(0,STATUSCLASSNAME,NULL,
					WS_CHILD | (fShowStatusBar?WS_VISIBLE:0) | SBARS_SIZEGRIP,
					0,0,0,0,hwndParent,(HMENU)IDC_STATUSBAR,hInst,NULL);
	if (hwnd==NULL)
		return NULL;
	return hwnd;
}


static HWND CreateDataListTabWindow(HWND hwndParent)
{
	HWND hwnd;
	HIMAGELIST himl;
	TCITEM tci;
	int i;
	TCHAR szText[64];

	hwnd=CreateWindow(WC_TABCONTROL,TEXT(""),
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | TCS_TABS | TCS_SINGLELINE,
										0,0,0,0,hwndParent,NULL,hInst,NULL);
	if (hwnd==NULL)
		return NULL;
	SendMessage(hwnd,WM_SETFONT,(WPARAM)GetStockObject(DEFAULT_GUI_FONT),
																		FALSE);
	himl=ImageList_LoadImage(hInst,MAKEINTRESOURCE(IDB_TAB),16,1,RGB(0,255,0),
															IMAGE_BITMAP,0);
	(void)TabCtrl_SetImageList(hwnd,himl);
	tci.mask=TCIF_TEXT | TCIF_IMAGE;
	tci.pszText=szText;
	for (i=0;i<NUM_DATA_TYPES;i++) {
		LoadString(hInst,IDS_DATATYPEBASE+i,szText,numberof(szText));
		tci.cchTextMax=lstrlen(szText);
		tci.iImage=i;
		TabCtrl_InsertItem(hwnd,i,&tci);
	}
	TabCtrl_SetCurSel(hwnd,CurDataListType);
	return hwnd;
}


static HWND CreateDataListWindow(HWND hwndParent,DataType Type)
{
	HWND hwnd;
	LVCOLUMN lvc;
	TCHAR szText[64];
	int i;
	HIMAGELIST himl;

	/* Xgr[̍쐬 */
	hwnd=CreateWindowEx(WS_EX_CLIENTEDGE,WC_LISTVIEW,TEXT(""),
		WS_CHILD | WS_HSCROLL | WS_VSCROLL | LVS_REPORT | LVS_SINGLESEL |
															LVS_SHOWSELALWAYS,
		0,0,0,0,hwndParent,NULL,hInst,NULL);
	if (hwnd==NULL)
		return NULL;
	(void)ListView_SetExtendedListViewStyle(hwnd,
				LVS_EX_GRIDLINES | LVS_EX_CHECKBOXES | LVS_EX_FULLROWSELECT);
	/* J̐ݒ */
	lvc.mask=LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
	lvc.pszText=szText;
	switch (Type) {
	case DATATYPE_IMAGE:
		{
			static const struct {
				int fmt;
				int TextID;
			} ImageColumnList[] = {
				{LVCFMT_LEFT,	IDS_COLUMN_SAVE},
				{LVCFMT_LEFT,	IDS_COLUMN_ADDRESS},
				{LVCFMT_LEFT,	IDS_COLUMN_IMAGESIZE},
				{LVCFMT_RIGHT,	IDS_COLUMN_BITSPERPIXEL},
				{LVCFMT_RIGHT,	IDS_COLUMN_DATASIZE},
			};

			for (i=0;i<numberof(ImageColumnList);i++) {
				lvc.fmt=ImageColumnList[i].fmt;
				lvc.cx=ImageListColumnWidth[i];
				lvc.iSubItem=i;
				LoadString(hInst,ImageColumnList[i].TextID,
													szText,numberof(szText));
				ListView_InsertColumn(hwnd,i,&lvc);
			}
			himl=ImageList_LoadImage(hInst,MAKEINTRESOURCE(IDB_IMAGEDATA),16,1,
												RGB(0,255,0),IMAGE_BITMAP,0);
			if (himl!=NULL)
				(void)ListView_SetImageList(hwnd,himl,LVSIL_SMALL);
		}
		break;

	case DATATYPE_SOUND:
		{
			static const struct {
				int fmt;
				int TextID;
			} SoundColumnList[] = {
				{LVCFMT_LEFT,	IDS_COLUMN_SAVE},
				{LVCFMT_LEFT,	IDS_COLUMN_ADDRESS},
				{LVCFMT_RIGHT,	IDS_COLUMN_LENGTH},
				{LVCFMT_RIGHT,	IDS_COLUMN_CHANNELS},
				{LVCFMT_RIGHT,	IDS_COLUMN_DATASIZE},
			};

			for (i=0;i<numberof(SoundColumnList);i++) {
				lvc.fmt=SoundColumnList[i].fmt;
				lvc.cx=SoundListColumnWidth[i];
				lvc.iSubItem=i;
				LoadString(hInst,SoundColumnList[i].TextID,
													szText,numberof(szText));
				ListView_InsertColumn(hwnd,i,&lvc);
			}
			himl=ImageList_LoadImage(hInst,MAKEINTRESOURCE(IDB_SOUNDDATA),16,1,
												RGB(0,255,0),IMAGE_BITMAP,0);
			if (himl!=NULL)
				(void)ListView_SetImageList(hwnd,himl,LVSIL_SMALL);
		}
		break;

	case DATATYPE_VIDEO:
		{
			static const struct {
				int fmt;
				int TextID;
			} VideoColumnList[] = {
				{LVCFMT_LEFT,	IDS_COLUMN_SAVE},
				{LVCFMT_LEFT,	IDS_COLUMN_ADDRESS},
				{LVCFMT_LEFT,	IDS_COLUMN_VIDEOSIZE},
				{LVCFMT_RIGHT,	IDS_COLUMN_LENGTH},
				{LVCFMT_RIGHT,	IDS_COLUMN_DATASIZE},
			};

			for (i=0;i<numberof(VideoColumnList);i++) {
				lvc.fmt=VideoColumnList[i].fmt;
				lvc.cx=VideoListColumnWidth[i];
				lvc.iSubItem=i;
				LoadString(hInst,VideoColumnList[i].TextID,
													szText,numberof(szText));
				ListView_InsertColumn(hwnd,i,&lvc);
			}
			himl=ImageList_LoadImage(hInst,MAKEINTRESOURCE(IDB_VIDEODATA),16,1,
												RGB(0,255,0),IMAGE_BITMAP,0);
			if (himl!=NULL)
				(void)ListView_SetImageList(hwnd,himl,LVSIL_SMALL);
		}
		break;
	}
	return hwnd;
}


static HWND CreateDataListFormWindow(HWND hwndParent)
{
	HWND hwnd;

	hwnd=CreateWindow(DATALIST_FORM_WINDOW_CLASS,NULL,
						WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN,
						0,0,0,0,hwndParent,(HMENU)IDC_DATALISTFORM,hInst,NULL);
	if (hwnd==NULL)
		return NULL;
	return hwnd;
}


static BOOL SetPreview(const SourceFileInfo *pInfo)
{
	if (pInfo->DataList[pInfo->CurDataType].nSelItem>=0) {
		const DataInfo *pItem;

		pItem=GetDataListItemInfo(hwndDataList[CurDataListType],
								pInfo->DataList[pInfo->CurDataType].nSelItem);
		switch (pItem->Format) {
		case FORMAT_DIB:
			Preview_SetDIB(hwndPreview,(BYTE*)pInfo->pData+pItem->Address,
																pItem->Size);
			return TRUE;

		case FORMAT_JPEG:
			{
				BITMAPINFO *pbmi;

				pbmi=JPEGConvertToDIB((BYTE*)pInfo->pData+pItem->Address,
																pItem->Size);
				if (pbmi==NULL)
					break;
				Preview_SetDIB(hwndPreview,pbmi,DIBCalcBytes(&pbmi->bmiHeader));
				MemFree(pbmi);
			}
			return TRUE;

		case FORMAT_PNG:
			{
				BITMAPINFO *pbmi;

				pbmi=PNGConvertToDIB((BYTE*)pInfo->pData+pItem->Address,
																pItem->Size);
				if (pbmi==NULL)
					break;
				Preview_SetDIB(hwndPreview,pbmi,DIBCalcBytes(&pbmi->bmiHeader));
				MemFree(pbmi);
			}
			return TRUE;

		case FORMAT_MAG:
			{
				BITMAPINFO *pbmi;

				pbmi=MAGConvertToDIB((BYTE*)pInfo->pData+pItem->Address,
																pItem->Size);
				if (pbmi==NULL)
					break;
				Preview_SetDIB(hwndPreview,pbmi,DIBCalcBytes(&pbmi->bmiHeader));
				MemFree(pbmi);
			}
			return TRUE;

		case FORMAT_ICON:
		case FORMAT_CURSOR:
			{
				BITMAPINFO *pbmi;

				pbmi=IconConvertToDIB((BYTE*)pInfo->pData+pItem->Address,
											GetSysColor(COLOR_APPWORKSPACE));
				if (pbmi==NULL)
					break;
				Preview_SetDIB(hwndPreview,pbmi,DIBCalcBytes(&pbmi->bmiHeader));
				MemFree(pbmi);
			}
			return TRUE;

		case FORMAT_ANI:
			{
				BITMAPINFO *pbmi;

				pbmi=ANIConvertToDIB((BYTE*)pInfo->pData+pItem->Address,
											GetSysColor(COLOR_APPWORKSPACE));
				if (pbmi==NULL)
					break;
				Preview_SetDIB(hwndPreview,pbmi,DIBCalcBytes(&pbmi->bmiHeader));
				MemFree(pbmi);
			}
			return TRUE;

		case FORMAT_WAVE:
			Preview_SetWave(hwndPreview,(BYTE*)pInfo->pData+pItem->Address,
																pItem->Size);
			return TRUE;

		case FORMAT_MIDI:
			Preview_SetMidi(hwndPreview,(BYTE*)pInfo->pData+pItem->Address,
																pItem->Size);
			return TRUE;

		case FORMAT_MP3:
			Preview_SetMP3(hwndPreview,(BYTE*)pInfo->pData+pItem->Address,
																pItem->Size);
			return TRUE;

		case FORMAT_AVI:
			Preview_SetAVI(hwndPreview,(BYTE*)pInfo->pData+pItem->Address,
																pItem->Size);
			return TRUE;
		}
	}
	Preview_Reset(hwndPreview);
	return FALSE;
}


typedef struct {
	int nColumn;
	BOOL fAscending;
} SortDataInfo;


#define COMPARE_VALUE(Value1,Value2) \
								((Value1)<(Value2)?-1:(Value1)>(Value2)?1:0)


static int CALLBACK ImageCmpCallback(LPARAM lParam1,LPARAM lParam2,
															LPARAM lParamSort)
{
	const DataInfo *pItem1=(const DataInfo*)lParam1;
	const DataInfo *pItem2=(const DataInfo*)lParam2;
	const SortDataInfo *pInfo=(const SortDataInfo*)lParamSort;
	int nCmp;

	switch (pInfo->nColumn) {
	case 0:
		nCmp=COMPARE_VALUE(pItem1->Format,pItem2->Format);
		break;
	case 1:
		nCmp=0;
		break;
	case 2:
	case 3:
		{
			ImageInfo imginfo1,imginfo2;

			GetImageDataInfo(pItem1->Format,
				(BYTE*)pCurrentSourceFile->pData+pItem1->Address,pItem1->Size,
																	&imginfo1);
			GetImageDataInfo(pItem2->Format,
				(BYTE*)pCurrentSourceFile->pData+pItem2->Address,pItem2->Size,
																	&imginfo2);
			if (pInfo->nColumn==2) {
				nCmp=imginfo1.nWidth-imginfo2.nWidth;
				if (nCmp==0)
					nCmp=imginfo1.nHeight-imginfo2.nHeight;
			} else
				nCmp=imginfo1.nBitsPerPixel-imginfo2.nBitsPerPixel;
		}
		break;
	case 4:
		nCmp=COMPARE_VALUE(pItem1->Size,pItem2->Size);
		break;
	default:
		return 0;
	}
	if (nCmp==0) {
		if (pItem1->Address<pItem2->Address)
			nCmp=-1;
		else
			nCmp=1;
	}
	return pInfo->fAscending?nCmp:-nCmp;
}


static int CALLBACK SoundCmpCallback(LPARAM lParam1,LPARAM lParam2,
															LPARAM lParamSort)
{
	const DataInfo *pItem1=(const DataInfo*)lParam1;
	const DataInfo *pItem2=(const DataInfo*)lParam2;
	const SortDataInfo *pInfo=(const SortDataInfo*)lParamSort;
	int nCmp;

	switch (pInfo->nColumn) {
	case 0:
		nCmp=COMPARE_VALUE(pItem1->Format,pItem2->Format);
		break;
	case 1:
		nCmp=0;
		break;
	case 2:
	case 3:
		{
			SoundInfo sndinfo1,sndinfo2;
			BOOL f1,f2;

			f1=GetSoundDataInfo(pItem1->Format,
				(BYTE*)pCurrentSourceFile->pData+pItem1->Address,pItem1->Size,
																	&sndinfo1);
			f2=GetSoundDataInfo(pItem2->Format,
				(BYTE*)pCurrentSourceFile->pData+pItem2->Address,pItem2->Size,
																	&sndinfo2);
			if (f1 && f2) {
				if (pInfo->nColumn==2)
					nCmp=COMPARE_VALUE(sndinfo1.uLength,sndinfo2.uLength);
				else
					nCmp=sndinfo1.nChannels-sndinfo2.nChannels;
			} else if (f1)
				nCmp=1;
			else if (f2)
				nCmp=-1;
			else
				nCmp=0;
		}
		break;
	case 4:
		nCmp=COMPARE_VALUE(pItem1->Size,pItem2->Size);
		break;
	default:
		return 0;
	}
	if (nCmp==0) {
		if (pItem1->Address<pItem2->Address)
			nCmp=-1;
		else
			nCmp=1;
	}
	return pInfo->fAscending?nCmp:-nCmp;
}


static int CALLBACK VideoCmpCallback(LPARAM lParam1,LPARAM lParam2,
															LPARAM lParamSort)
{
	const DataInfo *pItem1=(const DataInfo*)lParam1;
	const DataInfo *pItem2=(const DataInfo*)lParam2;
	const SortDataInfo *pInfo=(const SortDataInfo*)lParamSort;
	int nCmp;

	switch (pInfo->nColumn) {
	case 0:
		nCmp=COMPARE_VALUE(pItem1->Format,pItem2->Format);
		break;
	case 1:
		nCmp=0;
		break;
	case 2:
	case 3:
		{
			VideoInfo vinfo1,vinfo2;

			GetVideoDataInfo(pItem1->Format,
				(BYTE*)pCurrentSourceFile->pData+pItem1->Address,pItem1->Size,
																	&vinfo1);
			GetVideoDataInfo(pItem2->Format,
				(BYTE*)pCurrentSourceFile->pData+pItem2->Address,pItem2->Size,
																	&vinfo2);
			if (pInfo->nColumn==2) {
				nCmp=vinfo1.nWidth-vinfo2.nWidth;
				if (nCmp==0)
					nCmp=vinfo1.nHeight-vinfo2.nHeight;
			} else
				nCmp=COMPARE_VALUE(vinfo1.uLength,vinfo2.uLength);
		}
		break;
	case 4:
		nCmp=COMPARE_VALUE(pItem1->Size,pItem2->Size);
		break;
	default:
		return 0;
	}
	if (nCmp==0) {
		if (pItem1->Address<pItem2->Address)
			nCmp=-1;
		else
			nCmp=1;
	}
	return pInfo->fAscending?nCmp:-nCmp;
}


static LRESULT CALLBACK DataListFormWndProc(HWND hWnd,UINT uMsg,WPARAM wParam,
																LPARAM lParam)
{
	switch (uMsg) {
	case WM_CREATE:
		{
			int i;

			hwndDataListTab=CreateDataListTabWindow(hWnd);
			if (hwndDataListTab==NULL)
				return -1;
			for (i=0;i<NUM_DATA_TYPES;i++)
				hwndDataList[i]=CreateDataListWindow(hWnd,(DataType)i);
			ShowWindow(hwndDataList[CurDataListType],SW_SHOW);
			BringWindowToTop(hwndDataList[CurDataListType]);
		}
		return 0;

	case WM_SIZE:
		{
			RECT rc;

			rc.left=0;
			rc.top=GetSystemMetrics(SM_CYFRAME);
			rc.right=LOWORD(lParam);
			rc.bottom=HIWORD(lParam);
			MoveWindow(hwndDataListTab,0,0,rc.right,rc.bottom,TRUE);
			TabCtrl_AdjustRect(hwndDataListTab,FALSE,&rc);
			MoveWindow(hwndDataList[CurDataListType],rc.left,rc.top,
									rc.right-rc.left,rc.bottom-rc.top,TRUE);
		}
		return 0;

	case WM_NOTIFY:
		switch (((LPNMHDR)lParam)->code) {
		case TCN_SELCHANGE:
			{
				int nSel=TabCtrl_GetCurSel(hwndDataListTab);
				RECT rc;

				if ((int)CurDataListType==nSel)
					return 0;
				GetClientRect(hWnd,&rc);
				rc.top=GetSystemMetrics(SM_CYFRAME);
				TabCtrl_AdjustRect(hwndDataListTab,FALSE,&rc);
				SetWindowPos(hwndDataList[nSel],HWND_TOP,rc.left,rc.top,
										rc.right-rc.left,rc.bottom-rc.top,0);
				ShowWindow(hwndDataList[nSel],SW_SHOW);
				ShowWindow(hwndDataList[CurDataListType],SW_HIDE);
				CurDataListType=(DataType)nSel;
				if (pCurrentSourceFile!=NULL) {
					TCHAR szTmp[64],szText[64],szValue[32];

					pCurrentSourceFile->CurDataType=CurDataListType;
					if (LoadString(hInst,IDS_DATALISTINFOBASE+
											pCurrentSourceFile->CurDataType,
													szTmp,numberof(szTmp))>0) {
						FormatUInt(pCurrentSourceFile->DataList[
							pCurrentSourceFile->CurDataType].List.nNumItems,
													szValue,numberof(szValue));
						wsprintf(szText,szTmp,szValue);
						SendMessage(hwndStatusBar,SB_SETTEXT,0,(LPARAM)szText);
					}
					SetDataTypeChangedMenuStatus(pCurrentSourceFile);
					SetPreview(pCurrentSourceFile);
				}
			}
			return 0;

		case LVN_ITEMCHANGED:
			{
				int nSelItem=ListView_GetNextItem(
							hwndDataList[CurDataListType],-1,LVNI_SELECTED);

				if (pCurrentSourceFile->DataList[
						pCurrentSourceFile->CurDataType].nSelItem!=nSelItem) {
					pCurrentSourceFile->DataList[
							pCurrentSourceFile->CurDataType].nSelItem=nSelItem;
					SetItemChangedMenuStatus(pCurrentSourceFile);
					SetPreview(pCurrentSourceFile);
				}
			}
			return 0;

		case LVN_COLUMNCLICK:
			if (pCurrentSourceFile!=NULL
					&& pCurrentSourceFile->DataList[
						pCurrentSourceFile->CurDataType].List.nNumItems>1) {
				const NM_LISTVIEW *pnmlv=(LPNMLISTVIEW)lParam;
				SortDataInfo Info;

				if (pnmlv->iSubItem==
						pCurrentSourceFile->DataList[
							pCurrentSourceFile->CurDataType].nCurSortColumn) {
					pCurrentSourceFile->DataList[
							pCurrentSourceFile->CurDataType].fSortAscending=
						!pCurrentSourceFile->DataList[
							pCurrentSourceFile->CurDataType].fSortAscending;
				} else {
					pCurrentSourceFile->DataList[
							pCurrentSourceFile->CurDataType].nCurSortColumn=
															pnmlv->iSubItem;
					pCurrentSourceFile->DataList[
						pCurrentSourceFile->CurDataType].fSortAscending=TRUE;
				}
				Info.nColumn=pnmlv->iSubItem;
				Info.fAscending=pCurrentSourceFile->DataList[
							pCurrentSourceFile->CurDataType].fSortAscending;
				switch (pCurrentSourceFile->CurDataType) {
				case DATATYPE_IMAGE:
					ListView_SortItems(pnmlv->hdr.hwndFrom,ImageCmpCallback,
																(LPARAM)&Info);
					break;
				case DATATYPE_SOUND:
					ListView_SortItems(pnmlv->hdr.hwndFrom,SoundCmpCallback,
																(LPARAM)&Info);
					break;
				case DATATYPE_VIDEO:
					ListView_SortItems(pnmlv->hdr.hwndFrom,VideoCmpCallback,
																(LPARAM)&Info);
					break;
				}
			}
			return 0;

		case NM_RCLICK:
			if (((LPNMHDR)lParam)->hwndFrom==hwndDataList[CurDataListType]) {
				POINT pt;

				GetCursorPos(&pt);
				PopupMenu(pCurrentSourceFile,pt.x,pt.y);
			}
			return 0;

		case NM_DBLCLK:
			if (((LPNMHDR)lParam)->hwndFrom==hwndDataList[CurDataListType]) {
				if (pCurrentSourceFile!=NULL
						&& pCurrentSourceFile->DataList[
								pCurrentSourceFile->CurDataType].nSelItem>=0)
					SendMessage(hwndMain,WM_COMMAND,MAKEWPARAM(CM_SAVE,0),0);
			}
			return 0;
		}
		break;
	}
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}




/******************************************************************************

	e_CAOvV[W

******************************************************************************/


typedef struct {
	const BYTE *pData;
	DataInfo Info;
} DataInfoDlgInfo;


static void InitDataInfoDialog(HWND hDlg,const DataInfoDlgInfo *pInfo)
{
	TCHAR szText[64],szFormat[64];

	FormatAddress(pInfo->Info.Address,szText);
	SetDlgItemText(hDlg,IDC_INFO_ADDRESS,szText);
	if (LoadString(hInst,IDS_DATAINFO_FILESIZE,szFormat,numberof(szFormat))>0) {
		TCHAR szValue[32];

		FormatSize(pInfo->Info.Size,szValue,numberof(szValue));
		wsprintf(szText,szFormat,szValue);
		SetDlgItemText(hDlg,IDC_INFO_DATASIZE,szText);
	}
	LoadString(hInst,IDS_FORMAT_BASE+(int)pInfo->Info.Format,
													szText,numberof(szText));
	SetDlgItemText(hDlg,IDC_INFO_FORMAT,szText);
}


/*
	摜̏
*/
static INT_PTR CALLBACK ImageInfoDlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,
																LPARAM lParam)
{
	switch (uMsg) {
	case WM_INITDIALOG:
		{
			DataInfoDlgInfo *pInfo=(DataInfoDlgInfo*)lParam;
			TCHAR szText[64];
			ImageInfo imginfo;

			InitDataInfoDialog(hDlg,pInfo);
			GetImageDataInfo(pInfo->Info.Format,
				pInfo->pData+pInfo->Info.Address,pInfo->Info.Size,&imginfo);
			{
				TCHAR szWidth[16],szHeight[16];

				FormatUInt(imginfo.nWidth,szWidth,numberof(szWidth));
				FormatUInt(imginfo.nHeight,szHeight,numberof(szHeight));
				wsprintf(szText,TEXT("%s x %s"),szWidth,szHeight);
			}
			SetDlgItemText(hDlg,IDC_IMAGEINFO_SIZE,szText);
			FormatUInt(imginfo.nBitsPerPixel,szText,numberof(szText));
			SetDlgItemText(hDlg,IDC_IMAGEINFO_BITSPERPIXEL,szText);
			switch (pInfo->Info.Format) {
			case FORMAT_DIB:
				{
					const BYTE *p=pInfo->pData+pInfo->Info.Address;
					const BITMAPINFOHEADER *pbmih;

					if (p[0]=='B' && p[1]=='M') {
						SetDlgItemText(hDlg,IDC_INFO_FORMAT,TEXT("BMP"));
						pbmih=(BITMAPINFOHEADER*)(p+sizeof(BITMAPFILEHEADER));
					} else {
						SetDlgItemText(hDlg,IDC_INFO_FORMAT,TEXT("DIB"));
						pbmih=(BITMAPINFOHEADER*)p;
					}
					if (LoadString(hInst,pbmih->biCompression==BI_RGB
							|| pbmih->biCompression==BI_BITFIELDS?
										IDS_NOCOMPRESSION:IDS_RLECOMPRESSION,
													szText,numberof(szText))>0)
						SetDlgItemText(hDlg,IDC_IMAGEINFO_COMPRESSION,szText);
				}
				break;
			case FORMAT_PNG:
				SetDlgItemText(hDlg,IDC_IMAGEINFO_COMPRESSION,TEXT("Deflate"));
				break;
			}
			AdjustDialogPos(hwndMain,hDlg);
		}
		return TRUE;

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDOK:
		case IDCANCEL:
			EndDialog(hDlg,LOWORD(wParam));
		}
		return TRUE;
	}
	return FALSE;
}


/*
	̏
*/
static INT_PTR CALLBACK SoundInfoDlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,
																LPARAM lParam)
{
	switch (uMsg) {
	case WM_INITDIALOG:
		{
			DataInfoDlgInfo *pInfo=(DataInfoDlgInfo*)lParam;
			SoundInfo sndinfo;

			InitDataInfoDialog(hDlg,pInfo);
			if (GetSoundDataInfo(pInfo->Info.Format,
							pInfo->pData+pInfo->Info.Address,pInfo->Info.Size,
																&sndinfo)) {
				TCHAR szText[64],szValue[32];

				FormatUInt(sndinfo.uLength,szValue,numberof(szValue));
				wsprintf(szText,TEXT("%s ms"),szValue);
				SetDlgItemText(hDlg,IDC_SOUNDINFO_LENGTH,szText);
				FormatUInt(sndinfo.nChannels,szText,numberof(szText));
				SetDlgItemText(hDlg,IDC_SOUNDINFO_CHANNELS,szText);
				FormatUInt(sndinfo.nBitsPerSample,szText,numberof(szText));
				SetDlgItemText(hDlg,IDC_SOUNDINFO_BITSPERSAMPLE,szText);
				FormatUInt(sndinfo.nSamplesPerSec,szValue,numberof(szValue));
				wsprintf(szText,TEXT("%s Hz"),szValue);
				SetDlgItemText(hDlg,IDC_SOUNDINFO_SAMPLESPERSEC,szText);
			}
			AdjustDialogPos(hwndMain,hDlg);
		}
		return TRUE;

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDOK:
		case IDCANCEL:
			EndDialog(hDlg,LOWORD(wParam));
		}
		return TRUE;
	}
	return FALSE;
}


/*
	̏
*/
static INT_PTR CALLBACK VideoInfoDlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,
																LPARAM lParam)
{
	switch (uMsg) {
	case WM_INITDIALOG:
		{
			DataInfoDlgInfo *pInfo=(DataInfoDlgInfo*)lParam;
			VideoInfo vinfo;

			InitDataInfoDialog(hDlg,pInfo);
			if (GetVideoDataInfo(pInfo->Info.Format,
					pInfo->pData+pInfo->Info.Address,pInfo->Info.Size,&vinfo)) {
				TCHAR szText[64],szValue[32],szWidth[16],szHeight[16];

				FormatUInt(vinfo.nWidth,szWidth,numberof(szWidth));
				FormatUInt(vinfo.nHeight,szHeight,numberof(szHeight));
				wsprintf(szText,TEXT("%s x %s"),szWidth,szHeight);
				SetDlgItemText(hDlg,IDC_VIDEOINFO_SIZE,szText);
				FormatUInt(vinfo.uLength,szValue,numberof(szValue));
				wsprintf(szText,TEXT("%s ms"),szValue);
				SetDlgItemText(hDlg,IDC_VIDEOINFO_LENGTH,szText);
			}
			AdjustDialogPos(hwndMain,hDlg);
		}
		return TRUE;

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDOK:
		case IDCANCEL:
			EndDialog(hDlg,LOWORD(wParam));
		}
		return TRUE;
	}
	return FALSE;
}


/*
	ݒ_CAOvV[W
*/
static INT_PTR CALLBACK OptionsDlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,
																LPARAM lParam)
{
	switch (uMsg) {
	case WM_INITDIALOG:
		CheckDlgButton(hDlg,IDC_OPTIONS_ASKOVERWRITE,
									fAskOverWrite?BST_CHECKED:BST_UNCHECKED);
		CheckDlgButton(hDlg,IDC_OPTIONS_SHOWFULLPATH,
								fShowFullPathName?BST_CHECKED:BST_UNCHECKED);
		CheckDlgButton(hDlg,IDC_OPTIONS_SHOWTIPHELP,
									fShowTipHelp?BST_CHECKED:BST_UNCHECKED);
		SetDlgItemInt(hDlg,IDC_OPTIONS_MAXLOADSIZE,
										uMaxFileLoadSize/(1024*1024),FALSE);
		SendDlgItemMessage(hDlg,IDC_OPTIONS_MAXLOADSIZE_UD,UDM_SETRANGE,0,
														MAKELPARAM(1024,1));
		CheckDlgButton(hDlg,IDC_OPTIONS_NOTICESIZELIMIT,
								fNoticeSizeLimit?BST_CHECKED:BST_UNCHECKED);
		AdjustDialogPos(hwndMain,hDlg);
		return TRUE;

	case WM_HELP:
		{
			LPHELPINFO phi=(LPHELPINFO)lParam;

			if (phi->iContextType==HELPINFO_WINDOW && phi->hItemHandle!=hDlg) {
				static const DWORD dwHelpIDs[] = {
					IDC_OPTIONS_ASKOVERWRITE,	IDH_OPTIONS_ASKOVERWRITE,
					IDC_OPTIONS_SHOWFULLPATH,	IDH_OPTIONS_SHOWFULLPATH,
					IDC_OPTIONS_SHOWTIPHELP,	IDH_OPTIONS_SHOWTIPHELP,
					IDC_OPTIONS_MAXLOADSIZE,	IDH_OPTIONS_MAXLOADSIZE,
					IDC_OPTIONS_MAXLOADSIZE_UD,	IDH_OPTIONS_MAXLOADSIZE,
					IDC_OPTIONS_NOTICESIZELIMIT,IDH_OPTIONS_NOTICESIZELIMIT,
					0,							0
				};
				int i;

				for (i=0;dwHelpIDs[i]!=0;i+=2)
					if ((int)dwHelpIDs[i]==phi->iCtrlId)
						break;
				if (dwHelpIDs[i]==0)
					return TRUE;
				if (LoadHtmlHelpLibrary())
					(*pfnHtmlHelp)(phi->hItemHandle,szHelpFileName,
										HH_TP_HELP_WM_HELP,(DWORD)dwHelpIDs);
			}
		}
		return TRUE;

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDC_OPTIONS_HELP:
			ShowHelp(IDH_OPTIONS);
			return 0;
		case IDOK:
			{
				UINT MaxSize;

				MaxSize=GetDlgItemInt(hDlg,IDC_OPTIONS_MAXLOADSIZE,NULL,FALSE);
				if (MaxSize==0 || MaxSize>2048) {
					ResMessageBox(hDlg,IDS_MSG_MAXLOADSIZE,0,
												MB_OK | MB_ICONEXCLAMATION);
					return TRUE;
				}
				uMaxFileLoadSize=MaxSize*(1024*1024);
			}
			fAskOverWrite=IsDlgButtonChecked(hDlg,IDC_OPTIONS_ASKOVERWRITE)==
																BST_CHECKED;
			{
				BOOL f;

				f=IsDlgButtonChecked(hDlg,IDC_OPTIONS_SHOWFULLPATH)==
																BST_CHECKED;
				if (fShowFullPathName!=f) {
					fShowFullPathName=f;
					if (pCurrentSourceFile!=NULL)
						SetWindowTitle(pCurrentSourceFile);
				}
				f=IsDlgButtonChecked(hDlg,IDC_OPTIONS_SHOWTIPHELP)==
																BST_CHECKED;
				if (fShowTipHelp!=f) {
					fShowTipHelp=f;
					ShowToolbarTipHelp(hwndToolbar,fShowTipHelp);
					Preview_ShowTipHelp(hwndPreview,fShowTipHelp);
				}
			}
			fNoticeSizeLimit=IsDlgButtonChecked(hDlg,
									IDC_OPTIONS_NOTICESIZELIMIT)==BST_CHECKED;
		case IDCANCEL:
			EndDialog(hDlg,LOWORD(wParam));
			return TRUE;
		}
		return TRUE;
	}
	return FALSE;
}


/*
	o[W_CAOvV[W
*/
static INT_PTR CALLBACK AboutDlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,
																LPARAM lParam)
{
	static HFONT hfontLink;

	switch (uMsg) {
	case WM_INITDIALOG:
		{
			TCHAR szVersion[256],szText[256];
			LOGFONT lf;

			GetDlgItemText(hDlg,IDC_ABOUT_VERSION,szVersion,numberof(szVersion));
			wsprintf(szText,szVersion,TEXT(VERSION_TEXT));
			SetDlgItemText(hDlg,IDC_ABOUT_VERSION,szText);
			GetObject((HFONT)SendMessage(hDlg,WM_GETFONT,0,0),
														sizeof(LOGFONT),&lf);
			lf.lfUnderline=1;
			hfontLink=CreateFontIndirect(&lf);
			SendDlgItemMessage(hDlg,IDC_ABOUT_WEB,WM_SETFONT,
													(WPARAM)hfontLink,FALSE);
			AdjustDialogPos(hwndMain,hDlg);
		}
		return TRUE;

	case WM_CTLCOLORSTATIC:
		if ((HWND)lParam==GetDlgItem(hDlg,IDC_ABOUT_WEB)) {
			SetTextColor((HDC)wParam,RGB(0,0,255));
			SetBkMode((HDC)wParam,TRANSPARENT);
			return (INT_PTR)GetStockObject(NULL_BRUSH);
		}
		break;

	case WM_SETCURSOR:
		if ((HWND)wParam==GetDlgItem(hDlg,IDC_ABOUT_WEB)) {
			SetCursor(LoadCursor(NULL,IDC_HAND));
			SetWindowLongPtr(hDlg,DWLP_MSGRESULT,TRUE);
			return TRUE;
		}
		break;

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDC_ABOUT_WEB:
			if (HIWORD(wParam)==STN_CLICKED)
				ShellExecute(NULL,TEXT("open"),
							TEXT("http://www.geocities.jp/iooiau/"),NULL,NULL,
																SW_SHOWNORMAL);
			return TRUE;
		case IDOK:
		case IDCANCEL:
			EndDialog(hDlg,LOWORD(wParam));
		}
		return TRUE;

	case WM_DESTROY:
		DeleteObject(hfontLink);
		return TRUE;
	}
	return FALSE;
}


/*
	CEBhEvV[W
*/
static LRESULT CALLBACK WndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	switch (uMsg) {
	case WM_CREATE:
		{
			/* c[o[̍쐬 */
			hwndToolbar=CreateMainToolbar(hWnd);
			if (hwndToolbar==NULL)
				return -1;
			/* Xe[^Xo[̍쐬 */
			hwndStatusBar=CreateMainStatusBar(hWnd);
			if (hwndStatusBar==NULL)
				return -1;
			SetStatusBarText(NULL);
			/* Xvbgo[̍쐬 */
			hwndSplitBar=CreateWindow(SPLITBAR_CLASS,NULL,
						WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | SPLBS_VERT,
						0,0,0,0,hWnd,(HMENU)IDC_SPLITTER,hInst,NULL);
			if (hwndSplitBar==NULL)
				return -1;
			/* f[^XgEBhE̍쐬 */
			hwndDataListForm=CreateDataListFormWindow(hwndSplitBar);
			if (hwndDataListForm==NULL)
				return -1;
			/* vr[EBhE̍쐬 */
			hwndPreview=CreateWindow(PREVIEW_WINDOW_CLASS,NULL,
						WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN,
						0,0,0,0,hwndSplitBar,(HMENU)IDC_PREVIEW,hInst,NULL);
			if (hwndPreview==NULL)
				return -1;
			/* Xvbgo[̐ݒ */
			SplitBar_SetChild(hwndSplitBar,0,hwndDataListForm);
			SplitBar_SetChild(hwndSplitBar,1,hwndPreview);
			SplitBar_SetMinSize(hwndSplitBar,0,80);
			SplitBar_SetMinSize(hwndSplitBar,1,80);
			SplitBar_SetPos(hwndSplitBar,SplitterPos);
		}
		return 0;

	case WM_SIZE:
		{
			RECT rcClient,rc;

			rcClient.bottom=HIWORD(lParam);
			if (fShowToolbar) {
				SendMessage(hwndToolbar,TB_AUTOSIZE,0,0);
				GetWindowRect(hwndToolbar,&rc);
				rcClient.top=rc.bottom-rc.top;
			} else {
				rcClient.top=0;
			}
			if (fShowStatusBar) {
				GetWindowRect(hwndStatusBar,&rc);
				rcClient.bottom-=rc.bottom-rc.top;
				MoveWindow(hwndStatusBar,0,rcClient.bottom,
										LOWORD(lParam),rc.bottom-rc.top,TRUE);
			}
			MoveWindow(hwndSplitBar,0,rcClient.top,
							LOWORD(lParam),rcClient.bottom-rcClient.top,TRUE);
		}
		return 0;

	case WM_NOTIFY:
		switch (((LPNMHDR)lParam)->code) {
		case TTN_NEEDTEXT:
			{
				LPTOOLTIPTEXT pttt=(LPTOOLTIPTEXT)lParam;

				pttt->lpszText=(LPTSTR)(IDS_SHORTCMBASE+pttt->hdr.idFrom);
				pttt->hinst=hInst;
			}
			return 0;

		case TTN_SHOW:
			/* Xe[^Xo[Ƀc[{^̐\ */
			if (fShowStatusBar) {
				TCHAR szText[128];

				if (LoadString(hInst,((LPNMHDR)lParam)->idFrom,
												szText,numberof(szText))>0) {
					SendMessage(hwndStatusBar,SB_SIMPLE,TRUE,0);
					SendMessage(hwndStatusBar,SB_SETTEXT,SBT_NOBORDERS | 255,
															(LPARAM)szText);
				}
			}
			return 0;

		case TTN_POP:
			/* Xe[^Xo[̃c[{^̐ */
			if (fShowStatusBar) {
				SendMessage(hwndStatusBar,SB_SETTEXT,255,(LPARAM)TEXT(""));
				SendMessage(hwndStatusBar,SB_SIMPLE,FALSE,0);
			}
			return 0;
		}
		break;

	case WM_MENUSELECT:
		/* j[ڂ̐\ */
		if (fShowStatusBar) {
			HMENU hmenu=GetMenu(hWnd);
			UINT uIDs[2]={0,0};

			MenuHelp(uMsg,wParam,lParam,hmenu,hInst,hwndStatusBar,uIDs);
		}
		return 0;

	case WM_DROPFILES:
		/* hbvꂽt@CJ */
		{
			HDROP hdrop=(HDROP)wParam;
			int nNumFiles;
			TCHAR szFileName[MAX_PATH];
			DWORD dwAttributes;

			SetForegroundWindow(hWnd);
			nNumFiles=DragQueryFile(hdrop,0xFFFFFFFF,NULL,0);
			if (nNumFiles>1) {
				DragFinish(hdrop);
				ResMessageBox(hWnd,IDS_MSG_DROPMULTIFILE,0,
												MB_OK | MB_ICONINFORMATION);
				return 0;
			}
			DragQueryFile(hdrop,0,szFileName,numberof(szFileName));
			dwAttributes=GetFileAttributes(szFileName);
			if (dwAttributes!=0xFFFFFFFF
							&& (dwAttributes&FILE_ATTRIBUTE_DIRECTORY)==0) {
				GetFileDirectory(szFileOpenDirectory,szFileName);
				OpenSourceFile(&pCurrentSourceFile,szFileName);
			}
			DragFinish(hdrop);
		}
		return 0;

/*
	case WM_CONTEXTMENU:
		{
			POINT pt={0,0};
			HWND hwndFocus=GetFocus();

			if (hwndFocus==hwndDataList[CurDataListType])
				ClientToScreen(hwndDataList[CurDataListType],&pt);
			else if (hwndFocus==hwndPreview)
				ClientToScreen(hwndPreview,&pt);
			else
				ClientToScreen(hWnd,&pt);
			PopupMenu(pCurrentSourceFile,pt.x,pt.y);
		}
		return 0;
*/

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDC_PREVIEW:
			if (HIWORD(wParam)==PVN_RBUTTONDOWN) {
				POINT pt;

				GetCursorPos(&pt);
				PopupMenu(pCurrentSourceFile,pt.x,pt.y);
			}
			return 0;

		case CM_OPEN:
			/* t@CJ */
			{
				TCHAR szFileName[MAX_PATH];
				TCHAR szFilter[256];
				OPENFILENAME ofn;

				szFileName[0]='\0';
				LoadFileFilter(IDS_FILEOPENFILTER,szFilter,numberof(szFilter));
				InitOpenFileNameStruct(&ofn);
				ofn.hwndOwner=hWnd;
				ofn.lpstrFilter=szFilter;
				ofn.nFilterIndex=nFileOpenFilterIndex;
				ofn.lpstrFile=szFileName;
				ofn.nMaxFile=numberof(szFileName);
				ofn.lpstrInitialDir=szFileOpenDirectory;
				ofn.Flags=OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
				if (GetOpenFileName(&ofn)) {
					GetFileDirectory(szFileOpenDirectory,szFileName);
					nFileOpenFilterIndex=ofn.nFilterIndex;
					UpdateWindow(hWnd);
					OpenSourceFile(&pCurrentSourceFile,szFileName);
				}
			}
			return 0;

		case CM_CLOSE:
			/* t@C */
			if (pCurrentSourceFile!=NULL)
				CloseSourceFile(&pCurrentSourceFile);
			return 0;

		case CM_SAVE:
			/* f[^ۑ */
			if (pCurrentSourceFile!=NULL
					&& pCurrentSourceFile->DataList[
								pCurrentSourceFile->CurDataType].nSelItem>=0) {
				const DataListItemInfo *pItem=DataList_GetItem(
					&pCurrentSourceFile->DataList[
										pCurrentSourceFile->CurDataType].List,
					pCurrentSourceFile->DataList[
									pCurrentSourceFile->CurDataType].nSelItem);
				OPENFILENAME ofn;
				TCHAR szFileName[MAX_PATH];
				TCHAR szFilter[256];
				HCURSOR hcurOld;
				ErrorType Err;

				szFileName[0]='\0';
				if (!LoadFileFilter(IDS_DATASAVEFILTERBASE+pItem->Data.Format,
												szFilter,numberof(szFilter))) {
					ErrMessageBox(hWnd,ERR_LOADSTRING,
												MB_OK | MB_ICONEXCLAMATION);
					return 0;
				}
				InitOpenFileNameStruct(&ofn);
				ofn.hwndOwner=hWnd;
				ofn.lpstrFilter=szFilter;
				ofn.nFilterIndex=1;
				ofn.lpstrFile=szFileName;
				ofn.nMaxFile=numberof(szFileName);
				ofn.lpstrInitialDir=szFileSaveDirectory;
				ofn.Flags=OFN_HIDEREADONLY;
				if (fAskOverWrite)
					ofn.Flags|=OFN_OVERWRITEPROMPT;
				ofn.lpstrDefExt=pszFormatExtensionList[pItem->Data.Format];
				if (!GetSaveFileName(&ofn))
					return 0;
				GetFileDirectory(szFileSaveDirectory,szFileName);
				hcurOld=SetCursor(LoadCursor(NULL,IDC_WAIT));
				Err=SaveDataFile(szFileName,pItem->Data.Format,
						(BYTE*)pCurrentSourceFile->pData+pItem->Data.Address,
															pItem->Data.Size);
				SetCursor(hcurOld);
				if (Err!=ERR_SUCCESS)
					ErrMessageBox(hWnd,Err,MB_OK | MB_ICONEXCLAMATION);
			}
			return 0;

		case CM_SAVEALL:
			/* SẴf[^ۑ */
			if (pCurrentSourceFile!=NULL)
				SaveAllData(hWnd,pCurrentSourceFile);
			return 0;

		case CM_SAVELIST:
			/* Xgۑ */
			if (pCurrentSourceFile!=NULL &&
					pCurrentSourceFile->DataList[
						pCurrentSourceFile->CurDataType].List.nNumItems>0) {
				TCHAR szFileName[MAX_PATH];
				TCHAR szFilter[256];
				OPENFILENAME ofn;

				szFileName[0]='\0';
				LoadFileFilter(IDS_LISTSAVEFILTER,szFilter,numberof(szFilter));
				InitOpenFileNameStruct(&ofn);
				ofn.hwndOwner=hWnd;
				ofn.lpstrFilter=szFilter;
				ofn.nFilterIndex=nListSaveFilterIndex;
				ofn.lpstrFile=szFileName;
				ofn.nMaxFile=numberof(szFileName);
				ofn.lpstrInitialDir=szFileSaveDirectory;
				ofn.Flags=OFN_HIDEREADONLY;
				if (fAskOverWrite)
					ofn.Flags|=OFN_OVERWRITEPROMPT;
				if (GetSaveFileName(&ofn)) {
					HCURSOR hcurOld;
					ErrorType Err;

					GetFileDirectory(szFileSaveDirectory,szFileName);
					nListSaveFilterIndex=ofn.nFilterIndex;
					hcurOld=SetCursor(LoadCursor(NULL,IDC_WAIT));
					if (nListSaveFilterIndex==1)
						Err=SaveHTMLDataList(pCurrentSourceFile,szFileName);
					else if (ofn.nFilterIndex==2)
						Err=SaveCSVDataList(pCurrentSourceFile,szFileName);
					SetCursor(hcurOld);
					if (Err!=ERR_SUCCESS)
						ErrMessageBox(hWnd,Err,MB_OK | MB_ICONEXCLAMATION);
				}
			}
			return 0;

		case CM_BATCH:
			/* ꊇo */
			BatchExtract(hWnd);
			return 0;

		case CM_EXIT:
			/* I */
			SendMessage(hWnd,WM_CLOSE,0,0);
			return 0;

		case CM_COPY:
			/* f[^Rs[ */
			if (pCurrentSourceFile!=NULL
					&& pCurrentSourceFile->DataList[
								pCurrentSourceFile->CurDataType].nSelItem>=0) {
				const DataListItemInfo *pItem=DataList_GetItem(
					&pCurrentSourceFile->DataList[
										pCurrentSourceFile->CurDataType].List,
					pCurrentSourceFile->DataList[
									pCurrentSourceFile->CurDataType].nSelItem);
				ErrorType Err;

				switch (pItem->Data.Format) {
				case FORMAT_DIB:
					Err=DIBCopyToClipboard(hWnd,
						(BYTE*)pCurrentSourceFile->pData+pItem->Data.Address,
						pItem->Data.Size);
					break;
				case FORMAT_JPEG:
					{
						BITMAPINFOHEADER bmih;
						unsigned int InfoBytes,BitsBytes;
						void *pData;
						BYTE *p;

						JPEGGetDIBInfoHeader((BYTE*)pCurrentSourceFile->pData+
								pItem->Data.Address,pItem->Data.Size,&bmih);
						InfoBytes=DIBCalcInfoBytes(&bmih);
						BitsBytes=DIBCalcBitsBytes(&bmih);
						pData=MemAlloc(InfoBytes+BitsBytes);
						if (pData==NULL) {
							Err=ERR_MEMORYALLOC;
							break;
						}
						p=(BYTE*)pData;
						MemCopy(p,&bmih,sizeof(BITMAPINFOHEADER));
						p+=sizeof(BITMAPINFOHEADER);
						if (bmih.biBitCount==8) {
							int i;

							for (i=0;i<256;i++) {
								*p++=i;
								*p++=i;
								*p++=i;
								*p++=0;
							}
						}
						Preview_GetDIBits(hwndPreview,p);
						Err=DIBCopyToClipboard(hWnd,pData,InfoBytes+BitsBytes);
						MemFree(pData);
					}
					break;
				case FORMAT_PNG:
					Err=PNGCopyToClipboard(hWnd,
						(BYTE*)pCurrentSourceFile->pData+pItem->Data.Address,
						pItem->Data.Size);
					break;
				case FORMAT_MAG:
					Err=MAGCopyToClipboard(hWnd,
						(BYTE*)pCurrentSourceFile->pData+pItem->Data.Address,
						pItem->Data.Size);
					break;
				case FORMAT_ICON:
				case FORMAT_CURSOR:
					Err=IconCopyToClipboard(hWnd,
						(BYTE*)pCurrentSourceFile->pData+pItem->Data.Address,
						pItem->Data.Size);
					break;
				case FORMAT_ANI:
					Err=ANICopyToClipboard(hWnd,
						(BYTE*)pCurrentSourceFile->pData+pItem->Data.Address,
						pItem->Data.Size);
					break;
				case FORMAT_WAVE:
					Err=WAVECopyToClipboard(hWnd,
						(BYTE*)pCurrentSourceFile->pData+pItem->Data.Address,
						pItem->Data.Size);
					break;
				default:
					return 0;
				}
				if (Err!=ERR_SUCCESS)
					ErrMessageBox(hWnd,Err,MB_OK | MB_ICONEXCLAMATION);
			}
			return 0;

		case CM_DATAINFO:
			/* f[^̏\ */
			if (pCurrentSourceFile!=NULL
					&& pCurrentSourceFile->DataList[
								pCurrentSourceFile->CurDataType].nSelItem>=0) {
				DataListItemInfo *pItem=DataList_GetItem(
					&pCurrentSourceFile->DataList[
										pCurrentSourceFile->CurDataType].List,
					pCurrentSourceFile->DataList[
									pCurrentSourceFile->CurDataType].nSelItem);
				DataInfoDlgInfo Info;

				if (pItem==NULL)
					return 0;
				Info.pData=(const BYTE*)pCurrentSourceFile->pData;
				Info.Info=pItem->Data;
				switch (GetFormatDataType(pItem->Data.Format)) {
				case DATATYPE_IMAGE:
					DialogBoxParam(hInst,MAKEINTRESOURCE(IDD_IMAGEINFO),hWnd,
											ImageInfoDlgProc,(LPARAM)&Info);
					break;
				case DATATYPE_SOUND:
					DialogBoxParam(hInst,MAKEINTRESOURCE(IDD_SOUNDINFO),hWnd,
											SoundInfoDlgProc,(LPARAM)&Info);
					break;
				case DATATYPE_VIDEO:
					DialogBoxParam(hInst,MAKEINTRESOURCE(IDD_VIDEOINFO),hWnd,
											VideoInfoDlgProc,(LPARAM)&Info);
					break;
				}
			}
			return 0;

		case CM_CHECKALL:
		case CM_UNCHECKALL:
			/* SẴf[^`FbN/`FbN͂ */
			if (pCurrentSourceFile!=NULL) {
				HWND hwndList=hwndDataList[pCurrentSourceFile->CurDataType];
				BOOL fCheck=LOWORD(wParam)==CM_CHECKALL;
				int nItems,i;

				nItems=ListView_GetItemCount(hwndList);
				for (i=0;i<nItems;i++)
					ListView_SetCheckState(hwndList,i,fCheck);
			}
			return 0;

		case CM_INVERTCHECK:
			/* `FbN𔽓] */
			if (pCurrentSourceFile!=NULL) {
				HWND hwndList=hwndDataList[pCurrentSourceFile->CurDataType];
				int nItems,i;

				nItems=ListView_GetItemCount(hwndList);
				for (i=0;i<nItems;i++)
					ListView_SetCheckState(hwndList,i,
										!ListView_GetCheckState(hwndList,i));
			}
			return 0;

		case CM_TOOLBAR:
			/* c[o[̕\/\؂ւ */
			{
				RECT rc;

				fShowToolbar=!fShowToolbar;
				ShowWindow(hwndToolbar,fShowToolbar?SW_SHOW:SW_HIDE);
				CheckMenuItem(GetMenu(hWnd),CM_TOOLBAR,MF_BYCOMMAND |
									(fShowToolbar?MFS_CHECKED:MFS_UNCHECKED));
				GetClientRect(hWnd,&rc);
				SendMessage(hWnd,WM_SIZE,0,MAKELPARAM(rc.right,rc.bottom));
			}
			return 0;

		case CM_STATUSBAR:
			/* Xe[^Xo[̕\/\؂ւ */
			{
				RECT rc;

				fShowStatusBar=!fShowStatusBar;
				ShowWindow(hwndStatusBar,fShowStatusBar?SW_SHOW:SW_HIDE);
				CheckMenuItem(GetMenu(hWnd),CM_STATUSBAR,MF_BYCOMMAND |
								(fShowStatusBar?MFS_CHECKED:MFS_UNCHECKED));
				GetClientRect(hWnd,&rc);
				SendMessage(hWnd,WM_SIZE,0,MAKELPARAM(rc.right,rc.bottom));
			}
			return 0;

		case CM_OPTIONS:
			/* ݒs */
			DialogBox(hInst,MAKEINTRESOURCE(IDD_OPTIONS),hWnd,OptionsDlgProc);
			return 0;

		case CM_HELP:
			/* wv\ */
			if (LoadHtmlHelpLibrary())
				(*pfnHtmlHelp)(NULL,szHelpFileName,HH_DISPLAY_TOC,0);
			return 0;

		case CM_ABOUT:
			/* o[W\ */
			DialogBox(hInst,MAKEINTRESOURCE(IDD_ABOUT),hWnd,AboutDlgProc);
			return 0;
		}
		return 0;

	case WM_CLOSE:
		DestroyWindow(hWnd);
		return 0;

	case WM_DESTROY:
		/* wv */
		if (pfnHtmlHelp!=NULL) {
			(*pfnHtmlHelp)(NULL,NULL,HH_CLOSE_ALL,0);
			(*pfnHtmlHelp)(NULL,NULL,HH_UNINITIALIZE,dwHtmlHelpCookie);
			FreeLibrary(hHtmlHelpLib);
			pfnHtmlHelp=NULL;
		}

		/* EBhEʒuL */
		{
			WINDOWPLACEMENT wp;

			wp.length=sizeof(WINDOWPLACEMENT);
			GetWindowPlacement(hWnd,&wp);
			MainWindowPos.Left=wp.rcNormalPosition.left;
			MainWindowPos.Top=wp.rcNormalPosition.top;
			MainWindowPos.Width=
							wp.rcNormalPosition.right-wp.rcNormalPosition.left;
			MainWindowPos.Height=
							wp.rcNormalPosition.bottom-wp.rcNormalPosition.top;
			MainWindowPos.fMaximized=wp.showCmd==SW_SHOWMAXIMIZED;
		}

		/* ԂL */
		SplitterPos=SplitBar_GetPos(hwndSplitBar);
		{
			int i;

			for (i=0;i<numberof(ImageListColumnWidth);i++)
				ImageListColumnWidth[i]=
					ListView_GetColumnWidth(hwndDataList[DATATYPE_IMAGE],i);
			for (i=0;i<numberof(SoundListColumnWidth);i++)
				SoundListColumnWidth[i]=
					ListView_GetColumnWidth(hwndDataList[DATATYPE_SOUND],i);
			for (i=0;i<numberof(VideoListColumnWidth);i++)
				VideoListColumnWidth[i]=
					ListView_GetColumnWidth(hwndDataList[DATATYPE_VIDEO],i);
		}

		if (pCurrentSourceFile!=NULL)
			CloseSourceFile(&pCurrentSourceFile);

		PostQuitMessage(0);
		return 0;
	}
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}


/*
	Gg|Cg
*/
#ifdef __BORLANDC__
#pragma argsused
#endif
int APIENTRY _tWinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,
												LPTSTR pszCmdLine,int nCmdShow)
{
	MSG msg;

	/*
		ϐ̏
	*/
	hInst=hInstance;
	{
		TCHAR szModuleFileName[MAX_PATH];

		GetModuleFileName(hInst,szModuleFileName,numberof(szModuleFileName));
		lstrcpy(szIniFileName,szModuleFileName);
		lstrcpy(GetFileExtensionPtr(szIniFileName),TEXT(".ini"));
		lstrcpy(szHelpFileName,szModuleFileName);
		lstrcpy(GetFileExtensionPtr(szHelpFileName),TEXT(".chm"));
	}
	{
		TCHAR szPersonalDirectory[MAX_PATH];

		if (!SHGetSpecialFolderPath(NULL,szPersonalDirectory,CSIDL_PERSONAL,
																		FALSE))
			GetCurrentDirectory(numberof(szPersonalDirectory),
														szPersonalDirectory);
		lstrcpy(szFileOpenDirectory,szPersonalDirectory);
		lstrcpy(szFileSaveDirectory,szPersonalDirectory);
		lstrcpy(szBatchOutDirectory,szPersonalDirectory);
	}

	/*
		ݒ̓ǂݍ
	*/
	LoadSettings(szIniFileName);

	/*
		EBhENX̓o^
	*/
	{
		WNDCLASS wc;

		/* CEBhE */
		wc.style=0;
		wc.lpfnWndProc=WndProc;
		wc.cbClsExtra=0;
		wc.cbWndExtra=0;
		wc.hInstance=hInst;
		wc.hIcon=LoadIcon(hInst,MAKEINTRESOURCE(IDI_ICON));
		wc.hCursor=LoadCursor(NULL,IDC_ARROW);
		wc.hbrBackground=(HBRUSH)(COLOR_3DFACE+1);
		wc.lpszMenuName=NULL;
		wc.lpszClassName=MAIN_WINDOW_CLASS;
		if (RegisterClass(&wc)==0) {
			ResMessageBox(NULL,IDS_FAIL_REGISTERCLASS,0,MB_OK | MB_ICONSTOP);
			return FALSE;
		}
		/* f[^XgEBhE */
		wc.style=0;
		wc.lpfnWndProc=DataListFormWndProc;
		wc.cbClsExtra=0;
		wc.cbWndExtra=0;
		wc.hInstance=hInst;
		wc.hIcon=NULL;
		wc.hCursor=LoadCursor(NULL,IDC_ARROW);
		wc.hbrBackground=NULL;//(HBRUSH)(COLOR_3DFACE+1);
		wc.lpszMenuName=NULL;
		wc.lpszClassName=DATALIST_FORM_WINDOW_CLASS;
		if (RegisterClass(&wc)==0) {
			ResMessageBox(NULL,IDS_FAIL_REGISTERCLASS,0,MB_OK | MB_ICONSTOP);
			return FALSE;
		}
	}
	/* vr[EBhE */
	if (!RegisterPreviewWindowClass(hInst)) {
		ResMessageBox(NULL,IDS_FAIL_REGISTERCLASS,0,MB_OK | MB_ICONSTOP);
		return FALSE;
	}
	/* Xvbgo[ */
	if (RegisterSplitBarClass(hInst)==0) {
		ResMessageBox(NULL,IDS_FAIL_REGISTERCLASS,0,MB_OK | MB_ICONSTOP);
		return FALSE;
	}

	/*
		RRg[̏
	*/
#if _WIN32_IE<0x0300
	InitCommonControls();
#else
	{
		INITCOMMONCONTROLSEX icc;

		icc.dwSize=sizeof(INITCOMMONCONTROLSEX);
		icc.dwICC=ICC_LISTVIEW_CLASSES | ICC_BAR_CLASSES | ICC_TAB_CLASSES |
										ICC_UPDOWN_CLASS | ICC_PROGRESS_CLASS;
		InitCommonControlsEx(&icc);
	}
#endif

	/*
		CEBhE̍쐬
	*/
	hwndMain=CreateWindowEx(WS_EX_ACCEPTFILES,MAIN_WINDOW_CLASS,TITLE_TEXT,
		WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
		0,0,640,480,NULL,LoadMenu(hInst,MAKEINTRESOURCE(IDM_MAIN)),hInst,NULL);
	if (hwndMain==NULL) {
		ResMessageBox(NULL,IDS_FAIL_CREATEWINDOW,0,MB_OK | MB_ICONSTOP);
		return FALSE;
	}
	/* ftHgŃfXNgbv̒ɔzu */
	if (MainWindowPos.Left==WINDOWPOS_DEFAULT
			|| MainWindowPos.Top==WINDOWPOS_DEFAULT) {
		RECT rcWork;

		SystemParametersInfo(SPI_GETWORKAREA,0,&rcWork,0);
		if (MainWindowPos.Left==WINDOWPOS_DEFAULT)
			MainWindowPos.Left=rcWork.left+
						((rcWork.right-rcWork.left)-MainWindowPos.Width)/2;
		if (MainWindowPos.Top==WINDOWPOS_DEFAULT)
			MainWindowPos.Top=rcWork.top+
						((rcWork.bottom-rcWork.top)-MainWindowPos.Height)/2;
	}
	/* EBhEʒu𕜌 */
	{
		WINDOWPLACEMENT wp;

		wp.length=sizeof(wp);
		GetWindowPlacement(hwndMain,&wp);
		wp.flags=0;
		wp.showCmd=nCmdShow==SW_SHOWNORMAL && MainWindowPos.fMaximized?
													SW_SHOWMAXIMIZED:nCmdShow;
		wp.rcNormalPosition.left=MainWindowPos.Left;
		wp.rcNormalPosition.top=MainWindowPos.Top;
		wp.rcNormalPosition.right=MainWindowPos.Left+MainWindowPos.Width;
		wp.rcNormalPosition.bottom=MainWindowPos.Top+MainWindowPos.Height;
		SetWindowPlacement(hwndMain,&wp);
	}
	UpdateWindow(hwndMain);

	/*
		j[̐ݒ
	*/
	{
		HMENU hmenu=GetMenu(hwndMain);

		CheckMenuItem(hmenu,CM_TOOLBAR,MF_BYCOMMAND |
									(fShowToolbar?MFS_CHECKED:MFS_UNCHECKED));
		CheckMenuItem(hmenu,CM_STATUSBAR,MF_BYCOMMAND |
								(fShowStatusBar?MFS_CHECKED:MFS_UNCHECKED));
	}

	/*
		ANZ[^̓ǂݍ
	*/
	haccel=LoadAccelerators(hInst,MAKEINTRESOURCE(IDA_ACCELERATORS));
	if (haccel==NULL) {
		ResMessageBox(hwndMain,IDS_FAIL_LOADACCELERATORS,0,MB_OK | MB_ICONSTOP);
		DestroyWindow(hwndMain);
		return FALSE;
	}

	/*
		R}hC̃t@CJ
	*/
	if (pszCmdLine[0]!='\0') {
		LPCTSTR p;
		TCHAR szFileName[MAX_PATH];
		TCHAR Delimiter;
		int i;

		p=pszCmdLine;
		if (*p=='"') {
			p++;
			Delimiter='"';
		} else {
			Delimiter=' ';
		}
		for (i=0;*p!='\0' && *p!=Delimiter && i<MAX_PATH;i++) {
#ifndef UNICODE
			if (IsDBCSLeadByteEx(CP_ACP,*p) && *(p+1)!='\0') {
				if (i+2>=MAX_PATH) {
					i=MAX_PATH;
					break;
				}
				szFileName[i++]=*p++;
			}
#endif
			szFileName[i]=*p++;
		}
		if (i<MAX_PATH) {
			szFileName[i]='\0';
			GetFileDirectory(szFileOpenDirectory,szFileName);
			OpenSourceFile(&pCurrentSourceFile,szFileName);
		}
	}

	/*
		bZ[W[v
	*/
	while (GetMessage(&msg,NULL,0,0)) {
		if (pfnHtmlHelp!=NULL && (*pfnHtmlHelp)(NULL,NULL,
										HH_PRETRANSLATEMESSAGE,(DWORD)&msg))
			continue;
		if (!TranslateAccelerator(hwndMain,haccel,&msg)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	/*
		ݒ̕ۑ
	*/
	SaveSettings(szIniFileName);

	/*
		n
	*/
	if (himlToolbar!=NULL)
		ImageList_Destroy(himlToolbar);
	if (pBatchFileList!=NULL)
		MemFree(pBatchFileList);

	return (int)msg.wParam;
}
