/******************************************************************************
*                                                                             *
*    DataCutter.h                           Copyright(c) 2005-2010 itow,y.    *
*                                                                             *
******************************************************************************/

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef DATA_CUTTER_H
#define DATA_CUTTER_H


#include "Debug.h"
#include "Memory.h"


#define numberof(a) (sizeof(a)/sizeof((a)[0]))


typedef size_t DataSizeType;

/* #define PRINT_SIZE "%zu" */
#ifndef WIN64
#define PRINTF_SIZE	"%lu"
#else
#define PRINTF_SIZE	"%llu"
#endif

typedef enum {
	FORMAT_DIB,
	FORMAT_JPEG,
	FORMAT_PNG,
	FORMAT_MAG,
	FORMAT_ICON,
	FORMAT_CURSOR,
	FORMAT_ANI,
	FORMAT_WAVE,
	FORMAT_MIDI,
	FORMAT_MP3,
	FORMAT_AVI
} FormatType;

typedef enum {
	ERR_SUCCESS,
	ERR_MEMORYALLOC,
	ERR_FILEOPEN,
	ERR_FILECLOSE,
	ERR_FILEREAD,
	ERR_FILEWRITE,
	ERR_LOADSTRING,
	ERR_INTERNAL,
	ERR_OTHER
} ErrorType;


#endif	/* ndef DATA_CUTTER_H */
