/******************************************************************************
*                                                                             *
*    Debug.c                                Copyright(c) 2005-2010 itow,y.    *
*                                                                             *
******************************************************************************/

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <stdio.h>
#include <stdarg.h>
#include <windows.h>
#include "Debug.h"




static void FormatText(LPTSTR pszText,size_t MaxLength,LPCTSTR pszFormat,
																va_list Args)
{
#ifndef UNICODE
	_vsnprintf_s
#else
	_vsnwprintf_s
#endif
		(pszText,MaxLength,_TRUNCATE,pszFormat,Args);
}


void DebugTrace(LPCTSTR pszFormat, ...)
{
	va_list Args;
	TCHAR szText[1024];

	va_start(Args,pszFormat);
	FormatText(szText,1024,pszFormat,Args);
	OutputDebugString(szText);
	va_end(Args);
}


void DebugMessage(LPCTSTR pszFormat, ...)
{
	va_list Args;
	TCHAR szText[256];

	va_start(Args,pszFormat);
	FormatText(szText,256,pszFormat,Args);
	MessageBox(NULL,szText,TEXT("Debug"),MB_OK);
	va_end(Args);
}
