/******************************************************************************
*                                                                             *
*    FileUtil.c                             Copyright(c) 2005-2010 itow,y.    *
*                                                                             *
******************************************************************************/

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <windows.h>
#include <tchar.h>
#include "FileUtil.h"


#ifndef FILE_UTIL_USE_SHLWAPI


/**
* @brief fBNgƃt@C
*
* @param[out] pszFilePath  t@Ci[郁̈ւ̃|C^B
*                          pszDirectoryƓł\ȂB
* @param[in]  pszDirectory fBNgւ̃|C^B
*                          pszFilePathƓł\ȂB
* @param[in]  pszFileName  t@Cւ̃|C^B
*
* @return t@Cւ̃|C^ԂB
*/
LPTSTR MergeFileName(LPTSTR pszFilePath,LPCTSTR pszDirectory,
														LPCTSTR pszFileName)
{
	LPTSTR q;
	LPCTSTR p;

	q=pszFilePath;
	p=pszDirectory;
#ifndef UNICODE
	while (*p!='\0') {
		if (IsDBCSLeadByteEx(CP_ACP,*p) && *(p+1)!='\0') {
			*q++=*p++;
			*q++=*p++;
		} else {
			*q++=*p;
			if (*p=='\\' && *(p+1)=='\0')
				break;
			p++;
		}
		if (*p=='\0') {
			*q++='\\';
			break;
		}
	}
#else
	while (*p!='\0')
		*q++=*p++;
	if (p>pszDirectory && *(p-1)!='\\')
		*q++='\\';
#endif
	p=pszFileName;
	while ((*q++=*p++)!='\0');
	return pszFilePath;
}


/**
* @brief tpXt@C擾
*
* @param[out] pszFileName t@Ci[郁̈ւ̃|C^B
* @param[in]  pszFilePath t@C擾镶ւ̃|C^B
*
* @return 擾t@C̕ւ̃|C^ԂB
*/
LPTSTR GetFileName(LPTSTR pszFileName,LPCTSTR pszFilePath)
{
	lstrcpy(pszFileName,GetFileNamePtr(pszFilePath));
	return pszFileName;
}


/**
* @brief tpXt@Cւ̃|C^擾
*
* @param[in] pszFilePath t@C擾镶ւ̃|C^B
*
* @return t@Cւ̃|C^ԂB
*/
LPTSTR GetFileNamePtr(LPCTSTR pszFilePath)
{
	LPCTSTR p,pszFileName;

	pszFileName=pszFilePath;
	p=pszFilePath;
	while (*p!='\0') {
		if (*p=='\\')
			pszFileName=p+1;
#ifndef UNICODE
		else if (IsDBCSLeadByteEx(CP_ACP,*p) && *(p+1)!='\0')
			p++;
#endif
		p++;
	}
	return (LPTSTR)pszFileName;
}


/**
* @brief t@C̃tpXfBNg擾
*
* @param[out] pszDirectory fBNgi[郁̈ւ̃|C^B
* @param[in]  pszFilePath  fBNg擾t@Cւ̃|C^B
*
* @return fBNgi[obt@ւ̃|C^ԂB
*/
LPTSTR GetFileDirectory(LPTSTR pszDirectory,LPCTSTR pszFilePath)
{
	LPCTSTR p;
	LPTSTR q;
	int i;

	p=pszFilePath;
	q=pszDirectory;
	while (*p!='\0') {
		for (i=0;p[i]!='\\' && p[i]!='\0';i++)
#ifndef UNICODE
			if (IsDBCSLeadByteEx(CP_ACP,p[i]) && p[i+1]!='\0')
				i++
#endif
			;
		if (p[i]=='\0')
			break;
		for (;i>=0;i--)
			*q++=*p++;
	}
	if (q-pszDirectory>3)
		q--;
	*q='\0';
	return pszDirectory;
}


/**
* @brief t@C̊gq擾
*
* @param[in] pszFilePath gq擾t@Cւ̃|C^B
*
* @return t@C̊gqւ̃|C^ԂB
*         gqꍇ͏I[nullւ̃|C^ԂB
*/
LPTSTR GetFileExtensionPtr(LPCTSTR pszFilePath)
{
	LPCTSTR p,pszExtension;

	pszExtension=NULL;
	p=pszFilePath;
	while (*p!='\0') {
		if (*p=='\\')
			pszExtension=NULL;
		else if (*p=='.')
			pszExtension=p;
#ifndef UNICODE
		if (IsDBCSLeadByteEx(CP_ACP,*p) && *(p+1)!='\0')
			p++;
#endif
		p++;
	}
	return (LPTSTR)(pszExtension!=NULL?pszExtension:p);
}


/**
* @brief fBNg̖̃obNXbVB
*        hCũ[g̏ꍇ͏ȂB
*
* @param[in,out] pszDirectory fBNgւ̃|C^B
*
* @return fBNgւ̃|C^ԂB
*/
LPTSTR RemoveDirectoryBackslash(LPTSTR pszDirectory)
{
#ifndef UNICODE
	LPTSTR p;

	p=pszDirectory;
	while (*p!='\0'){
		if (*p=='\\' && *(p+1)=='\0') {
			if (p-pszDirectory>3)
				*p='\0';
			break;
		}
		if (IsDBCSLeadByteEx(CP_ACP,*p) && *(p+1)!='\0')
			p++;
		p++;
	}
#else
	int Length=lstrlen(pszDirectory);

	if (Length>3 && pszDirectory[Length-1]=='\\')
		pszDirectory[Length-1]='\0';
#endif
	return pszDirectory;
}


/**
* @brief t@C݂邩ׂ
*
* @param[in] pszFileName t@C̃pXւ̃|C^B
*
* @retval TRUE  t@C݂B
* @retval FALSE t@C݂ȂB
*/
BOOL FileExists(LPCTSTR pszFileName)
{
	HANDLE hFind;
	WIN32_FIND_DATA wfd;

	hFind=FindFirstFile(pszFileName,&wfd);
	if (hFind==INVALID_HANDLE_VALUE)
		return FALSE;
	FindClose(hFind);
	return (wfd.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)==0;
}


/**
* @brief fBNg݂邩ׂ
*
* @param[in] pszDirectory fBNg̃pXւ̃|C^B
*
* @retval TRUE  fBNg݂B
* @retval FALSE fBNg݂ȂB
*/
BOOL DirectoryExists(LPCTSTR pszDirectory)
{
	HANDLE hFind;
	WIN32_FIND_DATA wfd;

	hFind=FindFirstFile(pszDirectory,&wfd);
	if (hFind==INVALID_HANDLE_VALUE)
		return FALSE;
	FindClose(hFind);
	return (wfd.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)!=0;
}


#else	/* ndef FILE_UTIL_USE_SHLWAPI */


#include <shlwapi.h>

#pragma comment(lib, "shlwapi.lib")


LPTSTR MergeFileName(LPTSTR pszFilePath,LPCTSTR pszDirectory,
														LPCTSTR pszFileName)
{
	return PathCombine(pszFilePath,pszDirectory,pszFileName);
}


LPTSTR GetFileName(LPTSTR pszFileName,LPCTSTR pszFilePath)
{
	lstrcpy(pszFileName,PathFindFileName(pszFilePath));
	return pszFileName;
}


LPTSTR GetFileNamePtr(LPCTSTR pszFilePath)
{
	return PathFindFileName(pszFilePath);
}


LPTSTR GetFileDirectory(LPTSTR pszDirectory,LPCTSTR pszFilePath)
{
	LPTSTR p;

	lstrcpy(pszDirectory,pszFilePath);
	p=PathFindFileName(pszDirectory);
	if (p-pszDirectory>2)
		p--;
	*p='\0';
	return pszDirectory;
}


LPTSTR RemoveDirectoryBackslash(LPTSTR pszDirectory)
{
	return PathRemoveBackslash(pszDirectory);
}


BOOL FileExists(LPCTSTR pszFileName)
{
	return PathFileExists(pszFileName);
}


BOOL DirectoryExists(LPCTSTR pszDirectory)
{
	return PathIsDirectory(pszDirectory);
}


#endif	/* FILE_UTIL_USE_SHLWAPI */
