/******************************************************************************
*                                                                             *
*    Formats.h                              Copyright(c) 2005-2010 itow,y.    *
*                                                                             *
******************************************************************************/

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef DATACUTTER_FORMATS_H
#define DATACUTTER_FORMATS_H


#ifdef __cplusplus
extern "C" {
#endif


typedef struct {
	int nWidth;
	int nHeight;
	int nBitsPerPixel;
} ImageInfo;

typedef struct {
	int nChannels;
	int nBitsPerSample;
	int nSamplesPerSec;
	UINT uLength;
} SoundInfo;

typedef struct {
	int nWidth;
	int nHeight;
	UINT uLength;
} VideoInfo;


#define MSBFirst32(p) \
	(((DWORD)(p)[0]<<24)|((DWORD)(p)[1]<<16)|((DWORD)(p)[2]<<8)|(DWORD)(p)[3])
#define LSBFirst32(p) \
	(((DWORD)(p)[3]<<24)|((DWORD)(p)[2]<<16)|((DWORD)(p)[1]<<8)|(DWORD)(p)[0])


ErrorType DataSaveToFile(LPCTSTR pszFileName,const void *pData,size_t DataSize);
ErrorType RiffSaveToFile(LPCTSTR pszFileName,const void *pData,size_t DataSize);


#include <pshpack1.h>	/* Byte alignment */


/******************************************************************************

	DIB

******************************************************************************/

#define DIB_ROW_BYTES(width,bpp) ((SIZE_T)(((width)*(bpp)+31)/32*4))

ErrorType DIBSaveToFile(LPCTSTR pszFileName,const void *pData,size_t DataSize);
ErrorType DIBCopyToClipboard(HWND hwnd,const void *pData,size_t DataSize);
BOOL DIBDecodeRLE(const BITMAPINFO *pbmi,const void *pSrcBits,size_t SrcSize,
															void *pDstBits);
BOOL DIBDecodeRLE4(const BITMAPINFO *pbmi,const void *pSrcBits,size_t SrcSize,
															void *pDstBits);
BOOL DIBDecodeRLE8(const BITMAPINFO *pbmi,const void *pSrcBits,size_t SrcSize,
															void *pDstBits);
UINT DIBGetInfoBytes(const void *pData);
UINT DIBCalcInfoBytes(const BITMAPINFOHEADER *pbmih);
UINT DIBCalcBitsBytes(const BITMAPINFOHEADER *pbmih);
UINT DIBCalcBytes(const BITMAPINFOHEADER *pbmih);
void DIBGetImageInfo(const void *pData,size_t DataSize,ImageInfo *pInfo);


/******************************************************************************

	JPEG

******************************************************************************/

#define JPEG_MARKER_SOF0	0xC0
#define JPEG_MARKER_SOF1	0xC1
#define JPEG_MARKER_SOF2	0xC2
#define JPEG_MARKER_SOF3	0xC3
#define JPEG_MARKER_SOF5	0xC5
#define JPEG_MARKER_SOF7	0xC7
#define JPEG_MARKER_SOF9	0xC9
#define JPEG_MARKER_SOF11	0xCB
#define JPEG_MARKER_RST0	0xD0
#define JPEG_MARKER_RST7	0xD7
#define JPEG_MARKER_SOI		0xD8
#define JPEG_MARKER_EOI		0xD9
#define JPEG_MARKER_SOS		0xDA
#define JPEG_MARKER_APP0	0xE0

#define JPEGSaveToFile DataSaveToFile
BITMAPINFO *JPEGConvertToDIB(const void *pSrcData,size_t DataSize);
BOOL JPEGGetDIBInfoHeader(const void *pData,size_t DataSize,
													BITMAPINFOHEADER *pbmih);
void JPEGGetImageInfo(const void *pData,size_t DataSize,ImageInfo *pInfo);


/******************************************************************************

	PNG

******************************************************************************/


#define PNGSaveToFile DataSaveToFile
ErrorType PNGCopyToClipboard(HWND hwnd,const void *pData,size_t DataSize);
BITMAPINFO *PNGConvertToDIB(const void *pData,size_t DataSize);
void PNGGetDIBInfoHeader(const void *pData,BITMAPINFOHEADER *pbmih);
void PNGGetImageInfo(const void *pData,size_t DataSize,ImageInfo *pInfo);


/******************************************************************************

	MAG

******************************************************************************/

typedef struct tagMagHeader {
	BYTE	bDummy;
	BYTE	bMachineCode;
	BYTE	bMachineDependentFlag;
	BYTE	bScreenMode;
	WORD	wXStart;
	WORD	wYStart;
	WORD	wXEnd;
	WORD	wYEnd;
	DWORD	dwFlagAOffset;
	DWORD	dwFlagBOffset;
	DWORD	dwFlagBSize;
	DWORD	dwPixelOffset;
	DWORD	dwPixelSize;
} MagHeader;

#define MAG_256COLORS	0x80
#define MAG_DIGITAL		0x04
#define MAG_8COLORS		0x02
#define MAG_200LINE		0x01

ErrorType MAGSaveToFile(LPCTSTR pszFileName,const void *pData,size_t DataSize);
ErrorType MAGCopyToClipboard(HWND hwnd,const void *pData,size_t DataSize);
BITMAPINFO *MAGConvertToDIB(const void *pData,size_t DataSize);
BOOL MAGGetDIBInfoHeader(const void *pData,size_t DataSize,
													BITMAPINFOHEADER *pbmih);
void MAGGetImageInfo(const void *pData,size_t DataSize,ImageInfo *pInfo);


/******************************************************************************

	ICON

******************************************************************************/

typedef struct {
	WORD idReserved;	/* must be 0 */
	WORD idType;		/* 1 */
	WORD idCount;
} ICONDIR;

typedef struct {
	BYTE bWidth;
	BYTE bHeight;
	BYTE bColorCount;
	BYTE bReserved;
	WORD wPlanes;
	WORD wBitCount;
	DWORD dwBytesInRes;
	DWORD dwImageOffset;
} ICONDIRENTRY;

typedef struct {
	WORD cdReserved;	/* must be 0 */
	WORD cdType;		/* 2 */
	WORD cdCount;
} CURSORDIR;

typedef struct {
	BYTE bWidth;
	BYTE bHeight;
	BYTE bColorCount;	/* must be 0 */
	BYTE bReserved;
	WORD wXHotspot;
	WORD wYHotspot;
	DWORD lBytesInRes;
	DWORD dwImageOffset;
} CURSORDIRENTRY;

ErrorType IconSaveToFile(LPCTSTR pszFileName,const void *pData,size_t DataSize);
ErrorType IconCopyToClipboard(HWND hwnd,const void *pData,size_t DataSize);
BITMAPINFO *IconConvertToDIB(const void *pData,COLORREF crBgColor);
BOOL IconGetDIBInfoHeader(const void *pData,size_t DataSize,
													BITMAPINFOHEADER *pbmih);
void IconGetImageInfo(const void *pData,size_t DataSize,ImageInfo *pInfo);


/******************************************************************************

	ANI

******************************************************************************/

typedef struct tagANIHEADER {
	DWORD cbSizeOf;
	DWORD cFrames;
	DWORD cSteps;
	DWORD cx;
	DWORD cy;
	DWORD cBitCount;
	DWORD cPlanes;
	DWORD JifRate;
	DWORD flags;
} ANIHEADER;

#define ANISaveToFile RiffSaveToFile
ErrorType ANICopyToClipboard(HWND hwnd,const void *pData,size_t DataSize);
BITMAPINFO *ANIConvertToDIB(const void *pData,COLORREF crBgColor);
BOOL ANIGetDIBInfoHeader(const void *pData,size_t DataSize,
													BITMAPINFOHEADER *pbmih);
void ANIGetImageInfo(const void *pData,size_t DataSize,ImageInfo *pInfo);


/******************************************************************************

	WAVE

******************************************************************************/

#define WAVESaveToFile RiffSaveToFile
ErrorType WAVECopyToClipboard(HWND hwnd,const void *pData,size_t DataSize);
void WAVEGetSoundInfo(const void *pData,size_t DataSize,SoundInfo *pInfo);


/******************************************************************************

	MIDI

******************************************************************************/

#define MIDISaveToFile DataSaveToFile


/******************************************************************************

	MP3

******************************************************************************/

#define MPEG_VERSION_2_5	0
#define MPEG_VERSION_2		2
#define MPEG_VERSION_1		3

#define MPEG_LAYER_3	1
#define MPEG_LAYER_2	2
#define MPEG_LAYER_1	3

#define MPEG_CHANNEL_STEREO			0
#define MPEG_CHANNEL_JOINTSTEREO	1
#define MPEG_CHANNEL_DUALCHANNEL	2
#define MPEG_CHANNEL_MONO			3

typedef struct {
	BYTE Version;
	BYTE Layer;
	WORD SamplesPerFrame;
	DWORD BitRate;
	WORD Frequency;
	BYTE Padding;
	BYTE ChannelMode;
	WORD FrameSize;
} MP3FrameInfo;

#define MP3SaveToFile DataSaveToFile
void MP3GetSoundInfo(const void *pData,size_t DataSize,SoundInfo *pInfo);
BOOL MP3GetFrameInfo(const void *pData,MP3FrameInfo *pInfo);


/******************************************************************************

	AVI

******************************************************************************/

#define AVISaveToFile RiffSaveToFile
void AVIGetVideoInfo(const void *pData,size_t DataSize,VideoInfo *pInfo);


#include <poppack.h>


#ifdef __cplusplus
}
#endif


#endif	/* ndef DATACUTTER_FORMATS_H */
