/******************************************************************************
*                                                                             *
*    JPEG.c                                 Copyright(c) 2007-2010 itow,y.    *
*                                                                             *
******************************************************************************/

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <windows.h>
#include <stdio.h>		/* for "jpeglib.h" */
#include <setjmp.h>
#include "JPEG.h"
#include "Memory.h"
#include "Libs/libjpeg/jpeglib.h"
#include "Libs/libjpeg/jerror.h"

#pragma comment(lib, "libjpeg.lib")


typedef struct {
	struct jpeg_error_mgr jerr;
	jmp_buf jmpbuf;
} JPEGErrorInfo;

typedef struct {
	struct jpeg_source_mgr src;
	const void *pData;
	size_t DataSize;
	BOOL fStartOfFile;
} JPEGSourceInfo;




/*
	G[֐
*/
static void JPEGErrorExit(j_common_ptr cinfo)
{
	JPEGErrorInfo *pjerrinfo=(JPEGErrorInfo*)cinfo->err;

	(*cinfo->err->output_message)(cinfo);
	longjmp(pjerrinfo->jmpbuf,1);
}


/*
	G[bZ[W֐
*/
#ifdef __BORLANDC__
#pragma argsused
#endif
static void JPEGErrorMessage(j_common_ptr cinfo)
{
/*
	JPEGErrorInfo *pjerrinfo=(JPEGErrorInfo*)cinfo->err;
	char szText[JMSG_LENGTH_MAX];

	(*cinfo->err->format_message)(cinfo,szText);
	MessageBoxA(NULL,szText,NULL,MB_OK);
*/
}


static void JPEGInitSource(j_decompress_ptr cinfo)
{
	JPEGSourceInfo *pInfo=(JPEGSourceInfo*)cinfo->src;

	pInfo->fStartOfFile=TRUE;
}


static boolean JPEGFillInputBuffer(j_decompress_ptr cinfo)
{
	JPEGSourceInfo *pInfo=(JPEGSourceInfo*)cinfo->src;

	if (!pInfo->fStartOfFile)
		ERREXIT(cinfo,JERR_INPUT_EMPTY);
	pInfo->src.next_input_byte=(JOCTET*)pInfo->pData;
	pInfo->src.bytes_in_buffer=pInfo->DataSize;
	pInfo->fStartOfFile=FALSE;
	return TRUE;
}


#ifdef __BORLANDC__
#pragma argsused
#endif
static void JPEGSkipInputData(j_decompress_ptr cinfo,long lBytes)
{
}


#ifdef __BORLANDC__
#pragma argsused
#endif
static void JPEGTermSource(j_decompress_ptr cinfo)
{
}


BOOL JPEGDecode(const void *pData,size_t DataSize,void *pDstBits)
{
	struct jpeg_decompress_struct jdec;
	JPEGErrorInfo jerrinfo;
	JPEGSourceInfo *pSrcInfo;
	unsigned int RowLength,DstRowBytes;
	volatile JSAMPROW pBuff=NULL;
	JSAMPROW pScanlines[4];
	int ScanlineHeight;
	int i,y;

	jdec.err=jpeg_std_error(&jerrinfo.jerr);
	jerrinfo.jerr.error_exit=JPEGErrorExit;
	jerrinfo.jerr.output_message=JPEGErrorMessage;
	if (setjmp(jerrinfo.jmpbuf)) {
		jpeg_destroy_decompress(&jdec);
		if (pBuff!=NULL)
			MemFree(pBuff);
		return FALSE;
	}
	jpeg_create_decompress(&jdec);
	jdec.src=(struct jpeg_source_mgr*)(jdec.mem->alloc_small)(
					(j_common_ptr)&jdec,JPOOL_IMAGE,sizeof(JPEGSourceInfo));
	pSrcInfo=(JPEGSourceInfo*)jdec.src;
	pSrcInfo->pData=pData;
	pSrcInfo->DataSize=DataSize;
	jdec.src->init_source=JPEGInitSource;
	jdec.src->fill_input_buffer=JPEGFillInputBuffer;
	jdec.src->skip_input_data=JPEGSkipInputData;
	jdec.src->resync_to_restart=jpeg_resync_to_restart;
	jdec.src->term_source=JPEGTermSource;
	jdec.src->bytes_in_buffer=0;
	jdec.src->next_input_byte=NULL;
	jpeg_read_header(&jdec,TRUE);
	jpeg_calc_output_dimensions(&jdec);
	jdec.dct_method=JDCT_ISLOW;
	jdec.do_fancy_upsampling=FALSE;
	jdec.quantize_colors=FALSE;
	if (jdec.jpeg_color_space==JCS_GRAYSCALE)
		jdec.out_color_space=JCS_GRAYSCALE;
	else
		jdec.out_color_space=JCS_RGB;
	jpeg_calc_output_dimensions(&jdec);
	jpeg_start_decompress(&jdec);
	RowLength=jdec.output_width*jdec.output_components;
	pBuff=(JSAMPROW)MemAlloc(RowLength*jdec.rec_outbuf_height*sizeof(JSAMPLE));
	if (pBuff==NULL) {
		jpeg_finish_decompress(&jdec);
		jpeg_destroy_decompress(&jdec);
		return FALSE;
	}
	for (i=0;i<jdec.rec_outbuf_height;i++)
		pScanlines[i]=pBuff+i*RowLength;
	DstRowBytes=(jdec.output_width*(jdec.out_color_space==JCS_GRAYSCALE?8:24)+
																	31)/32*4;
	for (y=0;y<(int)jdec.output_height;) {
		ScanlineHeight=min(jdec.rec_outbuf_height,(int)jdec.output_height-y);
		jpeg_read_scanlines(&jdec,pScanlines,ScanlineHeight);
		for (i=0;i<ScanlineHeight;i++,y++) {
			JSAMPROW p;
			BYTE *q;
			int x;

			p=pScanlines[i];
			q=(BYTE*)pDstBits+(jdec.output_height-1-y)*DstRowBytes;
			if (jdec.out_color_space==JCS_RGB) {
				for (x=0;x<(int)jdec.output_width;x++) {
					*q++=p[2];
					*q++=p[1];
					*q++=p[0];
					p+=3;
				}
			} else {
				MemCopy(q,p,jdec.output_width);
			}
		}
	}
	MemFree(pBuff);
	pBuff=NULL;
	jpeg_finish_decompress(&jdec);
	jpeg_destroy_decompress(&jdec);
	return TRUE;
}
