/******************************************************************************
*                                                                             *
*    PNGDecode.c                            Copyright(c) 2007-2010 itow,y.    *
*                                                                             *
******************************************************************************/

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <windows.h>
#include "DataCutter.h"
#include "Memory.h"
#include "Formats.h"
#include "PNGDecode.h"
#include "Libs/libpng/png.h"

#ifdef _DEBUG
#pragma comment(lib, "libpngd.lib")
#else
#pragma comment(lib, "libpng.lib")
#endif
#pragma comment(lib, "zlib.lib")


typedef struct {
	const BYTE *pData;
	size_t Size;
	size_t Pos;
} PNGDataSource;




/*
	JX^t@C[h֐
*/
static void ReadData(png_structp pPNG,png_bytep pData,png_size_t Length)
{
	PNGDataSource *pSource=(PNGDataSource*)png_get_io_ptr(pPNG);

	if (pSource->Size-pSource->Pos<Length)
		png_error(pPNG,"Read Error");
	MemCopy(pData,pSource->pData+pSource->Pos,Length);
	pSource->Pos+=Length;
}


/*
	PNG摜fR[h
*/
BOOL PNGDecode(const void *pData,size_t DataSize,
											BITMAPINFO *pbmi,void *pDstBits)
{
	PNGDataSource Source;
	png_structp pPNG;
	png_infop pPNGInfo,pEndInfo;
	png_uint_32 Width,Height;
	int BitDepth,ColorType,InterlaceType;
	int BitsPerPixel;
	int DstRowBytes;
	int Passes;
	BYTE *pScanline=NULL,/**p,*/*q;
	int i,x,y;

	Source.pData=(const BYTE*)pData;
	Source.Size=DataSize;
	Source.Pos=0;
	pPNG=png_create_read_struct(PNG_LIBPNG_VER_STRING,NULL,NULL,NULL);
	if (pPNG==NULL)
		return FALSE;
	pPNGInfo=png_create_info_struct(pPNG);
	if (pPNGInfo==NULL) {
		png_destroy_read_struct(&pPNG,NULL,NULL);
		return FALSE;
	}
	pEndInfo=png_create_info_struct(pPNG);
	if (pEndInfo==NULL) {
		png_destroy_read_struct(&pPNG,&pPNGInfo,NULL);
		return FALSE;
	}
	if (setjmp(pPNG->jmpbuf)) {
		png_destroy_read_struct(&pPNG,&pPNGInfo,&pEndInfo);
		if (pScanline!=NULL)
			MemFree(pScanline);
		return FALSE;
	}
	png_set_read_fn(pPNG,&Source,ReadData);
	png_read_info(pPNG,pPNGInfo);
	png_get_IHDR(pPNG,pPNGInfo,&Width,&Height,&BitDepth,&ColorType,
													&InterlaceType,NULL,NULL);
	if (ColorType==PNG_COLOR_TYPE_GRAY || ColorType==PNG_COLOR_TYPE_PALETTE)
		BitsPerPixel=BitDepth==1?1:BitDepth<=4?4:8;
	else if (ColorType==PNG_COLOR_TYPE_RGB)
		BitsPerPixel=24;
	else /*if (ColorType==PNG_COLOR_TYPE_GRAY_ALPHA
									|| ColorType==PNG_COLOR_TYPE_RGB_ALPHA)*/
		BitsPerPixel=32;
	/* pbg̐ݒ */
	if (BitsPerPixel<=8) {
		switch (ColorType) {
		case PNG_COLOR_TYPE_GRAY:
			{
				int Max=BitDepth<8?(1<<BitDepth)-1:255;
				BYTE Value;

				for (i=0;i<=Max;i++) {
					Value=i*255/Max;
					pbmi->bmiColors[i].rgbBlue=Value;
					pbmi->bmiColors[i].rgbGreen=Value;
					pbmi->bmiColors[i].rgbRed=Value;
					pbmi->bmiColors[i].rgbReserved=0;
				}
			}
			break;
		case PNG_COLOR_TYPE_PALETTE:
			{
				png_colorp pPalette;
				int NumPalette;

				png_get_PLTE(pPNG,pPNGInfo,&pPalette,&NumPalette);
				for (i=0;i<NumPalette;i++) {
					pbmi->bmiColors[i].rgbBlue=pPalette[i].blue;
					pbmi->bmiColors[i].rgbGreen=pPalette[i].green;
					pbmi->bmiColors[i].rgbRed=pPalette[i].red;
					pbmi->bmiColors[i].rgbReserved=0;
				}
			}
			break;
		}
	}
	/* 摜̓WJ */
	DstRowBytes=DIB_ROW_BYTES(Width,BitsPerPixel);
	if (InterlaceType!=PNG_INTERLACE_NONE)
		Passes=png_set_interlace_handling(pPNG);
	else
		Passes=1;
	if (ColorType==PNG_COLOR_TYPE_RGB || ColorType==PNG_COLOR_TYPE_RGB_ALPHA) {
		png_set_bgr(pPNG);
	} else if (ColorType==PNG_COLOR_TYPE_GRAY_ALPHA) {
		png_set_gray_to_rgb(pPNG);
		png_set_bgr(pPNG);
	}
	if (BitDepth==16)
		png_set_strip_16(pPNG);
	if (/*ColorType==PNG_COLOR_TYPE_GRAY_ALPHA || */BitDepth==2) {
		pScanline=(BYTE*)MemAlloc(png_get_rowbytes(pPNG,pPNGInfo));
		if (pScanline==NULL) {
			png_destroy_read_struct(&pPNG,&pPNGInfo,&pEndInfo);
			return FALSE;
		}
	}
	for (i=0;i<Passes;i++) {
		for (y=0;y<(int)Height;y++) {
			q=(BYTE*)pDstBits+(Height-1-y)*DstRowBytes;
			if (pScanline!=NULL) {
				png_read_rows(pPNG,&pScanline,NULL,1);
				//p=pScanline;
				switch (ColorType) {
				case PNG_COLOR_TYPE_GRAY:
				case PNG_COLOR_TYPE_PALETTE:
					/* 2 bits to 4 bits */
					ZeroMemory(q,DstRowBytes);
					for (x=0;x<(int)Width;x++)
						q[x/2]|=((pScanline[x/4]<<((x&3)*2))&0xC0)>>
																((x&1)*4+2);
					break;
				}
			} else {
				png_read_rows(pPNG,&q,NULL,1);
			}
		}
	}
	if (pScanline!=NULL)
		MemFree(pScanline);
	png_read_end(pPNG,pEndInfo);
	png_destroy_read_struct(&pPNG,&pPNGInfo,&pEndInfo);
	return TRUE;
}
