/******************************************************************************
*                                                                             *
*    Preview.h                              Copyright(c) 2005-2010 itow,y.    *
*                                                                             *
******************************************************************************/

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef PREVIEW_H
#define PREVIEW_H


#ifdef __cplusplus
extern "C" {
#endif


#define PREVIEW_WINDOW_CLASS TEXT("DataCutter Preview")

BOOL RegisterPreviewWindowClass(HINSTANCE hinst);

#define PVM_SETDIB				(WM_USER+1)
#define Preview_SetDIB(hwnd,pData,DataSize) \
	((BOOL)SendMessage(hwnd,PVM_SETDIB,DataSize,(LPARAM)(const void*)(pData)))
#define PVM_SETWAVE				(WM_USER+2)
#define Preview_SetWave(hwnd,pData,DataSize) \
	((BOOL)SendMessage(hwnd,PVM_SETWAVE,DataSize,(LPARAM)(const void*)(pData)))
#define PVM_SETMIDI				(WM_USER+3)
#define Preview_SetMidi(hwnd,pData,DataSize) \
	((BOOL)SendMessage(hwnd,PVM_SETMIDI,DataSize,(LPARAM)(const void*)(pData)))
#define PVM_SETMP3				(WM_USER+4)
#define Preview_SetMP3(hwnd,pData,DataSize) \
	((BOOL)SendMessage(hwnd,PVM_SETMP3,DataSize,(LPARAM)(const void*)(pData)))
#define PVM_SETAVI				(WM_USER+5)
#define Preview_SetAVI(hwnd,pData,DataSize) \
	((BOOL)SendMessage(hwnd,PVM_SETAVI,DataSize,(LPARAM)(const void*)(pData)))
#define PVM_FITIMAGETOWINDOW	(WM_USER+6)
#define Preview_FitImageToWindow(hwnd,fFit) \
	((BOOL)SendMessage(hwnd,PVM_FITIMAGETOWINDOW,(BOOL)(fFit),0))
#define PVM_RESET				(WM_USER+7)
#define Preview_Reset(hwnd) ((void)SendMessage(hwnd,PVM_RESET,0,0))
#define PVM_SHOWTIPHELP			(WM_USER+8)
#define Preview_ShowTipHelp(hwnd,fShow) \
	((BOOL)SendMessage(hwnd,PVM_SHOWTIPHELP,(BOOL)(fShow),0))
#define PVM_GETDIBITS			(WM_USER+9)
#define Preview_GetDIBits(hwnd,pBits) \
	((BOOL)SendMessage(hwnd,PVM_GETDIBITS,0,(LPARAM)(pBits)))

#define PVN_RBUTTONDOWN	1


#ifdef __cplusplus
}
#endif


#endif	/* ndef PREVIEW_H */
