/******************************************************************************
*                                                                             *
*    SplitBar.c                             Copyright(c) 2005-2010 itow,y.    *
*                                                                             *
******************************************************************************/

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <windows.h>
#include "SplitBar.h"


/*
	Xvbgo[̏
*/
typedef struct tagSplitBarInfo {
	DWORD dwStyle;		/* X^C */
	int nBarWidth;		/* o[̕ */
	int nBarPos;		/* o[̈ʒu */
	struct {
		HWND hwnd;		/* qEBhẼnh */
		BOOL fShow;		/* qEBhẺEs */
		int nMinSize;	/* ŏ̕ */
	} child[2];
} SplitBarInfo;

#define GetSplitBarInfo(hwnd) ((SplitBarInfo*)GetWindowLongPtr(hwnd,0))


/*
	Xvbgo[̐ݒs
*/
static void SetSplitBar(HWND hwnd)
{
	SplitBarInfo *psbi=(SplitBarInfo*)GetWindowLong(hwnd,0);
	RECT rc;
	int nBarPos;

	GetClientRect(hwnd,&rc);
	if (psbi->child[0].hwnd==NULL || !psbi->child[0].fShow
			|| psbi->child[1].hwnd==NULL || !psbi->child[1].fShow) {
		if (psbi->child[0].hwnd!=NULL && psbi->child[0].fShow)
			MoveWindow(psbi->child[0].hwnd,0,0,rc.right,rc.bottom,TRUE);
		else if (psbi->child[1].hwnd!=NULL && psbi->child[1].fShow)
			MoveWindow(psbi->child[1].hwnd,0,0,rc.right,rc.bottom,TRUE);
		return;
	}
	nBarPos=psbi->nBarPos;
	if ((psbi->dwStyle&SPLBS_HORZ)!=0) {
		if (rc.bottom-nBarPos-psbi->nBarWidth<psbi->child[1].nMinSize)
			nBarPos=rc.bottom-psbi->nBarWidth-psbi->child[1].nMinSize;
		if (nBarPos<psbi->child[0].nMinSize)
			nBarPos=psbi->child[0].nMinSize;
		MoveWindow(psbi->child[0].hwnd,0,0,rc.right,nBarPos,TRUE);
		MoveWindow(psbi->child[1].hwnd,0,nBarPos+psbi->nBarWidth,
							rc.right,rc.bottom-nBarPos-psbi->nBarWidth,TRUE);
	} else {
		if (rc.right-nBarPos-psbi->nBarWidth<psbi->child[1].nMinSize)
			nBarPos=rc.right-psbi->nBarWidth-psbi->child[1].nMinSize;
		if (nBarPos<psbi->child[0].nMinSize)
			nBarPos=psbi->child[0].nMinSize;
		MoveWindow(psbi->child[0].hwnd,0,0,nBarPos,rc.bottom,TRUE);
		MoveWindow(psbi->child[1].hwnd,nBarPos+psbi->nBarWidth,0,
							rc.right-nBarPos-psbi->nBarWidth,rc.bottom,TRUE);
	}
}


/*
	EBhEvV[W
*/
static LRESULT CALLBACK SplitBarWndProc(HWND hWnd,UINT uMsg,WPARAM wParam,
																LPARAM lParam)
{
	switch (uMsg){
	case WM_CREATE:
		{
			SplitBarInfo *psbi;
			RECT rc;

			psbi=(SplitBarInfo*)GlobalAlloc(GMEM_FIXED,sizeof(SplitBarInfo));
			if (psbi==NULL)
				return -1;
			psbi->dwStyle=((CREATESTRUCT*)lParam)->style;
			psbi->nBarWidth=4;
			GetClientRect(hWnd,&rc);
			if ((psbi->dwStyle&SPLBS_HORZ)!=0)
				psbi->nBarPos=(rc.bottom-psbi->nBarWidth)/2;
			else
				psbi->nBarPos=(rc.right-psbi->nBarWidth)/2;
			psbi->child[0].hwnd=NULL;
			psbi->child[0].fShow=FALSE;
			psbi->child[0].nMinSize=0;
			psbi->child[1].hwnd=NULL;
			psbi->child[1].fShow=FALSE;
			psbi->child[1].nMinSize=0;
			SetWindowLongPtr(hWnd,0,(LONG_PTR)psbi);
		}
		return 0;

	case WM_SIZE:
		SetSplitBar(hWnd);
		return 0;

	case WM_LBUTTONDOWN:
		{
			SplitBarInfo *psbi=GetSplitBarInfo(hWnd);

			if ((psbi->dwStyle&SPLBS_FIXED)==0
					&& ((psbi->child[0].hwnd!=NULL && psbi->child[0].fShow)
					|| (psbi->child[1].hwnd!=NULL && psbi->child[1].fShow)))
				SetCapture(hWnd);
		}
		return 0;

	case WM_LBUTTONUP:
		if (GetCapture()==hWnd)
			ReleaseCapture();
		return 0;

	case WM_MOUSEMOVE:
		{
			SplitBarInfo *psbi=GetSplitBarInfo(hWnd);
			LPCTSTR pszCursor;

			if ((psbi->dwStyle&SPLBS_FIXED)==0
						&& psbi->child[0].hwnd!=NULL && psbi->child[0].fShow
						&& psbi->child[1].hwnd!=NULL && psbi->child[1].fShow)
				pszCursor=(psbi->dwStyle&SPLBS_HORZ)!=0?IDC_SIZENS:IDC_SIZEWE;
			else
				pszCursor=IDC_ARROW;
			SetCursor(LoadCursor(NULL,pszCursor));
			if (GetCapture()==hWnd){
				psbi->nBarPos=((psbi->dwStyle&SPLBS_HORZ)!=0?
							(SHORT)HIWORD(lParam):(SHORT)LOWORD(lParam))-
															psbi->nBarWidth/2;
				SetSplitBar(hWnd);
			}
		}
		return 0;

	case WM_COMMAND:
	case WM_NOTIFY:
		return SendMessage(GetParent(hWnd),uMsg,wParam,lParam);

	case WM_DESTROY:
		GlobalFree(GetSplitBarInfo(hWnd));
		SetWindowLongPtr(hWnd,0,(LONG_PTR)(SplitBarInfo*)NULL);
		return 0;

	case SPLBM_SETPOS:
		/* o[̈ʒuݒ肷 */
		{
			SplitBarInfo *psbi=GetSplitBarInfo(hWnd);

			psbi->nBarPos=(int)lParam;
			SetSplitBar(hWnd);
		}
		return TRUE;

	case SPLBM_GETPOS:
		/* o[̈ʒu擾 */
		return GetSplitBarInfo(hWnd)->nBarPos;

	case SPLBM_SETCHILD:
		/* qEBhEݒ肷 */
		if (wParam<=1){
			SplitBarInfo *psbi=GetSplitBarInfo(hWnd);
			HWND hwndChild=(HWND)lParam;

			if (psbi->child[wParam].hwnd!=hwndChild) {
				psbi->child[wParam].hwnd=hwndChild;
				psbi->child[wParam].fShow=hwndChild!=NULL;
				if (hwndChild!=NULL && GetParent(hwndChild)!=hWnd)
					SetParent(hwndChild,hWnd);
				SetSplitBar(hWnd);
			}
			return TRUE;
		}
		return FALSE;

	case SPLBM_GETCHILD:
		/* qEBhE擾 */
		if (wParam<=1) {
			SplitBarInfo *psbi=GetSplitBarInfo(hWnd);

			return (LRESULT)psbi->child[wParam].hwnd;
		}
		return (LRESULT)(HWND)NULL;

	case SPLBM_SHOWCHILD:
		/* qEBhẺEsݒ肷 */
		if (wParam<=1) {
			SplitBarInfo *psbi=GetSplitBarInfo(hWnd);

			if (psbi->child[wParam].hwnd!=NULL) {
				BOOL fShow=lParam!=0;

				if (psbi->child[wParam].fShow!=fShow) {
					psbi->child[wParam].fShow=fShow;
					ShowWindow(psbi->child[wParam].hwnd,fShow?SW_SHOW:SW_HIDE);
					SetSplitBar(hWnd);
				}
				return TRUE;
			}
		}
		return FALSE;

	case SPLBM_SETMINSIZE:
		/* qEBhE̍ŏTCYݒ肷 */
		if (wParam<=1){
			SplitBarInfo *psbi=GetSplitBarInfo(hWnd);

			psbi->child[wParam].nMinSize=max((int)lParam,0);
			if (wParam==0) {
			 	if (psbi->nBarPos<psbi->child[0].nMinSize)
					SetSplitBar(hWnd);
			} else {
				RECT rc;

				GetClientRect(hWnd,&rc);
				if (((psbi->dwStyle&SPLBS_HORZ)!=0?rc.bottom:rc.right)-
						psbi->nBarPos-psbi->nBarWidth<psbi->child[1].nMinSize)
					SetSplitBar(hWnd);
			}
			return TRUE;
		}
		return FALSE;

	case SPLBM_SETDIRECTION:
		/* o[̕ݒ肷 */
		{
			SplitBarInfo *psbi=GetSplitBarInfo(hWnd);

			if ((lParam==0 && (psbi->dwStyle&SPLBS_HORZ)!=0)
					|| ((lParam&SPLBS_HORZ)!=0
										&& (psbi->dwStyle&SPLBS_HORZ)==0)) {
				psbi->dwStyle^=SPLBS_HORZ;
				SetSplitBar(hWnd);
			}
		}
		return 0;
	}
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}


/*
	Xvbgo[̃NXo^
*/
ATOM RegisterSplitBarClass(HINSTANCE hinst)
{
	WNDCLASS wc;

	wc.style=0;
	wc.lpfnWndProc=SplitBarWndProc;
	wc.cbClsExtra=0;
	wc.cbWndExtra=sizeof(SplitBarInfo*);
	wc.hInstance=hinst;
	wc.hIcon=NULL;
	wc.hCursor=NULL;
	wc.hbrBackground=(HBRUSH)(COLOR_3DFACE+1);
	wc.lpszMenuName=NULL;
	wc.lpszClassName=SPLITBAR_CLASS;
	return RegisterClass(&wc);
}
