/******************************************************************************
*                                                                             *
*    SplitBar.h                             Copyright(c) 2005-2010 itow,y.    *
*                                                                             *
******************************************************************************/

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef SPLIT_BAR_H
#define SPLIT_BAR_H


#ifdef __cplusplus
extern "C"{
#endif


#define SPLITBAR_CLASSA "SplitBarClass"
#define SPLITBAR_CLASSW L"SplitBarClass"

#ifdef UNICODE
#define SPLITBAR_CLASS SPLITBAR_CLASSW
#else
#define SPLITBAR_CLASS SPLITBAR_CLASSA
#endif

#define SPLBS_VERT	0x0000
#define SPLBS_HORZ	0x0001
#define SPLBS_FIXED	0x0002


ATOM RegisterSplitBarClass(HINSTANCE hinst);


#define SPLBM_SETPOS		(WM_USER+1)
#define SPLBM_GETPOS		(WM_USER+2)
#define SPLBM_SETCHILD		(WM_USER+3)
#define SPLBM_GETCHILD		(WM_USER+4)
#define SPLBM_SHOWCHILD		(WM_USER+5)
#define SPLBM_SETMINSIZE	(WM_USER+6)
#define SPLBM_SETDIRECTION	(WM_USER+7)

#define SplitBar_SetPos(hwnd,nPos)	\
	((BOOL)SendMessage(hwnd,SPLBM_SETPOS,0,(LPARAM)(nPos)))
#define SplitBar_GetPos(hwnd) ((int)SendMessage(hwnd,SPLBM_GETPOS,0,0))
#define SplitBar_SetChild(hwnd,nChild,hwndChild)	\
	((BOOL)SendMessage(hwnd,SPLBM_SETCHILD,nChild,(LPARAM)(hwndChild)))
#define SplitBar_GetChild(hwnd,nChild)	\
	((HWND)SendMessage(hwnd,SPLBM_GETCHILD,nChild,0))
#define SplitBar_ShowChild(hwnd,nChild,fShow)	\
	((BOOL)SendMessage(hwnd,SPLBM_SHOWCHILD,nChild,(LPARAM)(fShow)))
#define SplitBar_SetMinSize(hwnd,nChild,nSize)	\
	((BOOL)SendMessage(hwnd,SPLBM_SETMINSIZE,nChild,nSize))
#define SplitBar_SetDirection(hwnd,dwDirection)	\
	((void)SendMessage(hwnd,SPLBM_SETDIRECTION,0,dwDirection))


#ifdef __cplusplus
}
#endif


#endif	/* ndef SPLIT_BAR_H */
