# 画像を描画するサンプル
# グラデーション画像を作成する
#
# ここでは例として Image.set_pixel を使って描画しているがかなり遅いため、
# 実際にこのような画像を作成する処理には NumPy や Pilow などを活用した方がよい。

import PictureFan as PF

# 作成する画像の大きさ
WIDTH  = 200
HEIGHT = 200

# 画像を作成する
img = PF.Image()
img.create(WIDTH, HEIGHT, PF.Colorspace.RGB, 8, 3)

app = PF.Application()
window = app.get_main_window()
color = PF.Color()

for y in range(HEIGHT):
    for x in range(WIDTH):
        color.set_rgb(x * 255 // (WIDTH - 1), (WIDTH - 1 - x) * 255 // (WIDTH - 1), y * 255 // (HEIGHT - 1))
        img.set_pixel(x, y, color)
    app.set_progress(y, HEIGHT - 1)

# 画像を開く
window.open_image(img, "Gradient")
