# NumPy を利用するサンプル

import PictureFan as PF
import numpy as np

app = PF.Application()

# 現在の画像を取得する
img = app.get_current_image()

# 画像から RGB の Matrix を取得する
mat = img.to_matrix_rgb()

# Matrix を NumPy の ndarray に変換する
ar = np.array(mat)

# NumPy で処理を行う(ここでは例としてデータを反転している)
neg_ar = ((1 << img.bits_per_plane) - 1) - ar

# ndarray を Matrix に変換する
mat = PF.Matrix(neg_ar)

# Matrix を画像に変換する
img.from_matrix(mat)

# 現在の画像に設定する
app.set_current_image(img, "Negative")
