/******************************************************************************
*                                                                             *
*    VeoChecker.c                                Copyright(c) 2008 itow,y.    *
*                                                                             *
******************************************************************************/


#include <stdlib.h>
#include <windows.h>
#include <commctrl.h>
#include <tchar.h>
#include <shlwapi.h>
#include "resource.h"


/* t@Cǂݍ݃obt@̑傫 */
#define BUFFER_SIZE (1024*64)
/* 0AĂꍇɃG[ɂftHg */
#define DEFAULT_ERROR_LENGTH (1024*8)


HINSTANCE hInst;
HWND hwndMain;
int WindowLeft=0;
int WindowTop=0;
int ErrorLength=DEFAULT_ERROR_LENGTH;
BOOL fSkipJunk=TRUE;
BOOL fAbort;




void ReadSettings(LPCTSTR pszFileName)
{
	WindowLeft=GetPrivateProfileInt(TEXT("Settings"),TEXT("WindowLeft"),
													WindowLeft,pszFileName);
	WindowTop=GetPrivateProfileInt(TEXT("Settings"),TEXT("WindowTop"),
													WindowTop,pszFileName);
	ErrorLength=GetPrivateProfileInt(TEXT("Settings"),TEXT("ErrorLength"),
													ErrorLength,pszFileName);
	if (ErrorLength<=0)
		ErrorLength=DEFAULT_ERROR_LENGTH;
	fSkipJunk=GetPrivateProfileInt(TEXT("Settings"),TEXT("SkipJunk"),
													fSkipJunk,pszFileName)!=0;
}


BOOL WritePrivateProfileInt(LPCTSTR pszAppName,LPCTSTR pszKeyName,int Value,
														LPCTSTR pszFileName)
{
	TCHAR szValue[16];

	wsprintf(szValue,TEXT("%d"),Value);
	return WritePrivateProfileString(pszAppName,pszKeyName,szValue,pszFileName);
}


void WriteSettings(LPCTSTR pszFileName)
{
	WritePrivateProfileInt(TEXT("Settings"),TEXT("WindowLeft"),WindowLeft,
																pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("WindowTop"),WindowTop,
																pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("ErrorLength"),ErrorLength,
																pszFileName);
	WritePrivateProfileInt(TEXT("Settings"),TEXT("SkipJunk"),fSkipJunk,
																pszFileName);
}


BOOL DoMessageLoop(void)
{
	MSG msg;

	while (PeekMessage(&msg,hwndMain,0,0,PM_REMOVE)) {
		if (!IsDialogMessage(hwndMain,&msg)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	return !fAbort;
}


LPTSTR FormatAddress(LPTSTR pszText,ULONGLONG Address)
{

	if (Address>>32!=0)
		wsprintf(pszText,TEXT("%08X%08X"),(DWORD)(Address>>32),(DWORD)Address);
	else
		wsprintf(pszText,TEXT("%08X"),(DWORD)Address);
	return pszText;
}


/*
	j`FbN
*/
BOOL CheckFile(LPCTSTR pszFileName)
{
	HANDLE hFile;
	ULARGE_INTEGER FileSize;
	SIZE_T BufferSize;
	void *pBuffer;
	ULONGLONG CurAddress;
	int ZeroCount;
	BOOL fAVI=FALSE;
	int JunkCount;
	DWORD JunkSize;

	hFile=CreateFile(pszFileName,GENERIC_READ,FILE_SHARE_READ,NULL,
									OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (hFile==INVALID_HANDLE_VALUE) {
		MessageBox(hwndMain,TEXT("t@CJ܂B"),NULL,
												MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	FileSize.u.LowPart=GetFileSize(hFile,&FileSize.u.HighPart);
	if (FileSize.u.HighPart==0 && FileSize.u.LowPart==0) {
		CloseHandle(hFile);
		return TRUE;
	}
	if (FileSize.u.HighPart==0 && FileSize.u.LowPart<BUFFER_SIZE)
		BufferSize=FileSize.u.LowPart;
	else
		BufferSize=BUFFER_SIZE;
	pBuffer=malloc(BufferSize);
	if (pBuffer==NULL) {
		CloseHandle(hFile);
		MessageBox(hwndMain,TEXT("mۂł܂B"),NULL,
												MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	CurAddress=0;
	ZeroCount=0;
	if (fSkipJunk) {
		JunkCount=0;
		JunkSize=0;
	}
	do {
		DWORD Size,Read;
		BYTE *p,*pEnd;

		if (FileSize.u.HighPart>0)
			Size=BufferSize;
		else
			Size=min(BufferSize,FileSize.u.LowPart);
		if (!ReadFile(hFile,pBuffer,Size,&Read,NULL) || Read!=Size) {
			MessageBox(hwndMain,TEXT("t@Cǂݍ߂܂B"),NULL,
												MB_OK | MB_ICONEXCLAMATION);
			break;
		}
		p=(BYTE*)pBuffer;
		pEnd=p+Size;
		if (CurAddress==0 && Size>=4 && memcmp(p,"RIFF",4)==0)
			fAVI=TRUE;
		if (!fSkipJunk || !fAVI) {
			do {
				if (*p++==0) {
					ZeroCount++;
					if (ZeroCount==ErrorLength)
						break;
				} else
					ZeroCount=0;
			} while (p<pEnd);
		} else {
			BYTE b;

			do {
				b=*p++;
				if (JunkCount>0) {
					switch (JunkCount) {
					case 1:
						if (b=='U')
							JunkCount++;
						else
							JunkCount=0;
						break;
					case 2:
						if (b=='N')
							JunkCount++;
						else
							JunkCount=0;
						break;
					case 3:
						if (b=='K')
							JunkCount++;
						else
							JunkCount=0;
						break;
					default:
						JunkSize=(JunkSize>>8)|((DWORD)b<<24);
						if (JunkCount<7) {
							JunkCount++;
						} else {
							if ((ULONGLONG)JunkSize>FileSize.QuadPart)
								JunkSize=0;
							JunkCount=0;
							ZeroCount=0;
							continue;
						}
					}
				}
				if (JunkCount==0) {
					if (JunkSize==0) {
						if (b==0) {
							ZeroCount++;
							if (ZeroCount==ErrorLength)
								break;
						} else {
							ZeroCount=0;
							if (b=='J')
								JunkCount=1;
						}
					} else
						JunkSize--;
				}
			} while (p<pEnd);
		}
		CurAddress+=p-(BYTE*)pBuffer;
		if (ZeroCount==ErrorLength) {
			TCHAR szMessage[256],szAddress[17];

			FormatAddress(szAddress,CurAddress-ZeroCount);
			wsprintf(szMessage,
				TEXT("t@CjĂ\܂B\nAddress : %s"),
																	szAddress);
			MessageBox(hwndMain,szMessage,TEXT("jo"),
												MB_OK | MB_ICONEXCLAMATION);
			break;
		}
		FileSize.QuadPart-=Size;
		if (!DoMessageLoop())
			break;
	} while (FileSize.QuadPart>0);
	free(pBuffer);
	CloseHandle(hFile);
	return FileSize.QuadPart==0;
}


/*
	C
*/
BOOL Recovery(LPCTSTR pszFixedFileName,LPCTSTR pszFileName1,LPCTSTR pszFileName2)
{
	HANDLE hFile1,hFile2,hFixedFile;
	ULARGE_INTEGER FileSize1,FileSize2;
	SIZE_T BufferSize;
	BYTE *pBuffer;
	ULONGLONG CurAddress;
	int ZeroCount;
	BOOL fErrorContinue=FALSE;

	hFile1=CreateFile(pszFileName1,GENERIC_READ,FILE_SHARE_READ,NULL,
									OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (hFile1==INVALID_HANDLE_VALUE) {
		MessageBox(hwndMain,TEXT("Ct@CJ܂B"),NULL,
												MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	hFile2=CreateFile(pszFileName2,GENERIC_READ,FILE_SHARE_READ,NULL,
									OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (hFile2==INVALID_HANDLE_VALUE) {
		CloseHandle(hFile1);
		MessageBox(hwndMain,TEXT("Cp̃t@CJ܂B"),NULL,
												MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	FileSize1.u.LowPart=GetFileSize(hFile1,&FileSize1.u.HighPart);
	FileSize2.u.LowPart=GetFileSize(hFile2,&FileSize2.u.HighPart);
	if (FileSize1.u.LowPart!=FileSize2.u.LowPart
			|| FileSize1.u.HighPart!=FileSize2.u.HighPart) {
		CloseHandle(hFile2);
		CloseHandle(hFile1);
		MessageBox(hwndMain,TEXT("t@CTCYv܂B"),NULL,
												MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	hFixedFile=CreateFile(pszFixedFileName,GENERIC_READ | GENERIC_WRITE,0,NULL,
									CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (hFixedFile==INVALID_HANDLE_VALUE) {
		CloseHandle(hFile2);
		CloseHandle(hFile1);
		MessageBox(hwndMain,TEXT("ݐt@CJ܂B"),NULL,
												MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	if (FileSize1.u.HighPart==0 && FileSize1.u.LowPart<BUFFER_SIZE)
		BufferSize=FileSize1.u.LowPart;
	else
		BufferSize=BUFFER_SIZE;
	pBuffer=(BYTE*)malloc(BufferSize*2);
	if (pBuffer==NULL) {
		CloseHandle(hFixedFile);
		CloseHandle(hFile2);
		CloseHandle(hFile1);
		MessageBox(hwndMain,TEXT("mۂł܂B"),NULL,
												MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	CurAddress=0;
	ZeroCount=0;
	do {
		DWORD Size,Read,Write;
		BYTE *p1,*p2,*pEnd;

		if (FileSize1.u.HighPart>0)
			Size=BufferSize;
		else
			Size=min(BufferSize,FileSize1.u.LowPart);
		if (!ReadFile(hFile1,pBuffer,Size,&Read,NULL) || Read!=Size
				|| !ReadFile(hFile2,pBuffer+BufferSize,Size,&Read,NULL)
															|| Read!=Size) {
			MessageBox(hwndMain,TEXT("t@Cǂݍ߂܂B"),NULL,
												MB_OK | MB_ICONEXCLAMATION);
			break;
		}
		p1=pBuffer;
		p2=pBuffer+BufferSize;
		pEnd=p2;
		do {
			if (*p1!=*p2) {
				if (*p1==0)
					*p1=*p2;
				else if (*p2!=0)
					break;
			} else if (*p1==0) {
				if (ZeroCount<ErrorLength)
					ZeroCount++;
			} else
				ZeroCount=0;
			p1++;
			p2++;
		} while (p1<pEnd);
		CurAddress+=p1-pBuffer;
		if (ZeroCount==ErrorLength && !fErrorContinue) {
			TCHAR szMessage[256],szAddress[17];

			FormatAddress(szAddress,CurAddress-ZeroCount);
			wsprintf(szMessage,
				TEXT("Cł܂B𑱍s܂?\nAddress : %s"),
																	szAddress);
			if (MessageBox(hwndMain,szMessage,NULL,
										MB_YESNO | MB_ICONEXCLAMATION)!=IDYES)
				break;
			fErrorContinue=TRUE;
		} else if (p1<pEnd) {
			TCHAR szMessage[256],szAddress[17];

			FormatAddress(szAddress,CurAddress);
			wsprintf(szMessage,
				TEXT("f[^v܂B\nAddress : %s (%02X / %02X)"),
															szAddress,*p1,*p2);
			MessageBox(hwndMain,szMessage,NULL,MB_OK | MB_ICONEXCLAMATION);
			break;
		}
		if (!WriteFile(hFixedFile,pBuffer,Size,&Write,NULL) || Write!=Size) {
			MessageBox(hwndMain,TEXT("t@Cɏ߂܂B"),NULL,
												MB_OK | MB_ICONEXCLAMATION);
			break;
		}
		FileSize1.QuadPart-=Size;
	} while (FileSize1.QuadPart>0);
	free(pBuffer);
	CloseHandle(hFixedFile);
	CloseHandle(hFile2);
	CloseHandle(hFile1);
	return FileSize1.QuadPart==0;
}


BOOL SetListBoxHExtent(HWND hDlg,int ID)
{
	HWND hwnd=GetDlgItem(hDlg,ID);
	int Count,MaxWidth=0;

	Count=SendMessage(hwnd,LB_GETCOUNT,0,0);
	if (Count>0) {
		HFONT hfont,hfontOld;
		HDC hdc;
		int i;
		TCHAR szText[MAX_PATH];
		SIZE sz;

		hfont=(HFONT)(UINT_PTR)SendMessage(hwnd,WM_GETFONT,0,0);
		if (hfont==NULL || (hdc=GetDC(hwnd))==NULL)
			return FALSE;
		hfontOld=SelectObject(hdc,hfont);
		for (i=0;i<Count;i++) {
			SendMessage(hwnd,LB_GETTEXT,i,(LPARAM)szText);
			GetTextExtentPoint32(hdc,szText,lstrlen(szText),&sz);
			if (sz.cx>MaxWidth)
				MaxWidth=sz.cx;
		}
		SelectObject(hdc,hfontOld);
		ReleaseDC(hwnd,hdc);
		MaxWidth+=2;	/* ] */
	}
	SendMessage(hwnd,LB_SETHORIZONTALEXTENT,MaxWidth,0);
	return TRUE;
}


void SetDlgItemState(HWND hDlg)
{
	int Count,Sel;

	Count=SendDlgItemMessage(hDlg,IDC_LIST,LB_GETCOUNT,0,0);
	Sel=(int)SendDlgItemMessage(hDlg,IDC_LIST,LB_GETCURSEL,0,0);
	EnableWindow(GetDlgItem(hDlg,IDC_REMOVE),Sel>=0);
	EnableWindow(GetDlgItem(hDlg,IDC_CLEAR),Count>0);
	EnableWindow(GetDlgItem(hDlg,IDOK),Count>0);
	EnableWindow(GetDlgItem(hDlg,IDC_RECOVERY),Sel>=0);
}


BOOL CALLBACK MainDlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	static BOOL fInProgress=FALSE,fExit=FALSE;

	switch (uMsg) {
	case WM_INITDIALOG:
		hwndMain=hDlg;
		SendMessage(hDlg,WM_SETICON,ICON_BIG,
							(LPARAM)LoadIcon(hInst,MAKEINTRESOURCE(IDI_ICON)));
		SetWindowPos(hDlg,NULL,WindowLeft,WindowTop,0,0,
													SWP_NOSIZE | SWP_NOZORDER);
		if (((LPTSTR)lParam)[0]!='\0') {
			LPCTSTR p;
			LPTSTR q;
			TCHAR szFile[MAX_PATH];

			p=(LPTSTR)lParam;
			while (*p!='\0') {
				q=szFile;
				if (*p=='"') {
					p++;
					while (*p!='\0') {
						if (*p=='"') {
							p++;
							break;
						}
						*q++=*p++;
					}
				} else {
					while (*p!='\0' && *p!=' ')
						*q++=*p++;
				}
				*q='\0';
				SendDlgItemMessage(hDlg,IDC_LIST,LB_ADDSTRING,0,
															(LPARAM)szFile);
				if (*p==' ')
					p++;
			}
			SetDlgItemState(hDlg);
			SetListBoxHExtent(hDlg,IDC_LIST);
		}
		SetDlgItemInt(hDlg,IDC_ERRORLENGTH,ErrorLength/1024,TRUE);
		CheckDlgButton(hDlg,IDC_SKIPJUNK,fSkipJunk?BST_CHECKED:BST_UNCHECKED);
		return TRUE;

	case WM_DROPFILES:
		{
			HDROP hDrop=(HDROP)wParam;
			int nFiles,i;
			TCHAR szFile[MAX_PATH];

			nFiles=DragQueryFile(hDrop,0xFFFFFFFF,NULL,0);
			for (i=0;i<nFiles;i++) {
				DragQueryFile(hDrop,i,szFile,MAX_PATH);
				if ((GetFileAttributes(szFile)&FILE_ATTRIBUTE_DIRECTORY)!=0) {
					HANDLE hFind;
					WIN32_FIND_DATA fd;
					TCHAR szPath[MAX_PATH];

					PathCombine(szPath,szFile,TEXT("*.*"));
					hFind=FindFirstFile(szPath,&fd);
					if (hFind!=INVALID_HANDLE_VALUE) {
						do {
							if ((fd.dwFileAttributes&
												FILE_ATTRIBUTE_DIRECTORY)==0) {
								PathCombine(szPath,szFile,fd.cFileName);
								SendDlgItemMessage(hDlg,IDC_LIST,LB_ADDSTRING,
															0,(LPARAM)szPath);
							}
						} while (FindNextFile(hFind,&fd));
						FindClose(hFind);
					}
				} else
					SendDlgItemMessage(hDlg,IDC_LIST,LB_ADDSTRING,0,
															(LPARAM)szFile);
			}
			DragFinish(hDrop);
			SetDlgItemState(hDlg);
			SetListBoxHExtent(hDlg,IDC_LIST);
		}
		return TRUE;

	case WM_SETCURSOR:
		if (fInProgress) {
			SetCursor(LoadCursor(NULL,IDC_APPSTARTING));
			SetWindowLongPtr(hDlg,DWLP_MSGRESULT,TRUE);
			return TRUE;
		}
		break;

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDC_LIST:
			if (HIWORD(wParam)==LBN_SELCHANGE)
				SetDlgItemState(hDlg);
			return TRUE;

		case IDC_REMOVE:
			{
				int Sel;

				Sel=(int)SendDlgItemMessage(hDlg,IDC_LIST,LB_GETCURSEL,0,0);
				if (Sel>=0) {
					SendDlgItemMessage(hDlg,IDC_LIST,LB_DELETESTRING,Sel,0);
					SetListBoxHExtent(hDlg,IDC_LIST);
				}
				SetDlgItemState(hDlg);
			}
			return TRUE;

		case IDC_CLEAR:
			SendDlgItemMessage(hDlg,IDC_LIST,LB_RESETCONTENT,0,0);
			SetDlgItemState(hDlg);
			SetListBoxHExtent(hDlg,IDC_LIST);
			return TRUE;

		case IDC_ERRORLENGTH:
			if (HIWORD(wParam)==EN_CHANGE) {
				ErrorLength=GetDlgItemInt(hDlg,IDC_ERRORLENGTH,NULL,TRUE)*1024;
				if (ErrorLength<=0)
					ErrorLength=DEFAULT_ERROR_LENGTH;
			}
			return TRUE;

		case IDC_SKIPJUNK:
			fSkipJunk=IsDlgButtonChecked(hDlg,IDC_SKIPJUNK)==BST_CHECKED;
			return TRUE;

		case IDC_RECOVERY:
			{
				int Sel;
				OPENFILENAME ofn;
				TCHAR szFileName[MAX_PATH],szRecoveryFileName[MAX_PATH];

				Sel=(int)SendDlgItemMessage(hDlg,IDC_LIST,LB_GETCURSEL,0,0);
				if (Sel<0)
					return TRUE;
				SendDlgItemMessage(hDlg,IDC_LIST,LB_GETTEXT,Sel,
														(LPARAM)szFileName);
				if (lstrlen(szFileName)+6>=MAX_PATH) {	/* +6 = ".fixed" */
					MessageBox(hDlg,
							TEXT("Ct@C̃t@C߂܂B"),
											NULL,MB_OK | MB_ICONEXCLAMATION);
					return TRUE;
				}
				lstrcpy(szRecoveryFileName,PathFindFileName(szFileName));
#if _WIN32_WINNT>=0x0500
				ofn.lStructSize=OPENFILENAME_SIZE_VERSION_400;
#else
				ofn.lStructSize=sizeof(OPENFILENAME);
#endif
				ofn.hwndOwner=hDlg;
				ofn.lpstrFilter=TEXT("ׂẴt@C(*.*)\0*.*\0");
				ofn.lpstrCustomFilter=NULL;
				ofn.nMaxCustFilter=0;
				ofn.nFilterIndex=1;
				ofn.lpstrFile=szRecoveryFileName;
				ofn.nMaxFile=MAX_PATH;
				ofn.lpstrFileTitle=NULL;
				ofn.lpstrInitialDir=NULL;
				ofn.lpstrTitle=TEXT("Cpt@C");
				ofn.lpstrDefExt=NULL;
				ofn.Flags=OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
				if (GetOpenFileName(&ofn)) {
					TCHAR szFixedFileName[MAX_PATH];
					HCURSOR hcurOld;
					BOOL fResult;

					lstrcpy(szFixedFileName,szFileName);
					PathRenameExtension(szFixedFileName,TEXT(".fixed"));
					lstrcat(szFixedFileName,PathFindExtension(szFileName));
					hcurOld=SetCursor(LoadCursor(NULL,IDC_WAIT));
					fResult=Recovery(szFixedFileName,szFileName,
														szRecoveryFileName);
					SetCursor(hcurOld);
					if (fResult)
						MessageBox(hDlg,TEXT("t@CC܂B"),
									TEXT("C"),MB_OK | MB_ICONINFORMATION);
					else
						DeleteFile(szFixedFileName);
				}
			}
			return TRUE;

		case IDOK:
			{
				int Files;

				if (fInProgress) {
					fAbort=TRUE;
					return TRUE;
				}
				Files=SendDlgItemMessage(hDlg,IDC_LIST,LB_GETCOUNT,0,0);
				if (Files>0) {
					HWND hwndProgress=GetDlgItem(hDlg,IDC_PROGRESS);
					int i;
					TCHAR szFile[MAX_PATH];

					fInProgress=TRUE;
					fAbort=FALSE;
					SetDlgItemText(hDlg,IDOK,TEXT("~"));
					EnableWindow(GetDlgItem(hDlg,IDC_REMOVE),FALSE);
					EnableWindow(GetDlgItem(hDlg,IDC_CLEAR),FALSE);
					EnableWindow(GetDlgItem(hDlg,IDC_ERRORLENGTH),FALSE);
					EnableWindow(GetDlgItem(hDlg,IDC_SKIPJUNK),FALSE);
					EnableWindow(GetDlgItem(hDlg,IDC_RECOVERY),FALSE);
					SendMessage(hwndProgress,PBM_SETRANGE,0,
														MAKELPARAM(0,Files));
					SendMessage(hwndProgress,PBM_SETPOS,0,0);
					SetCursor(LoadCursor(NULL,IDC_APPSTARTING));
					for (i=0;i<Files;i++) {
						SendDlgItemMessage(hDlg,IDC_LIST,LB_SETCURSEL,0,0);
						SendDlgItemMessage(hDlg,IDC_LIST,LB_GETTEXT,0,
															(LPARAM)szFile);
						if (!CheckFile(szFile))
							break;
						SendDlgItemMessage(hDlg,IDC_LIST,LB_DELETESTRING,0,0);
						SendMessage(hwndProgress,PBM_SETPOS,i+1,0);
						DoMessageLoop();
						if (fAbort)
							break;
					}
					fInProgress=FALSE;
					if (fExit)
						return TRUE;
					SetCursor(LoadCursor(NULL,IDC_ARROW));
					if (i==Files)
						MessageBox(hDlg,TEXT("j͌t܂łB"),
									TEXT(""),MB_OK | MB_ICONINFORMATION);
					SendMessage(hwndProgress,PBM_SETPOS,0,0);
					SetDlgItemText(hDlg,IDOK,TEXT("`FbN"));
					EnableWindow(GetDlgItem(hDlg,IDC_ERRORLENGTH),TRUE);
					EnableWindow(GetDlgItem(hDlg,IDC_SKIPJUNK),TRUE);
					SetDlgItemState(hDlg);
					SetListBoxHExtent(hDlg,IDC_LIST);
				}
			}
			return TRUE;

		case IDCANCEL:
			{
				WINDOWPLACEMENT wp;

				if (fInProgress)
					fExit=fAbort=TRUE;
				GetWindowPlacement(hDlg,&wp);
				WindowLeft=wp.rcNormalPosition.left;
				WindowTop=wp.rcNormalPosition.top;
				EndDialog(hDlg,IDCANCEL);
			}
		}
		return TRUE;
	}
	return FALSE;
}


#ifdef __BORLANDC__
#pragma argsused
#endif
int WINAPI _tWinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,
											LPTSTR lpszCmdLine,int nCmdShow)
{
	TCHAR szIniFileName[MAX_PATH];

	hInst=hInstance;
	GetModuleFileName(NULL,szIniFileName,MAX_PATH);
	GetLongPathName(szIniFileName,szIniFileName,MAX_PATH);
	PathRenameExtension(szIniFileName,TEXT(".ini"));
	ReadSettings(szIniFileName);
	InitCommonControls();
	DialogBoxParam(hInst,MAKEINTRESOURCE(IDD_MAIN),NULL,MainDlgProc,
														(LPARAM)lpszCmdLine);
	WriteSettings(szIniFileName);
	return 0;
}
